/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.io.Serializable;
import java.util.Arrays;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public interface Fifo<T>
extends Serializable {
    public void push(T var1);

    public T pop();

    public T peek();

    public boolean isEmpty();

    public boolean isFull();

    public int getLevel();

    default public int isEmptyBit() {
        return this.isEmpty() ? 1 : 0;
    }

    default public int isFullBit() {
        return this.isFull() ? 1 : 0;
    }

    default public void clear() {
        while (!this.isEmpty()) {
            this.pop();
        }
    }

    public static Fifo<Integer> createIntegerFixedSizeFifo(int fifoSize) {
        FixedSizeFifo<Integer> f = new FixedSizeFifo<Integer>(fifoSize);
        f.fifo = new Integer[fifoSize];
        Arrays.fill(f.fifo, (Object)0);
        return f;
    }

    public static class FixedSizeFifo<T>
    implements Fifo<T> {
        private static final long serialVersionUID = -6191940032925879269L;
        protected static final Logger LOG = LogHelper.getLogger(FixedSizeFifo.class.getSimpleName());
        public static final boolean logEnable = false;
        public static final boolean printToSysOut = false;
        private int popPointer;
        protected int pushPointer;
        private final int fifoSize;
        private int currentSize;
        protected T[] fifo;

        public FixedSizeFifo(int size) {
            this.fifoSize = size;
        }

        @Override
        public void push(T data) {
            if (this.isFull()) {
                LOG.info("FIFO full");
                return;
            }
            this.fifo[this.pushPointer] = data;
            this.pushPointer = (this.pushPointer + 1) % this.fifoSize;
            ++this.currentSize;
            this.logState(data, "push");
        }

        @Override
        public T pop() {
            if (this.isEmpty()) {
                LOG.info("FIFO empty");
                return null;
            }
            T entry = this.fifo[this.popPointer];
            this.popPointer = (this.popPointer + 1) % this.fifoSize;
            --this.currentSize;
            this.logState(entry, "pop");
            return entry;
        }

        @Override
        public T peek() {
            return this.fifo[this.popPointer];
        }

        @Override
        public boolean isEmpty() {
            return this.currentSize == 0;
        }

        @Override
        public boolean isFull() {
            return this.currentSize >= this.fifoSize;
        }

        @Override
        public int getLevel() {
            return this.currentSize;
        }

        protected void logState(T entry, String type) {
        }
    }
}

