/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.swing.filechooser.FileFilter;
import omegadrive.SystemLoader;
import omegadrive.ui.util.UiFileFilters;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.util.ZipUtil;
import org.slf4j.Logger;

public class FileUtil {
    private static final Logger LOG = LogHelper.getLogger(FileUtil.class.getSimpleName());
    private static final int[] EMPTY = new int[0];
    public static final File[] EMPTY_FILES = new File[0];
    public static final String basePath = System.getProperty("user.home") + File.separatorChar + "roms";
    private static final String SNAPSHOT_VERSION = "SNAPSHOT";
    private static final String MANIFEST_RELATIVE_PATH = "/META-INF/MANIFEST.MF";
    private static final String BIOS_JAR_PATH = ".";
    public static final String QUICK_SAVE_FILENAME = "quick_save";
    public static final String QUICK_SAVE_PATH = System.getProperty("quick.save.path", ".");
    public static final int SMD_HEADER_SIZE = 512;
    public static final int SMD_CHUNK_SIZE = 16384;

    public static void writeFileSafe(Path file, byte[] data) {
        Util.executorService.submit(() -> {
            try {
                Files.write(file, data, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Unable to write file {}, #data {}", new Object[]{file.toAbsolutePath(), data.length, e});
            }
        });
    }

    public static byte[] readFileSafe(Path file) {
        byte[] rom = new byte[]{};
        try {
            rom = Files.readAllBytes(file);
        }
        catch (IOException e) {
            LOG.error("Unable to load file: {}", (Object)file.toAbsolutePath());
        }
        return rom;
    }

    public static String readFileContentAsString(String fileName) {
        return String.join((CharSequence)"\n", FileUtil.readFileContent(fileName));
    }

    public static List<String> readFileContent(String fileName) {
        Path pathObj = Paths.get(BIOS_JAR_PATH, fileName);
        return FileUtil.readFileContent(pathObj);
    }

    public static List<String> readFileContent(Path pathObj) {
        List<String> lines = Collections.emptyList();
        String fileName = pathObj.getFileName().toString();
        if (Files.exists(pathObj, new LinkOption[0])) {
            try {
                lines = Files.readAllLines(pathObj);
            }
            catch (IOException e) {
                LOG.error("Unable to load {}, from path: {}", (Object)fileName, (Object)pathObj);
            }
            return lines;
        }
        String classPath = FileUtil.getCurrentClasspath();
        if (FileUtil.isRunningInJar(classPath)) {
            return FileUtil.loadFileContentFromJar(fileName);
        }
        LOG.warn("Unable to load: {}", (Object)fileName);
        return lines;
    }

    public static byte[] loadBiosFile(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            return FileUtil.readFileSafe(file);
        }
        String classPath = FileUtil.getCurrentClasspath();
        if (FileUtil.isRunningInJar(classPath)) {
            String fileName = file.getFileName().toString();
            return FileUtil.readFileFromJar(fileName);
        }
        LOG.error("Unable to load: {}", (Object)file.toAbsolutePath());
        return new byte[0];
    }

    private static byte[] readFileFromJar(String fileName) {
        ByteBuffer buffer = ByteBuffer.allocate(0);
        try (InputStream inputStream = FileUtil.class.getResourceAsStream("/" + fileName);){
            assert (inputStream != null);
            buffer = ByteBuffer.allocate(inputStream.available());
            while (inputStream.available() > 0) {
                buffer.put((byte)inputStream.read());
            }
        }
        catch (Exception e) {
            LOG.error("Unable to load {}, from path: {}", new Object[]{fileName, fileName, e});
        }
        return buffer.array();
    }

    private static List<String> loadFileContentFromJar(String fileName) {
        List<String> lines = Collections.emptyList();
        try (InputStream inputStream = FileUtil.class.getResourceAsStream("/" + fileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(inputStream)));){
            lines = reader.lines().collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.error("Unable to load {}, from path: {}", (Object)fileName, (Object)fileName);
        }
        return lines;
    }

    public static byte[] readBinaryFile(Path file, SystemLoader.SystemType systemType) {
        return FileUtil.readBinaryFile(file, UiFileFilters.ROM_FILTER);
    }

    private static byte[] readBinaryFile(Path file, FileFilter fileFilter) {
        byte[] data = new byte[]{};
        String fileName = file.toAbsolutePath().toString();
        try {
            if (!fileFilter.accept(file.toFile())) {
                throw new RuntimeException("Unexpected file: " + fileName);
            }
            data = FileUtil.readBinaryFile(file, new String[0]);
        }
        catch (Exception e) {
            LOG.error("Unable to load: {}", (Object)fileName, (Object)e);
        }
        return data;
    }

    public static byte[] readBinaryFile(Path file, String ... ext) {
        String fileName = file.toAbsolutePath().toString();
        byte[] data = new byte[]{};
        data = ZipUtil.isZipFile.test(fileName) ? ZipUtil.readZipFileContents(file, ext) : (ZipUtil.isGZipFile.test(fileName) ? ZipUtil.readGZipFileContents(file) : FileUtil.readFileSafe(file));
        if (SystemLoader.smdFileAsInterleaved && fileName.toLowerCase().contains(".smd")) {
            LOG.info("SMD interleaved file detected: {}", (Object)fileName);
            data = FileUtil.unscrambleSmd(data);
        }
        return data;
    }

    public static byte[] unscrambleSmd(byte[] input) {
        byte[] output = new byte[input.length - 512];
        int k = 0;
        for (int i = 512; i < input.length; i += 16384) {
            int remainHalf = Math.min(16384, input.length - i) >> 1;
            int j = 0;
            while (j < remainHalf) {
                output[k + 1] = input[i + j];
                output[k] = input[i + j + remainHalf];
                ++j;
                k += 2;
            }
        }
        return output;
    }

    public static String loadVersionFromManifest() {
        String version = SNAPSHOT_VERSION;
        String classPath = FileUtil.getCurrentClasspath();
        if (!FileUtil.isRunningInJar(classPath)) {
            LOG.info("Not running from a JAR, using version: {}", (Object)version);
            return version;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + MANIFEST_RELATIVE_PATH;
        try (InputStream is = new URL(manifestPath).openStream();){
            Manifest manifest = new Manifest(is);
            Attributes attr = manifest.getMainAttributes();
            version = attr.getValue("Implementation-Version");
            LOG.info("Using version from Manifest: {}", (Object)version);
        }
        catch (Exception e) {
            LOG.error("Unable to load manifest file: {}", (Object)manifestPath);
        }
        return version;
    }

    private static String getCurrentClasspath() {
        Class<FileUtil> clazz = FileUtil.class;
        String className = clazz.getSimpleName() + ".class";
        return Objects.requireNonNull(clazz.getResource(className)).toString();
    }

    private static boolean isRunningInJar(String classPath) {
        return classPath.startsWith("jar");
    }

    public static String getFileName(Path rom) {
        Object n = rom.getFileName().toString();
        try {
            String m = rom.toFile().getCanonicalFile().getName();
            if (!((String)n).equalsIgnoreCase(m)) {
                n = m + " (" + (String)n + ")";
            }
        }
        catch (Exception e) {
            LOG.error("Error", (Throwable)e);
        }
        return n;
    }

    public static int readShortLE(RandomAccessFile file) throws IOException {
        return (short)((file.read() << 0) + (file.read() << 8));
    }

    public static int readShortBE(RandomAccessFile file) throws IOException {
        return (short)((file.read() << 8) + file.read());
    }

    public static File[] listFilesSafe(File folder) {
        return Util.optWarnOnce(folder.listFiles()).orElse(EMPTY_FILES);
    }
}

