/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

public enum Size {
    BYTE(128, 255),
    WORD(32768, 65535),
    LONG(Integer.MIN_VALUE, -1);

    public static final Size[] vals;
    final int msb;
    final int max;
    final int byteSize;

    private Size(int msb, int maxSize) {
        this.msb = msb;
        this.max = maxSize;
        this.byteSize = Math.max(1, this.ordinal() << 1);
    }

    public int getMsb() {
        return this.msb;
    }

    public int getMax() {
        return this.max;
    }

    public int getMask() {
        return this.max;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public static int getMaxFromByteCount(int byteCount) {
        switch (byteCount) {
            case 1: {
                return Size.BYTE.max;
            }
            case 2: {
                return Size.WORD.max;
            }
            case 4: {
                return Size.LONG.max;
            }
        }
        return 0;
    }

    static {
        vals = Size.values();
    }
}

