/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.util.concurrent.locks.LockSupport;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class Sleeper {
    public static final boolean BUSY_WAIT;
    public static final long SLEEP_RESOLUTION_NS = 50000L;
    private static final Logger LOG;

    public static boolean isWindows() {
        return Util.OS_NAME.contains("win");
    }

    private static void startSleeperThread() {
        if (Sleeper.isWindows()) {
            Runnable r = () -> Util.sleep(Long.MAX_VALUE);
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("sleeperForWindows");
            t.start();
        }
    }

    private static void handleSleepDelay(long prev, long now, long expectedIntervalNs) {
        if (now - prev > expectedIntervalNs + Util.MILLI_IN_NS) {
            LOG.info("JVM over-sleeping ({} ms): {}", (Object)((double)expectedIntervalNs / (double)Util.MILLI_IN_NS), (Object)((double)(now - prev) / (double)Util.MILLI_IN_NS));
        }
    }

    private static void handleSlowdown(String when, long now, long deadlineNs) {
        if (now > deadlineNs + Util.MILLI_IN_NS) {
            // empty if block
        }
    }

    public static void parkFuzzy(long intervalNs) {
        if (intervalNs < 50000L) {
            return;
        }
        Sleeper.parkExactly(intervalNs - 50000L);
    }

    public static void parkExactly(long intervalNs) {
        long nowNs;
        boolean done;
        assert (intervalNs > 0L);
        if (intervalNs < 50000L) {
            return;
        }
        if (BUSY_WAIT) {
            long deadlineNs = System.nanoTime() + intervalNs;
            while (System.nanoTime() < deadlineNs) {
                Thread.yield();
            }
            return;
        }
        long start = System.nanoTime();
        long deadlineNs = start + intervalNs;
        if (deadlineNs < start) {
            Sleeper.handleSlowdown("Before", start, deadlineNs);
            return;
        }
        do {
            LockSupport.parkNanos(intervalNs);
            nowNs = System.nanoTime();
            intervalNs = Math.max(deadlineNs - intervalNs, 50000L);
        } while (!(done = nowNs > deadlineNs));
        Sleeper.handleSlowdown("After", System.nanoTime(), deadlineNs);
    }

    public static void parkExactlyHybrid(long intervalNs) {
        if (BUSY_WAIT) {
            long deadlineNs = System.nanoTime() + intervalNs;
            while (System.nanoTime() < deadlineNs) {
                Thread.yield();
            }
            return;
        }
        long start = System.nanoTime();
        long deadlineNs = start + intervalNs;
        if (deadlineNs < start) {
            Sleeper.handleSlowdown("Before", start, deadlineNs);
            return;
        }
        long now = System.nanoTime();
        if (intervalNs > Util.MILLI_IN_NS) {
            long remainingNs = intervalNs;
            long spinIntervalNs = Util.MILLI_IN_NS;
            do {
                long prevNow = System.nanoTime();
                LockSupport.parkNanos(remainingNs - spinIntervalNs);
                now = System.nanoTime();
                Sleeper.handleSleepDelay(prevNow, now, remainingNs - spinIntervalNs);
            } while ((remainingNs = deadlineNs - now) > spinIntervalNs);
            Sleeper.handleSlowdown("After-park", now, deadlineNs);
        }
        while (now < deadlineNs) {
            Thread.yield();
            now = System.nanoTime();
        }
        Sleeper.handleSlowdown("After-spin", now, deadlineNs);
    }

    static {
        LOG = LogHelper.getLogger(Util.class.getSimpleName());
        Sleeper.startSleeperThread();
        BUSY_WAIT = Boolean.parseBoolean(System.getProperty("helios.busy.wait", "false"));
        LOG.info("Busy waiting instead of sleeping: {}", (Object)BUSY_WAIT);
    }
}

