/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.CRC32;
import omegadrive.Device;
import omegadrive.memory.IMemoryProvider;
import omegadrive.memory.IMemoryRom;
import omegadrive.util.JmxBridge;
import omegadrive.util.LogHelper;
import omegadrive.util.PriorityThreadFactory;
import omegadrive.util.Size;
import org.slf4j.Logger;

public class Util {
    private static final Logger LOG = LogHelper.getLogger(Util.class.getSimpleName());
    public static boolean verbose = false;
    public static final int GEN_NTSC_MCLOCK_MHZ = 53693175;
    public static final int GEN_PAL_MCLOCK_MHZ = 53203424;
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final String NATIVE_SUBDIR = OS_NAME.contains("win") ? "windows" : (OS_NAME.contains("mac") ? "osx" : "linux");
    public static final long SECOND_IN_NS = Duration.ofSeconds(1L).toNanos();
    public static final long MILLI_IN_NS = Duration.ofMillis(1L).toNanos();
    public static final boolean randomInitRam = Boolean.parseBoolean(System.getProperty("helios.random.init.ram", "false"));
    public static final Random random;
    static final int CACHE_LIMIT = Short.MIN_VALUE;
    public static final VarHandle SHORT_BYTEARR_HANDLE;
    public static final VarHandle INT_BYTEARR_HANDLE;
    public static final VarHandle SHORT_BYTEBUF_HANDLE;
    public static final VarHandle INT_BYTEBUF_HANDLE;
    static final Integer[] negativeCache;
    public static final ExecutorService executorService;
    private static final Object lock;

    private static void uncaughtException(Thread t, Throwable e) {
        LOG.error("uncaughtException fot thread: {}", (Object)t.getName(), (Object)e);
        e.printStackTrace();
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForever() {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void waitOnBarrier(CyclicBarrier barrier, boolean verbose) {
        try {
            barrier.await();
        }
        catch (Exception e) {
            if (verbose) {
                LOG.warn("Error on barrier", (Throwable)e);
            } else {
                LOG.info("Leaving barrier: {}", (Object)e.getClass().getName());
            }
            barrier.reset();
        }
    }

    public static void waitOnBarrier(CyclicBarrier barrier) {
        Util.waitOnBarrier(barrier, true);
    }

    public static boolean trySignalCondition(Lock lock, Condition condition) {
        if (lock.tryLock()) {
            try {
                condition.signal();
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    public static void waitOnCondition(Lock lock, Condition condition) {
        try {
            lock.lock();
            try {
                condition.await();
            }
            catch (Exception e) {
                LOG.warn("Error on condition", (Throwable)e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitOnObject(Object object, long ms) {
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait(ms);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitOnObject(Object object) {
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static byte[] initMemoryRandomBytes(byte[] mem2) {
        if (!randomInitRam) {
            return mem2;
        }
        for (int i = 0; i < mem2.length; ++i) {
            mem2[i] = (byte)random.nextInt(256);
        }
        return mem2;
    }

    public static ByteBuffer initMemoryRandomBytes(ByteBuffer mem2) {
        if (!randomInitRam) {
            return mem2;
        }
        for (int i = 0; i < mem2.capacity(); ++i) {
            mem2.put((byte)random.nextInt(256));
        }
        return mem2;
    }

    public static void registerJmx(Object object) {
        JmxBridge.registerJmx(object);
    }

    public static boolean bitSetTest(int number, int position) {
        assert (position >= 0 && position < 32);
        return (number & 1 << position) != 0;
    }

    public static int setBit(int val, int bitPos, int bitValue) {
        assert ((bitValue & 1) == bitValue) : bitValue;
        assert (bitPos >= 0 && bitPos < 32);
        return val & ~(1 << bitPos) | bitValue << bitPos;
    }

    public static int readBufferByte(ByteBuffer b, int pos) {
        return b.get(pos);
    }

    public static int readBufferWord(ByteBuffer b, int pos) {
        assert ((pos & 1) == 0);
        return b.getShort(pos);
    }

    public static int readBufferLong(ByteBuffer b, int pos) {
        assert ((pos & 1) == 0);
        return b.getInt(pos);
    }

    public static int readDataMask(byte[] src, int address, int mask, Size size) {
        return Util.readData(src, address & mask, size);
    }

    public static int readData(byte[] src, int address, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.WORD -> (src[address] & 0xFF) << 8 | src[address + 1] & 0xFF;
            case Size.LONG -> (src[address] & 0xFF) << 24 | (src[address + 1] & 0xFF) << 16 | (src[address + 2] & 0xFF) << 8 | src[address + 3] & 0xFF;
            case Size.BYTE -> src[address];
        };
    }

    public static void writeData(byte[] dest, int address, int data, Size size) {
        switch (size) {
            case WORD: {
                SHORT_BYTEARR_HANDLE.set(dest, address, (short)data);
                break;
            }
            case LONG: {
                INT_BYTEARR_HANDLE.set(dest, address, data);
                break;
            }
            case BYTE: {
                dest[address] = (byte)data;
            }
        }
    }

    public static void writeDataMask(byte[] dest, int address, int data, int mask, Size size) {
        Util.writeData(dest, address & mask, data, size);
    }

    @Deprecated
    public static int computeChecksum(IMemoryProvider memoryProvider) {
        int i;
        int res = 0;
        int size = memoryProvider.getRomSize();
        int mask = memoryProvider.getRomMask();
        for (i = 512; i < size - 1; i += 2) {
            int val = Util.readDataMask(memoryProvider.getRomData(), i, mask, Size.WORD);
            res = res + val & 0xFFFF;
        }
        res = size % 2 != 0 ? res + memoryProvider.readRomByte(i) & 0xFFFF : res;
        return res;
    }

    public static String computeSha1Sum(byte[] data) {
        Hasher h = Hashing.sha1().newHasher();
        IntStream.range(0, data.length).forEach(i -> h.putByte(data[i]));
        return BaseEncoding.base16().lowerCase().encode(h.hash().asBytes());
    }

    public static String computeSha1Sum(IMemoryRom rom) {
        return Util.computeSha1Sum(rom.getRomData());
    }

    public static String computeCrc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        IntStream.range(0, data.length).forEach(i -> crc32.update(data[i]));
        return Long.toHexString(crc32.getValue());
    }

    public static String computeCrc32(IMemoryRom rom) {
        return Util.computeCrc32(rom.getRomData());
    }

    public static int log2(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    public static String toStringValue(byte ... data) {
        return new String(data);
    }

    public static String th(short pos) {
        return Integer.toHexString(pos & 0xFFFF);
    }

    public static String th(int pos) {
        return Integer.toHexString(pos);
    }

    public static String th(long pos) {
        return Long.toHexString(pos);
    }

    public static byte[] getPaddedRom(byte[] data) {
        int romSize = data.length;
        int mask = Util.getRomMask(romSize);
        if (mask >= romSize) {
            byte[] newrom = new byte[mask + 1];
            Arrays.fill(newrom, (byte)-1);
            System.arraycopy(data, 0, newrom, 0, romSize);
            return newrom;
        }
        return data;
    }

    public static int getRomMask(int size) {
        int log2 = Util.log2(size);
        int pow2 = (int)Math.pow(2.0, log2);
        if (size == pow2) {
            return size - 1;
        }
        return (int)Math.pow(2.0, log2 + 1) - 1;
    }

    public static Integer getFromIntegerCache(int val) {
        if (val < 0 && val >= Short.MIN_VALUE) {
            return negativeCache[-val];
        }
        return val;
    }

    public static byte[] serializeObject(Serializable obj) {
        byte[] res = new byte[]{};
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(obj);
            oos.flush();
            res = bos.toByteArray();
        }
        catch (Exception e) {
            LOG.error("Unable to serialize object: {}, {}", (Object)obj.getClass().getSimpleName(), (Object)e.getMessage());
        }
        if (res.length == 0) {
            LOG.error("Unable to serialize object: {}", (Object)obj.getClass().getSimpleName());
        }
        return res;
    }

    public static Serializable deserializeObject(ByteBuffer data) {
        return Util.deserializeObject(data.array(), 0, data.capacity());
    }

    public static Serializable deserializeObject(byte[] data) {
        return Util.deserializeObject(data, 0, data.length);
    }

    public static Serializable deserializeObject(byte[] data, int offset, int len) {
        if (data == null || data.length == 0 || offset < 0 || len > data.length) {
            LOG.error("Unable to deserialize object of len: {}", data != null ? Integer.valueOf(data.length) : "null");
            return null;
        }
        Serializable res = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data, offset, len);
             ObjectInputStream in = new ObjectInputStream(bis);){
            res = (Serializable)in.readObject();
        }
        catch (Exception e) {
            LOG.error("Unable to deserialize object of len: {}, {}", (Object)data.length, (Object)e.getMessage());
        }
        return res;
    }

    public static <T, V extends Device> Optional<V> getDeviceIfAny(Collection<T> deviceSet, Class<V> clazz) {
        return deviceSet.stream().filter(t -> clazz.isAssignableFrom(t.getClass())).findFirst().map(clazz::cast);
    }

    public static <T, V extends Device> Set<V> getAllDevices(Collection<T> deviceSet, Class<V> clazz) {
        return deviceSet.stream().filter(t -> clazz.isAssignableFrom(t.getClass())).map(clazz::cast).collect(Collectors.toSet());
    }

    public static String getNameWithoutExtension(String file) {
        Objects.requireNonNull(file);
        String fileName = new File(file).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    public static int getBitFromByte(byte b, int bitPos) {
        assert (bitPos >= 0 && bitPos < 8);
        return b >> bitPos & 1;
    }

    public static int getBitFromWord(short b, int bitPos) {
        assert (bitPos >= 0 && bitPos < 16);
        return b >> bitPos & 1;
    }

    public static boolean assertCheckBusOp(int address, Size size) {
        return true;
    }

    public static Runnable wrapRunnableEx(Runnable r) {
        return () -> {
            try {
                r.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
    }

    public static <T> Optional<T> optWarnOnce(T obj) {
        if (obj == null) {
            LogHelper.logWarnOnce(LOG, "Object of class {} is null", obj.getClass());
        }
        return Optional.ofNullable(obj);
    }

    static {
        SHORT_BYTEARR_HANDLE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
        INT_BYTEARR_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
        SHORT_BYTEBUF_HANDLE = MethodHandles.byteBufferViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
        INT_BYTEBUF_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
        negativeCache = new Integer[32769];
        executorService = Executors.newSingleThreadExecutor(new PriorityThreadFactory("util"));
        int j = 0;
        for (int i = 0; i < negativeCache.length; ++i) {
            Util.negativeCache[i] = j--;
        }
        long seed = System.currentTimeMillis();
        random = new Random(seed);
        LOG.info("Creating Random with seed: {}", (Object)seed);
        LOG.info("Init RAM with random values: {}", (Object)randomInitRam);
        Thread.setDefaultUncaughtExceptionHandler(Util::uncaughtException);
        lock = new Object();
    }
}

