/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import omegadrive.system.SysUtil;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class ZipUtil {
    public static final String GZIP_EXT = ".gz";
    public static final String ZIP_EXT = ".zip";
    public static final Predicate<String> isZipFile = n -> n.endsWith(ZIP_EXT);
    public static final Predicate<String> isGZipFile = n -> n.endsWith(GZIP_EXT);
    static final BiPredicate<ZipEntry, String[]> isSupportedBinaryType = (ze, ext) -> Arrays.stream(ext).anyMatch(t -> ze.getName().contains((CharSequence)t));
    private static final Logger LOG = LogHelper.getLogger(ZipUtil.class.getSimpleName());

    public static boolean isZipArchiveByteStream(Path path) {
        return isZipFile.test(path.getFileName().toString().toLowerCase());
    }

    public static boolean isGZipByteStream(Path path) {
        return isGZipFile.test(path.getFileName().toString().toLowerCase());
    }

    public static boolean isCompressedByteStream(Path path) {
        return ZipUtil.isZipArchiveByteStream(path) || ZipUtil.isGZipByteStream(path);
    }

    public static Optional<? extends ZipEntry> getSupportedZipEntryIfAny(Path zipFilePath, String ... ext) {
        String[] extArray = ext == null || ext.length == 0 ? SysUtil.binaryTypes : ext;
        Optional<Object> entry = Optional.empty();
        try (ZipFile zipFile = new ZipFile(zipFilePath.toFile());){
            entry = zipFile.stream().filter(e -> isSupportedBinaryType.test((ZipEntry)e, extArray)).findFirst();
        }
        catch (Exception e2) {
            LOG.error("Unable to parse contents {}", (Object)zipFilePath.toAbsolutePath(), (Object)e2);
        }
        return entry;
    }

    public static String getGZipFileName(Path path) {
        return path.getFileName().toString().replace(GZIP_EXT, "");
    }

    public static byte[] readZipFileContents(Path path, String ... ext) {
        assert (Arrays.stream(ext).noneMatch(ex -> ex.endsWith(ZIP_EXT)));
        Optional<? extends ZipEntry> entry = ZipUtil.getSupportedZipEntryIfAny(path, ext);
        return entry.map(e -> ZipUtil.readZipFileImpl(path, e)).orElse(new byte[0]);
    }

    private static byte[] readZipFileImpl(Path path, ZipEntry entry) {
        byte[] res = new byte[]{};
        try (ZipFile zipFile = new ZipFile(path.toFile());
             InputStream is = zipFile.getInputStream(entry);){
            res = ByteStreams.toByteArray((InputStream)is);
            LOG.info("Using zipEntry: {}", (Object)entry.getName());
        }
        catch (Exception e) {
            LOG.error("Unable to parse contents {}", (Object)path.toAbsolutePath(), (Object)e);
        }
        return res;
    }

    public static byte[] readGZipFileContents(Path path) {
        byte[] res = new byte[]{};
        try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);
             GZIPInputStream zis = new GZIPInputStream(fis);){
            res = ByteStreams.toByteArray((InputStream)zis);
        }
        catch (Exception e) {
            LOG.error("Unable to parse contents {}", (Object)path.toAbsolutePath(), (Object)e);
        }
        return res;
    }

    public static void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

