/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import omegadrive.SystemLoader;
import omegadrive.system.SystemProvider;
import omegadrive.ui.RenderingStrategy;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.VdpInterruptHandlerHelper;
import omegadrive.vdp.md.VdpInterruptHandler;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.BaseVdpProvider;

public class SmsVdp
implements BaseVdpProvider {
    public static final int VDP_VRAM_SIZE = 16384;
    public static final int VDP_CRAM_SIZE = 32;
    public static final int VDP_REGISTERS_SIZE = 16;
    public static final boolean ENABLE_TILEMAP_MIRRORING = false;
    public static final int NTSC = 0;
    public static final int PAL = 1;
    public static int palFlag = 0;
    private static final int SMS_WIDTH = 256;
    private static final int SMS_HEIGHT = 240;
    public static final int GG_WIDTH = 160;
    public static final int GG_HEIGHT = 144;
    public static final int GG_X_OFFSET = 48;
    public static final int GG_Y_OFFSET = 24;
    private final byte[] VRAM;
    private final int[] CRAM;
    private final int[] vdpreg;
    private int status;
    public static final int STATUS_VINT = 128;
    public static final int STATUS_OVERFLOW = 64;
    public static final int STATUS_COLLISION = 32;
    public static final int STATUS_HINT = 4;
    private boolean firstByte;
    private int commandByte;
    private int location;
    private int operation;
    private int readBuffer;
    public int line;
    private int counter;
    private final boolean[] bgPriority;
    private final int[][] lineSprites = new int[240][25];
    private int bgt;
    private static final int BGT_LENGTH = 1792;
    private int vScrollLatch;
    private final boolean[] spriteCol;
    private int[] display;
    private int[] ggDisplay;
    private static int[] SMS_JAVA;
    private static int[] GG_JAVA1;
    private static int[] GG_JAVA2;
    public static int h_start;
    public static int h_end;
    private int sat;
    private boolean isSatDirty;
    private static final int SPRITES_PER_LINE = 8;
    private int[] screenData = new int[0];
    private static final int SPRITE_COUNT = 0;
    private static final int SPRITE_X = 1;
    private static final int SPRITE_Y = 2;
    private static final int SPRITE_N = 3;
    private static final int TOTAL_TILES = 512;
    private static final int TILE_SIZE = 8;
    private int[][] tiles;
    private boolean[] isTileDirty;
    private int minDirty;
    private int maxDirty;
    private final VdpInterruptHandler interruptHandler;
    private final boolean isSms;
    private VideoMode ggVideoMode = VideoMode.NTSCU_H20_V18;
    private RegionDetector.Region region;
    private VideoMode videoMode;
    private final List<BaseVdpAdapterEventSupport.VdpEventListener> list;
    final int[] vdpState = new int[3];

    public SmsVdp(SystemProvider systemProvider) {
        this(systemProvider.getSystemType(), systemProvider.getRegion());
    }

    public SmsVdp(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        this.isSms = systemType == SystemLoader.SystemType.SMS;
        this.setSystemType(systemType);
        this.vdpreg = new int[16];
        this.bgPriority = new boolean[256];
        this.spriteCol = new boolean[256];
        this.createCachedImages();
        this.region = region;
        this.list = new ArrayList<BaseVdpAdapterEventSupport.VdpEventListener>();
        this.interruptHandler = VdpInterruptHandlerHelper.createSmsInstance(this);
        this.VRAM = Util.initMemoryRandomBytes(new byte[16384]);
        this.CRAM = new int[32];
        this.resetVideoMode(true);
        LOG.info("Initial video mode: {}, {}", (Object)this.videoMode, (Object)this.videoMode.getDimension());
    }

    @Override
    public final void reset() {
        this.generateConvertedPals();
        this.firstByte = true;
        this.location = 0;
        this.counter = 0;
        this.status = 0;
        this.operation = 0;
        this.vdpreg[0] = 4;
        this.vdpreg[1] = 0;
        this.vdpreg[2] = 14;
        this.vdpreg[3] = 0;
        this.vdpreg[4] = 0;
        this.vdpreg[5] = 126;
        this.vdpreg[6] = 0;
        this.vdpreg[7] = 0;
        this.vdpreg[8] = 0;
        this.vdpreg[9] = 0;
        this.vdpreg[10] = 0;
        this.vScrollLatch = 0;
        this.isSatDirty = true;
        this.minDirty = 512;
        this.maxDirty = -1;
        this.resetVideoMode(true);
    }

    @Override
    public void init() {
        this.reset();
    }

    private void setSystemType(SystemLoader.SystemType type) {
        h_start = this.isSms ? 0 : 5;
        int n = h_end = this.isSms ? 32 : 27;
        if (!this.isSms) {
            int nump = this.ggVideoMode.getDimension().width * this.ggVideoMode.getDimension().height;
            this.ggDisplay = new int[nump];
        }
        this.ggVideoMode = this.isSms ? this.videoMode : VideoMode.NTSCU_H20_V18;
        LOG.info("Setting {} mode", (Object)type);
    }

    @Override
    public void setRegion(RegionDetector.Region region) {
        this.region = region;
    }

    @Override
    public void resetVideoMode(boolean force) {
        boolean hasChanged;
        int data = (this.vdpreg[0] & 4) << 1 | (this.vdpreg[1] & 8) >> 1 | this.vdpreg[0] & 2 | (this.vdpreg[1] & 0x10) >> 4;
        VideoMode newVideoMode = switch (data) {
            case 14 -> this.region == RegionDetector.Region.EUROPE ? VideoMode.PAL_H32_V30 : (this.region == RegionDetector.Region.USA ? VideoMode.NTSCU_H32_V30 : VideoMode.NTSCJ_H32_V30);
            case 11 -> this.region == RegionDetector.Region.EUROPE ? VideoMode.PAL_H32_V28 : (this.region == RegionDetector.Region.USA ? VideoMode.NTSCU_H32_V28 : VideoMode.NTSCJ_H32_V30);
            default -> this.region == RegionDetector.Region.EUROPE ? VideoMode.PAL_H32_V24 : (this.region == RegionDetector.Region.USA ? VideoMode.NTSCU_H32_V24 : VideoMode.NTSCJ_H32_V24);
        };
        boolean bl = hasChanged = this.videoMode != newVideoMode;
        if (hasChanged || force) {
            if (hasChanged) {
                LOG.info("Video mode changed: {}, {}", (Object)newVideoMode, (Object)newVideoMode.getDimension());
            }
            this.videoMode = newVideoMode;
            palFlag = this.videoMode.isPal() ? 1 : 0;
            this.display = new int[this.videoMode.getDimension().width * this.videoMode.getDimension().height];
            this.screenData = this.isSms ? this.display : this.ggDisplay;
            this.forceFullRedraw();
            this.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.VIDEO_MODE, (Object)newVideoMode);
        }
    }

    public final void forceFullRedraw() {
        this.refreshBgtAddress(this.vdpreg[2]);
        this.minDirty = 0;
        this.maxDirty = 511;
        Arrays.fill(this.isTileDirty, true);
        this.refreshSatAddress(this.vdpreg[5]);
        this.isSatDirty = true;
    }

    public int getHCount() {
        return this.interruptHandler.getHCounterExternal();
    }

    public int getVCount() {
        return this.interruptHandler.getVCounterExternal();
    }

    public int getStatus() {
        return this.status;
    }

    public final int controlRead() {
        this.firstByte = true;
        int statuscopy = this.status;
        this.status = 0;
        this.interruptHandler.setHIntPending(false);
        this.interruptHandler.setvIntPending(false);
        return statuscopy;
    }

    public final void controlWrite(int value) {
        if (this.firstByte) {
            this.firstByte = false;
            this.commandByte = value;
            this.location = this.location & 0x3F00 | value;
        } else {
            this.firstByte = true;
            this.operation = value >> 6 & 3;
            this.location = this.commandByte | value << 8;
            if (this.operation == 0) {
                this.readBuffer = this.VRAM[this.location++ & 0x3FFF] & 0xFF;
            } else if (this.operation == 2) {
                this.registerWrite(value, this.commandByte);
            }
        }
    }

    public void registerWrite(int value, int commandByte) {
        int reg = value & 0xF;
        switch (reg) {
            case 0: {
                break;
            }
            case 1: {
                if ((commandByte & 3) == (this.vdpreg[reg] & 3)) break;
                this.isSatDirty = true;
                break;
            }
            case 2: {
                this.refreshBgtAddress(commandByte);
                break;
            }
            case 5: {
                int old = this.sat;
                this.refreshSatAddress(commandByte);
                if (old == this.sat) break;
                this.isSatDirty = true;
                break;
            }
            case 10: {
                if (commandByte == this.vdpreg[reg]) break;
                this.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.REG_H_LINE_COUNTER_CHANGE, commandByte);
            }
        }
        int prev = this.vdpreg[reg];
        this.vdpreg[reg] = commandByte;
        if (reg < 2 && prev != this.vdpreg[reg]) {
            this.resetVideoMode(false);
        }
    }

    public final int dataRead() {
        this.firstByte = true;
        int value = this.readBuffer;
        this.readBuffer = this.VRAM[this.location++ & 0x3FFF] & 0xFF;
        return value;
    }

    public final void dataWrite(byte val) {
        this.firstByte = true;
        int value = val & 0xFF;
        switch (this.operation) {
            case 0: 
            case 1: 
            case 2: {
                int address = this.location & 0x3FFF;
                if (value == this.VRAM[address]) break;
                if (address >= this.sat && address < this.sat + 64) {
                    this.isSatDirty = true;
                } else if (address >= this.sat + 128 && address < this.sat + 256) {
                    this.isSatDirty = true;
                } else {
                    int tileIndex = address >> 5;
                    this.isTileDirty[tileIndex] = true;
                    if (tileIndex < this.minDirty) {
                        this.minDirty = tileIndex;
                    }
                    if (tileIndex > this.maxDirty) {
                        this.maxDirty = tileIndex;
                    }
                }
                this.VRAM[address] = val;
                break;
            }
            case 3: {
                if (this.isSms) {
                    this.CRAM[this.location & 0x1F] = SMS_JAVA[value & 0x3F];
                    break;
                }
                if ((this.location & 1) == 0) {
                    this.CRAM[(this.location & 0x3F) >> 1] = GG_JAVA1[value];
                    break;
                }
                int n = (this.location & 0x3F) >> 1;
                this.CRAM[n] = this.CRAM[n] | GG_JAVA2[value & 0xF];
            }
        }
        this.readBuffer = value;
        ++this.location;
    }

    public boolean isVINT() {
        return (this.vdpreg[1] & 0x20) > 0 && (this.status & 0x80) > 0;
    }

    public boolean isHINT() {
        return (this.vdpreg[0] & 0x10) > 0 && (this.status & 4) > 0;
    }

    public VdpInterruptHandler getInterruptHandler() {
        return this.interruptHandler;
    }

    private void refreshBgtAddress(int reg2) {
        this.bgt = this.videoMode.isV24() ? (reg2 & 0xE) << 10 : 1792 + ((reg2 & 0xC) << 10);
    }

    private void refreshSatAddress(int reg5) {
        this.sat = (reg5 & 0x7E) << 7;
    }

    public final void drawLine(int lineno) {
        if (!(this.isSms || lineno >= 24 && lineno < 168)) {
            return;
        }
        int i = this.spriteCol.length;
        while (i-- != 0) {
            this.spriteCol[i] = false;
        }
        if ((this.vdpreg[1] & 0x40) != 0) {
            if (this.maxDirty != -1) {
                this.decodeTiles();
            }
            this.drawBg(lineno);
            if (this.isSatDirty) {
                this.decodeSat();
            }
            if (this.lineSprites[lineno][0] != 0) {
                this.drawSprite(lineno);
            }
            if (this.isSms && (this.vdpreg[0] & 0x20) != 0) {
                int colour = this.CRAM[16 + (this.vdpreg[7] & 0xF)];
                int location = lineno << 8;
                this.display[location++] = colour;
                this.display[location++] = colour;
                this.display[location++] = colour;
                this.display[location++] = colour;
                this.display[location++] = colour;
                this.display[location++] = colour;
                this.display[location++] = colour;
                this.display[location] = colour;
            }
        } else {
            this.drawBGColour(lineno);
        }
    }

    private void drawBg(int lineno) {
        int hscroll = this.vdpreg[8];
        int vscroll = this.vScrollLatch;
        if (lineno < 16 && (this.vdpreg[0] & 0x40) != 0) {
            hscroll = 0;
        }
        int lock = this.vdpreg[0] & 0x80;
        int tile_column = 32 - (hscroll >> 3) + h_start;
        int vscrollShift = this.videoMode.isV24() ? 28 : 32;
        int tile_row = lineno + vscroll >> 3;
        tile_row = tile_row >= vscrollShift ? tile_row - vscrollShift : tile_row;
        int tile_y = (lineno + (vscroll & 7) & 7) << 3;
        int rowprecal = lineno << 8;
        for (int tx = h_start; tx < h_end; ++tx) {
            int tile_props = this.bgt + ((tile_column & 0x1F) << 1) + (tile_row << 6);
            int secondbyte = this.VRAM[tile_props + 1] & 0xFF;
            int pal = (secondbyte & 8) << 1;
            int sx = (tx << 3) + (hscroll & 7);
            int pixY = (secondbyte & 4) == 0 ? tile_y : 56 - tile_y;
            int[] tile = this.tiles[(this.VRAM[tile_props] & 0xFF) + ((secondbyte & 1) << 8)];
            if ((secondbyte & 2) == 0) {
                for (pixX = 0; pixX < 8 && sx < 256; ++pixX, ++sx) {
                    colour = tile[pixX + pixY];
                    this.bgPriority[sx] = (secondbyte & 0x10) != 0 && colour != 0;
                    this.display[sx + rowprecal] = this.CRAM[colour + pal];
                }
            } else {
                for (pixX = 7; pixX >= 0 && sx < 256; --pixX, ++sx) {
                    colour = tile[pixX + pixY];
                    this.bgPriority[sx] = (secondbyte & 0x10) != 0 && colour != 0;
                    this.display[sx + rowprecal] = this.CRAM[colour + pal];
                }
            }
            ++tile_column;
            if (lock == 0 || tx != 23) continue;
            tile_row = lineno >> 3;
            tile_y = (lineno & 7) << 3;
        }
    }

    private void drawSprite(int lineno) {
        int[] sprites = this.lineSprites[lineno];
        int count = Math.min(8, sprites[0]);
        int zoomed = this.vdpreg[1] & 1;
        int row_precal = lineno << 8;
        int off = count * 3;
        int i = count;
        while (i-- != 0) {
            int colour;
            int n = sprites[off--] | (this.vdpreg[6] & 4) << 6;
            int y = sprites[off--];
            int x = sprites[off--] - (this.vdpreg[0] & 8);
            int tileRow = lineno - y >> zoomed;
            if ((this.vdpreg[1] & 2) != 0) {
                n &= 0xFFFFFFFE;
            }
            int[] tile = this.tiles[n + ((tileRow & 8) >> 3)];
            int pix = 0;
            if (x < 0) {
                pix = -x;
                x = 0;
            }
            int offset = pix + ((tileRow & 7) << 3);
            if (zoomed == 0) {
                while (pix < 8 && x < 256) {
                    if ((colour = tile[offset++]) != 0 && !this.bgPriority[x]) {
                        this.display[x + row_precal] = this.CRAM[colour + 16];
                        if (!this.spriteCol[x]) {
                            this.spriteCol[x] = true;
                        } else {
                            this.status |= 0x20;
                        }
                    }
                    ++pix;
                    ++x;
                }
                continue;
            }
            while (pix < 8 && x < 256) {
                if ((colour = tile[offset++]) != 0 && !this.bgPriority[x]) {
                    this.display[x + row_precal] = this.CRAM[colour + 16];
                    if (!this.spriteCol[x]) {
                        this.spriteCol[x] = true;
                    } else {
                        this.status |= 0x20;
                    }
                }
                if (colour != 0 && !this.bgPriority[x + 1]) {
                    this.display[x + row_precal + 1] = this.CRAM[colour + 16];
                    if (!this.spriteCol[x + 1]) {
                        this.spriteCol[x + 1] = true;
                    } else {
                        this.status |= 0x20;
                    }
                }
                ++pix;
                x += 2;
            }
        }
        if (sprites[0] >= 8) {
            this.status |= 0x40;
        }
    }

    private void drawBGColour(int lineno) {
        int colour = this.CRAM[16 + (this.vdpreg[7] & 0xF)];
        int row_precal = lineno << 8;
        int x = 256;
        while (x-- != 0) {
            this.display[row_precal++] = colour;
        }
    }

    private void generateConvertedPals() {
        block4: {
            int i;
            block3: {
                if (!this.isSms || SMS_JAVA != null) break block3;
                SMS_JAVA = new int[64];
                for (int i2 = 0; i2 < SMS_JAVA.length; ++i2) {
                    int r = i2 & 3;
                    int g = i2 >> 2 & 3;
                    int b = i2 >> 4 & 3;
                    SmsVdp.SMS_JAVA[i2] = r * 85 << 16 | g * 85 << 8 | b * 85;
                }
                break block4;
            }
            if (this.isSms || GG_JAVA1 != null) break block4;
            GG_JAVA1 = new int[256];
            GG_JAVA2 = new int[16];
            for (i = 0; i < GG_JAVA1.length; ++i) {
                int g = i & 0xF;
                int b = i >> 4 & 0xF;
                SmsVdp.GG_JAVA1[i] = g << 20 | g << 16 | b << 12 | b << 8;
            }
            for (i = 0; i < GG_JAVA2.length; ++i) {
                SmsVdp.GG_JAVA2[i] = i << 4 | i;
            }
        }
    }

    private void createCachedImages() {
        this.tiles = new int[512][64];
        this.isTileDirty = new boolean[512];
    }

    private void decodeTiles() {
        for (int i = this.minDirty; i <= this.maxDirty; ++i) {
            if (!this.isTileDirty[i]) continue;
            this.isTileDirty[i] = false;
            int[] tile = this.tiles[i];
            int pixel_index = 0;
            int address = i << 5;
            for (int y = 0; y < 8; ++y) {
                int address0 = this.VRAM[address++] & 0xFF;
                int address1 = this.VRAM[address++] & 0xFF;
                int address2 = this.VRAM[address++] & 0xFF;
                int address3 = this.VRAM[address++] & 0xFF;
                for (int bit = 128; bit != 0; bit >>= 1) {
                    int colour = 0;
                    if ((address0 & bit) != 0) {
                        colour |= 1;
                    }
                    if ((address1 & bit) != 0) {
                        colour |= 2;
                    }
                    if ((address2 & bit) != 0) {
                        colour |= 4;
                    }
                    if ((address3 & bit) != 0) {
                        colour |= 8;
                    }
                    tile[pixel_index++] = colour;
                }
            }
        }
        this.minDirty = 512;
        this.maxDirty = -1;
    }

    private void decodeSat() {
        int height;
        this.isSatDirty = false;
        int i = this.lineSprites.length;
        while (i-- != 0) {
            this.lineSprites[i][0] = 0;
        }
        int n = height = (this.vdpreg[1] & 2) == 0 ? 8 : 16;
        if ((this.vdpreg[1] & 1) == 1) {
            height <<= 1;
        }
        boolean isV24 = this.videoMode.isV24();
        for (int spriteno = 0; spriteno < 64; ++spriteno) {
            int y = this.VRAM[this.sat + spriteno] & 0xFF;
            if (isV24 && y == 208) {
                return;
            }
            if (++y > 240) {
                y -= 256;
            }
            for (int lineno = 0; lineno < 240; ++lineno) {
                int[] sprites;
                if (lineno < y || lineno - y >= height || (sprites = this.lineSprites[lineno])[0] >= 8) continue;
                int off = sprites[0] * 3 + 1;
                int address = this.sat + (spriteno << 1) + 128;
                sprites[off++] = this.VRAM[address++] & 0xFF;
                sprites[off++] = y;
                sprites[off++] = this.VRAM[address] & 0xFF;
                sprites[0] = sprites[0] + 1;
            }
        }
    }

    public int[] getState() {
        int[] state = new int[3 + this.vdpreg.length + this.CRAM.length];
        state[0] = palFlag | this.status << 8 | (this.firstByte ? 65536 : 0) | this.commandByte << 24;
        state[1] = this.location | this.operation << 16 | this.readBuffer << 24;
        state[2] = this.counter | this.vScrollLatch << 8 | this.line << 16;
        System.arraycopy(this.vdpreg, 0, state, 3, this.vdpreg.length);
        System.arraycopy(this.CRAM, 0, state, 3 + this.vdpreg.length, this.CRAM.length);
        return state;
    }

    public int[] getStateSimple(int[] state) {
        state[0] = palFlag | this.status << 8 | (this.firstByte ? 65536 : 0) | this.commandByte << 24;
        state[1] = this.location | this.operation << 16 | this.readBuffer << 24;
        state[2] = this.counter | this.vScrollLatch << 8 | this.line << 16;
        return state;
    }

    public void setStateSimple(int[] state) {
        int temp = state[0];
        palFlag = temp & 0xFF;
        this.status = temp >> 8 & 0xFF;
        this.firstByte = (temp >> 16 & 0xFF) != 0;
        this.commandByte = temp >> 24 & 0xFF;
        temp = state[1];
        this.location = temp & 0xFFFF;
        this.operation = temp >> 16 & 0xFF;
        this.readBuffer = temp >> 24 & 0xFF;
        temp = state[2];
        this.counter = temp & 0xFF;
        this.vScrollLatch = temp >> 8 & 0xFF;
        this.line = temp >> 16 & 0xFFFF;
    }

    public void setState(int[] state) {
        this.setStateSimple(state);
        System.arraycopy(state, 3, this.vdpreg, 0, this.vdpreg.length);
        System.arraycopy(state, 3 + this.vdpreg.length, this.CRAM, 0, this.CRAM.length);
        this.forceFullRedraw();
    }

    @Override
    public int runSlot() {
        this.line = this.interruptHandler.getvCounterInternal();
        boolean vBlank = this.interruptHandler.isvBlankSet();
        this.interruptHandler.increaseHCounter();
        boolean vBlankTrigger = !vBlank && this.interruptHandler.isvBlankSet();
        int newLine = this.interruptHandler.getvCounterInternal();
        int h = this.videoMode.getDimension().height;
        if (this.line != newLine && !vBlank && this.line < h) {
            if (this.line == 0) {
                this.vScrollLatch = this.vdpreg[9];
            }
            this.drawLine(this.line);
        }
        this.status |= vBlankTrigger ? 128 : 0;
        this.status |= this.interruptHandler.isHIntPending() ? 4 : 0;
        if (vBlankTrigger) {
            this.resizeGG(!this.isSms);
            this.list.forEach(BaseVdpAdapterEventSupport.VdpEventListener::onNewFrame);
        }
        return 0;
    }

    private void resizeGG(boolean doResize) {
        if (!doResize) {
            return;
        }
        RenderingStrategy.subImageWithOffset(this.display, this.ggDisplay, this.videoMode.getDimension(), this.ggVideoMode.getDimension(), 48, 24);
    }

    @Override
    public List<BaseVdpAdapterEventSupport.VdpEventListener> getVdpEventListenerList() {
        return this.list;
    }

    @Override
    public void dumpScreenData() {
    }

    @Override
    public int getRegisterData(int reg) {
        return this.vdpreg[reg];
    }

    @Override
    public void updateRegisterData(int reg, int data) {
        this.vdpreg[reg] = data;
    }

    @Override
    public VideoMode getVideoMode() {
        return this.isSms ? this.videoMode : this.ggVideoMode;
    }

    public byte[] getVRAM() {
        return this.VRAM;
    }

    public int[] getCRAM() {
        return this.CRAM;
    }

    @Override
    public int[] getScreenDataLinear() {
        return this.screenData;
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        IntStream.range(0, 16).forEach(i -> buffer.put((byte)this.getRegisterData(i)));
        this.getStateSimple(this.vdpState);
        buffer.put((byte)72).put((byte)69).put((byte)76);
        buffer.putInt(this.vdpState[0]).putInt(this.vdpState[1]).putInt(this.vdpState[2]);
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        IntStream.range(0, 16).forEach(i -> this.registerWrite(i, buffer.get() & 0xFF));
        String helString = Util.toStringValue(buffer.get(), buffer.get(), buffer.get());
        if ("HEL".equals(helString)) {
            this.vdpState[0] = buffer.getInt();
            this.vdpState[1] = buffer.getInt();
            this.vdpState[2] = buffer.getInt();
            this.setStateSimple(this.vdpState);
        }
    }
}

