/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.md;

import omegadrive.Device;
import omegadrive.bus.md.BusArbiter;
import omegadrive.util.LogHelper;
import omegadrive.util.VideoMode;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.BaseVdpProvider;
import omegadrive.vdp.model.InterlaceMode;
import omegadrive.vdp.model.VdpCounterMode;
import omegadrive.vdp.model.VdpSlotType;
import org.slf4j.Logger;

public class VdpInterruptHandler
implements BaseVdpAdapterEventSupport.VdpEventListener,
Device {
    private static final Logger LOG = LogHelper.getLogger(VdpInterruptHandler.class.getSimpleName());
    public static final int COUNTER_LIMIT = 511;
    public static final int VBLANK_CLEAR = 511;
    public static final int VINT_SET_ON_HCOUNTER_VALUE = 1;
    protected int hCounterInternal;
    protected int vCounterInternal;
    public int hLinePassed = 0;
    private int pixelNumber = 0;
    private int slotNumber = 0;
    private int hLinesCounter = 0;
    private VideoMode videoMode;
    private InterlaceMode interlaceMode = InterlaceMode.NONE;
    protected VdpCounterMode vdpCounterMode;
    protected final BaseVdpAdapterEventSupport vdpEvent;
    protected boolean h40;
    protected boolean vBlankSet;
    private boolean hBlankSet;
    private boolean vIntPending;
    protected boolean hIntPending;
    protected static final boolean verbose = false;
    private static final String STATE_FMT_STR = "%s, slot=0x%x, hce=0x%x(0x%x), vce=0x%x(0x%x), hb%d, vb%d, VINTPend%d, HINTPend%d, hLines=%d";

    protected VdpInterruptHandler(BaseVdpAdapterEventSupport vdp) {
        this.vdpEvent = vdp;
        vdp.addVdpEventListener(this);
    }

    public static VdpInterruptHandler createMdInstance(BaseVdpProvider vdp) {
        VdpInterruptHandler handler = new VdpInterruptHandler(vdp);
        handler.reset();
        return handler;
    }

    protected void setMode(VideoMode videoMode) {
        if (this.videoMode != videoMode) {
            this.videoMode = videoMode;
            this.vdpCounterMode = VdpCounterMode.getCounterMode(videoMode);
            this.h40 = videoMode.isH40();
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.slotNumber = 0;
        this.pixelNumber = 0;
        this.hCounterInternal = 0;
        this.vCounterInternal = 511;
        this.hBlankSet = false;
        this.vBlankSet = false;
        this.vIntPending = false;
        this.hIntPending = false;
        this.resetHLinesCounter();
    }

    private int updateCounterValue(int counterInternal, int jumpTrigger, int totalCount) {
        ++counterInternal;
        if ((counterInternal &= 0x1FF) == jumpTrigger + 1) {
            counterInternal = 512 + (jumpTrigger + 1) - totalCount;
        }
        return counterInternal;
    }

    private int increaseVCounterInternal() {
        this.vCounterInternal = this.updateCounterValue(this.vCounterInternal, this.vdpCounterMode.vJumpTrigger, this.vdpCounterMode.vTotalCount);
        this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.V_COUNT_INC, this.vCounterInternal);
        this.handleHLinesCounterDecrement();
        if (this.vCounterInternal == this.vdpCounterMode.vBlankSet) {
            this.vBlankSet = true;
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.V_BLANK_CHANGE, true);
        } else if (this.vCounterInternal == 511) {
            this.vBlankSet = false;
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.V_BLANK_CHANGE, false);
        }
        return this.vCounterInternal;
    }

    public final int increaseHCounterSlot() {
        this.increaseHCounterInternal();
        return this.increaseHCounterInternal();
    }

    public int increaseHCounter() {
        return this.increaseHCounterInternal();
    }

    private int increaseHCounterInternal() {
        this.hCounterInternal = this.updateCounterValue(this.hCounterInternal, this.vdpCounterMode.hJumpTrigger, this.vdpCounterMode.hTotalCount);
        this.pixelNumber = (this.pixelNumber + 1) % this.vdpCounterMode.hTotalCount;
        this.slotNumber = this.pixelNumber >> 1;
        if (this.hCounterInternal == this.vdpCounterMode.hBlankSet) {
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.H_BLANK_CHANGE, true);
            this.hBlankSet = true;
        } else if (this.hCounterInternal == this.vdpCounterMode.hBlankClear) {
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.H_BLANK_CHANGE, false);
            this.hBlankSet = false;
        } else if (this.hCounterInternal == this.vdpCounterMode.hActiveDisplayEnd) {
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.VDP_ACTIVE_DISPLAY_CHANGE, false);
        } else if (this.hCounterInternal == this.vdpCounterMode.hActiveDisplayStart) {
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.VDP_ACTIVE_DISPLAY_CHANGE, true);
        }
        if (this.hCounterInternal == this.vdpCounterMode.vCounterIncrementOn) {
            this.increaseVCounterInternal();
        }
        if (this.vCounterInternal == this.vdpCounterMode.vBlankSet && this.hCounterInternal == 1) {
            this.setvIntPending(true);
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.INTERRUPT, (Object)BusArbiter.InterruptEvent.Z80_INT_ON);
        } else if (this.vCounterInternal == this.vdpCounterMode.vBlankSet + 1 && this.hCounterInternal == 1) {
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.INTERRUPT, (Object)BusArbiter.InterruptEvent.Z80_INT_OFF);
        }
        return this.hCounterInternal;
    }

    private void handleHLinesCounterDecrement() {
        --this.hLinePassed;
        if (this.vBlankSet) {
            this.resetHLinesCounter();
        }
        if (this.hLinePassed < 0) {
            this.setHIntPending(true);
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.H_LINE_UNDERFLOW, this.vCounterInternal);
            this.resetHLinesCounter();
        }
    }

    public boolean isvBlankSet() {
        return this.vBlankSet;
    }

    public int getvCounterInternal() {
        return this.vCounterInternal;
    }

    public int gethCounterInternal() {
        return this.hCounterInternal;
    }

    public int getVCounterExternal() {
        if (this.interlaceMode.isInterlaced()) {
            return this.getVCounterExternalInterlace();
        }
        return this.vCounterInternal & 0xFF;
    }

    private int getVCounterExternalInterlace() {
        int vc = this.vCounterInternal;
        vc <<= this.interlaceMode.ordinal() >> 1;
        vc = vc & 0xFFFFFFFE | vc >> 8 & 1;
        return vc & 0xFF;
    }

    public int getHCounterExternal() {
        return this.hCounterInternal >> 1 & 0xFF;
    }

    public boolean isvIntPending() {
        return this.vIntPending;
    }

    public void setvIntPending(boolean vIntPending) {
        if (this.vIntPending != vIntPending) {
            this.vIntPending = vIntPending;
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.VDP_VINT_PENDING, vIntPending);
        }
    }

    public boolean isHIntPending() {
        return this.hIntPending;
    }

    public void setHIntPending(boolean hIntPending) {
        if (hIntPending != this.hIntPending) {
            this.hIntPending = hIntPending;
            this.vdpEvent.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.VDP_HINT_PENDING, hIntPending);
        }
    }

    public int getVdpClockSpeed() {
        return this.h40 && this.hCounterInternal < 482 ? 4 : 5;
    }

    public boolean isEndOfFrameCounter() {
        return this.vCounterInternal == 511 && this.hCounterInternal == 511;
    }

    public boolean isExternalSlot(boolean isBlanking) {
        VdpSlotType type = this.vdpCounterMode.getSlotTypes()[this.slotNumber];
        if (!isBlanking) {
            return type == VdpSlotType.EXTERNAL;
        }
        return type != VdpSlotType.REFRESH;
    }

    public int resetHLinesCounter() {
        this.hLinePassed = this.hLinesCounter;
        return this.hLinePassed;
    }

    @Override
    public void onVdpEvent(BaseVdpAdapterEventSupport.VdpEvent event, Object value) {
        switch (event) {
            case VIDEO_MODE: {
                this.setMode((VideoMode)((Object)value));
                break;
            }
            case REG_H_LINE_COUNTER_CHANGE: {
                this.hLinesCounter = (Integer)value;
                break;
            }
            case INTERLACE_MODE_CHANGE: {
                this.interlaceMode = (InterlaceMode)((Object)value);
                break;
            }
        }
    }

    public final String getStateString(String head) {
        return String.format(STATE_FMT_STR, head, this.slotNumber, this.hCounterInternal >> 1 & 0xFF, this.hCounterInternal, this.vCounterInternal & 0xFF, this.vCounterInternal, this.hBlankSet ? 1 : 0, this.vBlankSet ? 1 : 0, this.vIntPending ? 1 : 0, this.hIntPending ? 1 : 0, this.hLinesCounter);
    }
}

