/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.md;

import java.nio.ByteBuffer;
import omegadrive.util.Util;
import omegadrive.vdp.model.InterlaceMode;
import omegadrive.vdp.model.RenderPriority;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.model.VdpMisc;

public class VdpScrollHandler {
    protected ByteBuffer vram;
    protected ByteBuffer vsram;

    public static VdpScrollHandler createInstance(VdpMemoryInterface memoryInterface) {
        VdpScrollHandler v = new VdpScrollHandler();
        v.vram = memoryInterface.getVram();
        v.vsram = memoryInterface.getVsram();
        return v;
    }

    public int getHorizontalScroll(int line, ScrollContext sc) {
        int vramOffset = sc.hScrollTableLocation;
        switch (sc.hScrollType) {
            case SCREEN: {
                break;
            }
            case CELL: {
                vramOffset += line >> 3 << 5;
                break;
            }
            case INVALID: 
            case LINE: {
                vramOffset += line << 2;
            }
        }
        int scrollDataShift = sc.planeWidth << 3;
        int scrollMask = scrollDataShift - 1;
        vramOffset = sc.planeType == VdpMisc.RenderType.PLANE_A ? vramOffset : vramOffset + 2;
        int scrollAmount = Util.readBufferWord(this.vram, vramOffset) & scrollMask;
        return scrollDataShift - scrollAmount;
    }

    public int getVerticalScroll(int twoCell, ScrollContext sc) {
        int scrollMask = (sc.planeHeight << 3) - 1;
        int vramOffset = sc.planeType == VdpMisc.RenderType.PLANE_A ? 0 : 2;
        int scrollAmount = Util.readBufferWord(this.vsram, vramOffset += sc.vScrollType == VSCROLL.TWO_CELLS ? twoCell << 2 : 0) >> sc.interlaceMode.verticalScrollShift();
        return scrollAmount & scrollMask;
    }

    public static class ScrollContext {
        final VdpMisc.RenderType planeType;
        final int[] plane;
        final RenderPriority highPrio;
        final RenderPriority lowPrio;
        int planeWidth;
        int planeHeight;
        int hScrollTableLocation;
        VSCROLL vScrollType;
        HSCROLL hScrollType;
        InterlaceMode interlaceMode;

        private ScrollContext(VdpMisc.RenderType type, int[] plane) {
            this.planeType = type;
            this.highPrio = RenderPriority.getRenderPriority(type, true);
            this.lowPrio = RenderPriority.getRenderPriority(type, false);
            this.plane = plane;
        }

        public static ScrollContext createInstance(VdpMisc.RenderType type, int[] plane) {
            return new ScrollContext(type, plane);
        }
    }

    static enum HSCROLL {
        SCREEN(0),
        CELL(2),
        LINE(3),
        INVALID(1);

        private static final HSCROLL[] lookupRegValue;

        private HSCROLL(int regValue) {
        }

        public static HSCROLL getHScrollType(int regValue) {
            return lookupRegValue[regValue];
        }

        static {
            lookupRegValue = new HSCROLL[]{SCREEN, INVALID, CELL, LINE};
        }
    }

    static enum VSCROLL {
        SCREEN(0),
        TWO_CELLS(1);

        private static final VSCROLL[] lookupRegValue;

        private VSCROLL(int regValue) {
        }

        public static VSCROLL getVScrollType(int regValue) {
            return lookupRegValue[regValue];
        }

        static {
            lookupRegValue = new VSCROLL[]{SCREEN, TWO_CELLS};
        }
    }
}

