/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;

public interface BaseVdpAdapterEventSupport {
    default public List<VdpEventListener> getVdpEventListenerList() {
        return Collections.emptyList();
    }

    default public void fireVdpEvent(VdpEvent event, Object value) {
        List<VdpEventListener> l = this.getVdpEventListenerList();
        for (int i = 0; i < l.size(); ++i) {
            l.get(i).onVdpEvent(event, value);
        }
    }

    default public void fireVdpEventOnChange(VdpEvent event, Object prev, Object value) {
        if (prev != value) {
            this.fireVdpEvent(event, value);
        }
    }

    default public boolean addVdpEventListener(VdpEventListener l) {
        List<VdpEventListener> l1 = this.getVdpEventListenerList();
        boolean res = l1.add(l);
        l1.sort(Comparator.comparingInt(VdpEventListener::order));
        return res;
    }

    default public boolean removeVdpEventListener(VdpEventListener l) {
        return this.getVdpEventListenerList().remove(l);
    }

    public static interface VdpEventListener
    extends EventListener {
        default public int order() {
            return 0;
        }

        default public void onVdpEvent(VdpEvent event, Object value) {
        }

        default public void onRegisterChange(int reg, int value) {
        }

        default public void onNewFrame() {
            this.onVdpEvent(VdpEvent.NEW_FRAME, null);
        }
    }

    public static enum VdpEvent {
        NEW_FRAME,
        VIDEO_MODE,
        REG_H_LINE_COUNTER_CHANGE,
        INTERRUPT,
        LEFT_COL_BLANK,
        H_LINE_UNDERFLOW,
        H_BLANK_CHANGE,
        V_COUNT_INC,
        V_BLANK_CHANGE,
        INTERLACE_FIELD_CHANGE,
        INTERLACE_MODE_CHANGE,
        VDP_VINT_PENDING,
        VDP_ACTIVE_DISPLAY_CHANGE,
        VDP_HINT_PENDING,
        VDP_IE0_VINT,
        VDP_IE1_HINT,
        VDP_IE2_EXT_INT;

    }
}

