/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

import java.util.EnumSet;
import omegadrive.util.LogHelper;
import omegadrive.util.VideoMode;
import omegadrive.vdp.model.VdpSlotType;
import org.slf4j.Logger;

public enum VdpCounterMode {
    PAL_H32_V28(VideoMode.PAL_H32_V28),
    PAL_H32_V30(VideoMode.PAL_H32_V30),
    PAL_H40_V28(VideoMode.PAL_H40_V28),
    PAL_H40_V30(VideoMode.PAL_H40_V30),
    NTSCJ_H32_V28(VideoMode.NTSCJ_H32_V28),
    NTSCU_H32_V28(VideoMode.NTSCU_H32_V28),
    NTSCJ_H32_V30(VideoMode.NTSCJ_H32_V30),
    NTSCU_H32_V30(VideoMode.NTSCU_H32_V30),
    NTSCJ_H40_V28(VideoMode.NTSCJ_H40_V28),
    NTSCU_H40_V28(VideoMode.NTSCU_H40_V28),
    NTSCJ_H40_V30(VideoMode.NTSCJ_H40_V30),
    NTSCU_H40_V30(VideoMode.NTSCU_H40_V30),
    NTSCJ_H32_V24(VideoMode.NTSCJ_H32_V24),
    NTSCU_H32_V24(VideoMode.NTSCU_H32_V24),
    PAL_H32_V24(VideoMode.PAL_H32_V24);

    private static final EnumSet<VdpCounterMode> values;
    private static final Logger LOG;
    public final int hTotalCount;
    public final int hJumpTrigger;
    public final int hBlankSet;
    public final int hBlankClear;
    public final int hBlankClearSlot;
    public final int hActiveDisplayStart;
    public final int hActiveDisplayEnd;
    public final int vTotalCount;
    public final int vJumpTrigger;
    public final int vBlankSet;
    public final int vCounterIncrementOn;
    public final int slotsPerLine;
    final VideoMode videoMode;
    final VdpSlotType[] slotTypes;

    private VdpCounterMode(VideoMode videoMode) {
        boolean isH32 = videoMode.isH32();
        boolean isV30 = videoMode.isV30();
        boolean isV28 = videoMode.isV28();
        boolean isV24 = videoMode.isV24();
        boolean isPal = videoMode.isPal();
        this.hTotalCount = isH32 ? 342 : 420;
        this.hJumpTrigger = isH32 ? 295 : 364;
        this.hBlankSet = isH32 ? 294 : 358;
        this.hBlankClear = isH32 ? 10 : 11;
        this.hBlankClearSlot = this.hBlankClear >> 1;
        this.hActiveDisplayStart = isH32 ? 24 : 26;
        this.hActiveDisplayEnd = isH32 ? 280 : 345;
        this.vTotalCount = videoMode.isPal() ? 313 : 262;
        this.vCounterIncrementOn = isH32 ? 266 : 330;
        this.videoMode = videoMode;
        this.slotTypes = isH32 ? VdpSlotType.h32Slots : VdpSlotType.h40Slots;
        int n2 = this.slotsPerLine = isH32 ? 171 : 210;
        int n3 = isPal ? (isV30 ? 266 : (isV28 ? 258 : 242)) : (isV30 ? 242 : (this.vJumpTrigger = isV28 ? 234 : 218));
        this.vBlankSet = isV30 ? 240 : (isV28 ? 224 : 192);
    }

    public static VdpCounterMode getCounterMode(VideoMode videoMode) {
        for (VdpCounterMode v : values) {
            if (v.videoMode != videoMode) continue;
            return v;
        }
        LOG.error("Unable to find counter mode for videoMode: {}", (Object)videoMode);
        return null;
    }

    public VdpSlotType[] getSlotTypes() {
        return this.slotTypes;
    }

    public int getSlotsPerLine() {
        return this.slotsPerLine;
    }

    static {
        values = EnumSet.allOf(VdpCounterMode.class);
        LOG = LogHelper.getLogger(VdpCounterMode.class.getSimpleName());
    }
}

