/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.vdp.md.VdpColorMapper;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.util.UpdatableViewer;
import org.slf4j.Logger;

public class CramViewer
implements UpdatableViewer {
    private static final Logger LOG = LogHelper.getLogger(CramViewer.class.getSimpleName());
    private static final int CRAM_ENTRIES = 64;
    private static final int LABEL_HEIGHT = 100;
    private static final int LABEL_WIDTH = 10;
    private static final int FRAME_HEIGHT = 150;
    private static final int FRAME_WIDTH = 690;
    private static final int ROWS = 4;
    private final VdpMemoryInterface vdpMemoryInterface;
    private JPanel cramPanel;
    private final VdpColorMapper colorMapper;
    private final JPanel[] panelList = new JPanel[64];

    private CramViewer(VdpMemoryInterface vdpMemoryInterface) {
        this.vdpMemoryInterface = vdpMemoryInterface;
        this.colorMapper = VdpColorMapper.getInstance();
        this.cramPanel = new JPanel();
        this.initPanel();
    }

    public static CramViewer createInstance(VdpMemoryInterface vdpMemoryInterface) {
        return new CramViewer(vdpMemoryInterface);
    }

    private void initPanel() {
        SwingUtilities.invokeLater(() -> {
            int labelPerLine = 16;
            this.cramPanel = new JPanel(new GridLayout(5, labelPerLine));
            this.cramPanel.setBackground(Color.GRAY);
            this.cramPanel.setSize(665, 125);
            this.cramPanel.add(new JLabel());
            for (int i = 0; i < labelPerLine; ++i) {
                JLabel label = new JLabel(Util.th(i));
                label.setHorizontalAlignment(0);
                label.setBackground(Color.WHITE);
                label.setForeground(Color.BLACK);
                this.cramPanel.add(label);
            }
            int k = 0;
            int rowCnt = 0;
            for (int i = 0; i < 128; i += 2) {
                if (k % labelPerLine == 0) {
                    JLabel label = new JLabel(Util.th(rowCnt * labelPerLine));
                    label.setHorizontalAlignment(0);
                    label.setBackground(Color.WHITE);
                    label.setForeground(Color.BLACK);
                    this.cramPanel.add(label);
                    ++rowCnt;
                }
                JPanel cpanel = new JPanel();
                cpanel.setBackground(Color.BLACK);
                cpanel.setForeground(Color.BLACK);
                cpanel.setName("CRAM" + k);
                cpanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                cpanel.setMaximumSize(new Dimension(10, 100));
                this.panelList[k] = cpanel;
                this.cramPanel.add(cpanel);
                ++k;
            }
        });
    }

    public JPanel getPanel() {
        return this.cramPanel;
    }

    @Override
    public void update() {
        SwingUtilities.invokeLater(() -> {
            int k = 0;
            for (int i = 0; i < 128; i += 2) {
                int cramColor = this.vdpMemoryInterface.readVideoRamWord(MdVdpProvider.VdpRamType.CRAM, i);
                int rgb = this.colorMapper.getColor(cramColor);
                Color c = new Color(rgb);
                JPanel label = this.panelList[k];
                label.setBackground(c);
                label.setForeground(c);
                ++k;
            }
        });
    }
}

