/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HexFormat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import omegadrive.Device;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.memory.ReadableByteMemory;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.util.UpdatableViewer;
import omegadrive.vdp.util.VdpDebugView;
import org.slf4j.Logger;

public class MemView
implements Device,
UpdatableViewer {
    private static final Logger LOG = LogHelper.getLogger(MemView.class.getSimpleName());
    public static final MemView NO_MEMVIEW = new MemView(){

        @Override
        public void update() {
        }

        @Override
        public void init() {
        }
    };
    protected static final MemViewData[] mdMemViewData = MdMemViewType.values();
    private JFrame frame;
    private JPanel panel;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private JComboBox<MemViewData> listComp;
    private volatile byte[] data;
    private AtomicReference<MemViewData> currentViewRef = new AtomicReference<MdMemViewType>(MdMemViewType.values()[0]);
    private final Map<MemViewOwner, BiFunction<MemViewData, Integer, Integer>> readerMap;
    private final StringBuilder sb = new StringBuilder();
    private final MemViewData[] memViewData;
    private int cnt = 0;
    private AtomicInteger qLen = new AtomicInteger(0);
    private static final int BYTES_PER_LINE = 16;

    public static UpdatableViewer createInstance(MdMainBusProvider m, VdpMemoryInterface vdpMem) {
        return MemView.createInstance(mdMemViewData, m, null, vdpMem);
    }

    public static UpdatableViewer createInstance(MemViewData[] memViewData, MdMainBusProvider m, ReadableByteMemory s32x, VdpMemoryInterface vdpMem) {
        return VdpDebugView.DEBUG_VIEWER_ENABLED ? new MemView(memViewData, m, s32x, vdpMem) : NO_MEMVIEW;
    }

    private MemView() {
        this(mdMemViewData, null, null, null);
    }

    protected MemView(MemViewData[] memViewData, MdMainBusProvider m, ReadableByteMemory bus, VdpMemoryInterface vdpMem) {
        this.memViewData = memViewData;
        if (!VdpDebugView.DEBUG_VIEWER_ENABLED || m == null) {
            this.readerMap = Collections.emptyMap();
            return;
        }
        this.init();
        Z80Provider z80 = m.getBusDeviceIfAny(Z80Provider.class).orElseThrow();
        Z80BusProvider z80b = z80.getZ80BusProvider();
        MdVdpReadableMem mdVdpMem = new MdVdpReadableMem(vdpMem);
        this.readerMap = Map.of(MemViewOwner.MCD_SUB_CPU, (v, i) -> bus.read((int)i, Size.BYTE), MemViewOwner.SH2, (v, i) -> bus.read((int)i, Size.BYTE), MemViewOwner.M68K, (v, i) -> m.read(v.getBusBaseAddress() + i, Size.BYTE), MemViewOwner.Z80, (v, i) -> z80b.read((int)i, Size.BYTE), MemViewOwner.MD_VDP, (v, i) -> mdVdpMem.read((MemViewData)v, (int)i), MemViewOwner.SH2_WORD, (v, i) -> bus.read((int)i, Size.WORD));
        this.data = new byte[0];
    }

    @Override
    public void init() {
        SwingUtilities.invokeLater(() -> {
            this.frame = new JFrame();
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.setBackground(Color.GRAY);
            this.buildPanel();
            this.frame.setTitle("MD Memory Viewer");
            this.frame.pack();
            this.frame.setVisible(true);
        });
    }

    private void buildPanel() {
        this.frame.remove(this.panel);
        this.frame.invalidate();
        this.textArea = new JTextArea(4096, 32);
        this.textArea.setFont(new Font("Monospaced", 0, 14));
        this.textArea.setMinimumSize(new Dimension(600, 600));
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.listComp = new JComboBox<MemViewData>(this.memViewData);
        this.listComp.addActionListener(this::updateSelected);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        JButton refreshBtn = new JButton("Refresh");
        JButton exportBtn = new JButton("Export");
        refreshBtn.addActionListener(this::updateUser);
        exportBtn.addActionListener(this::export);
        topPanel.add(this.listComp);
        topPanel.add(exportBtn);
        topPanel.add(refreshBtn);
        this.panel.add(topPanel);
        this.panel.add(this.scrollPane);
        this.panel.setSize(new Dimension(615, 615));
        this.frame.add(this.panel);
        this.frame.setMinimumSize(this.panel.getSize());
        this.frame.pack();
    }

    private void export(ActionEvent actionEvent) {
        MemViewData mvd = this.currentViewRef.get();
        byte[] local = Arrays.copyOf(this.data, mvd.getEnd() - mvd.getStart());
        String name = "MemView_" + String.valueOf(mvd) + "_" + System.currentTimeMillis() + ".dat";
        Path p = Path.of(".", name);
        FileUtil.writeFileSafe(p, local);
        LOG.info("Exported to: {}", (Object)p.toAbsolutePath());
    }

    @Override
    public void update() {
        ++this.cnt;
        if ((this.cnt & 4) == 0) {
            return;
        }
        int res = this.qLen.incrementAndGet();
        if (res > 1) {
            this.qLen.decrementAndGet();
            return;
        }
        this.cnt = 0;
        this.updateNow();
    }

    private void updateNow() {
        MemViewData current = this.currentViewRef.get();
        BiFunction<MemViewData, Integer, Integer> readerFn = this.readerMap.get((Object)current.getOwner());
        int len = current.getEnd() - current.getStart();
        if (len > this.data.length) {
            this.data = new byte[len];
        }
        this.doMemoryRead(current, len, readerFn);
        Util.executorService.submit(Util.wrapRunnableEx(() -> this.updateFromMemory(current.getStart(), current.getEnd())));
    }

    private void updateSelected(ActionEvent e) {
        this.currentViewRef.set((MemViewData)this.listComp.getSelectedItem());
    }

    private void updateUser(ActionEvent e) {
        this.updateNow();
    }

    private void updateFromMemory(int start, int end) {
        MemView.fillFormattedString(this.sb, this.data, start, end);
        this.textArea.setText(this.sb.toString());
        this.sb.setLength(0);
        this.qLen.decrementAndGet();
    }

    public static void fillFormattedString(StringBuilder sb, byte[] data, int start, int end) {
        try {
            HexFormat hf = HexFormat.of().withSuffix(" ");
            sb.append(String.format("%8x", start)).append(": ");
            int len = end - start;
            for (int i = start; i < end; i += 16) {
                int slen = Math.min(len, 16);
                hf.formatHex(sb, data, i, i + slen).append("  ");
                for (int j = i; j < i + slen; ++j) {
                    sb.append(MemView.toAsciiChar(data[j])).append(" ");
                }
                if (i - start + 16 >= len) continue;
                sb.append("\n").append(String.format("%8x", i + 16)).append(": ");
            }
        }
        catch (Exception e) {
            LOG.error("Error", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected void doMemoryRead(MemViewData current, int len, BiFunction<MemViewData, Integer, Integer> readerFn) {
        int start = current.getStart();
        for (int i = 0; i < len; ++i) {
            this.data[i] = (byte)readerFn.apply(current, start + i).intValue();
        }
    }

    protected void doMemoryRead_WordBE(MemViewData current, int len) {
        assert (current.getOwner() == MemViewOwner.SH2);
        int start = current.getStart();
        for (int i = 0; i < len; i += 2) {
            int w = this.readerMap.get((Object)MemViewOwner.SH2_WORD).apply(current, start + i);
            Util.writeData(this.data, i, w, Size.WORD);
        }
    }

    private static char toAsciiChar(int val) {
        return val >= 32 && val < 127 ? (char)val : (char)'.';
    }

    @Override
    public void reset() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    public static interface MemViewData {
        public int getStart();

        public int getEnd();

        default public int getBusBaseAddress() {
            return 0;
        }

        public MemViewOwner getOwner();

        default public MdVdpProvider.VdpRamType getVdpRamType() {
            return null;
        }
    }

    public static enum MdMemViewType implements MemViewData
    {
        MD_VDP_VRAM(MemViewOwner.MD_VDP, 0, 65536, MdVdpProvider.VdpRamType.VRAM),
        MD_VDP_VSRAM(MemViewOwner.MD_VDP, 0, 80, MdVdpProvider.VdpRamType.VSRAM),
        MD_VDP_CRAM(MemViewOwner.MD_VDP, 0, 128, MdVdpProvider.VdpRamType.CRAM),
        M68K_SDRAM(MemViewOwner.M68K, 0, 65536, 0xE00000),
        Z80_RAM(MemViewOwner.Z80, 0, 8191);

        private final int start;
        private final int end;
        private final MemViewOwner owner;
        private final int busBaseAddress;
        private final MdVdpProvider.VdpRamType vdpRamType;

        private MdMemViewType(MemViewOwner c, int s, int e, int base) {
            this(c, s, e, null, base);
        }

        private MdMemViewType(MemViewOwner c, int s, int e) {
            this(c, s, e, null, 0);
        }

        private MdMemViewType(MemViewOwner c, int s, int e, MdVdpProvider.VdpRamType v) {
            this(c, s, e, v, 0);
        }

        private MdMemViewType(MemViewOwner c, int s, int e, MdVdpProvider.VdpRamType v, int baseAddr) {
            this.start = s;
            this.end = e;
            this.owner = c;
            this.vdpRamType = v;
            this.busBaseAddress = baseAddr;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public int getBusBaseAddress() {
            return this.busBaseAddress;
        }

        @Override
        public MemViewOwner getOwner() {
            return this.owner;
        }

        @Override
        public MdVdpProvider.VdpRamType getVdpRamType() {
            return this.vdpRamType;
        }
    }

    public static class MdVdpReadableMem {
        private final byte[] vram;
        private final byte[] vsram;
        private final byte[] cram;

        private MdVdpReadableMem(VdpMemoryInterface memory) {
            this.vram = memory.getVram().array();
            this.vsram = memory.getVsram().array();
            this.cram = memory.getCram().array();
        }

        public byte read(MemViewData m, int a) {
            return switch (m.getVdpRamType()) {
                default -> throw new IncompatibleClassChangeError();
                case MdVdpProvider.VdpRamType.VRAM -> this.vram[a];
                case MdVdpProvider.VdpRamType.CRAM -> this.cram[a];
                case MdVdpProvider.VdpRamType.VSRAM -> this.vsram[a];
            };
        }
    }

    public static enum MemViewOwner {
        SH2,
        M68K,
        Z80,
        MD_VDP,
        SH2_WORD,
        MCD_SUB_CPU;

    }
}

