/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import omegadrive.util.ImageUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.VideoMode;
import omegadrive.vdp.VdpRenderDump;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.model.VdpMisc;
import omegadrive.vdp.model.VdpRenderHandler;
import omegadrive.vdp.util.UpdatableViewer;
import org.slf4j.Logger;

public class PlaneViewer
implements UpdatableViewer,
BaseVdpAdapterEventSupport.VdpEventListener {
    private static final Logger LOG = LogHelper.getLogger(PlaneViewer.class.getSimpleName());
    private static final int PANEL_TEXT_HEIGHT = 20;
    private static final int PANEL_HEIGHT = 276;
    private static final int PANEL_WIDTH = 320;
    private static final Dimension layerDim = new Dimension(320, 256);
    private final VdpRenderHandler renderHandler;
    private static final int CRAM_MASK = 127;
    private JPanel panel;
    private final JPanel[] panelList = new JPanel[VdpMisc.RenderType.values().length];
    private final BufferedImage[] imageList = new BufferedImage[VdpMisc.RenderType.values().length];
    private final int[] javaPalette;
    private Dimension fullFrameDimension = layerDim;
    private int[] colorData = new int[0];

    private PlaneViewer(VdpMemoryInterface memoryInterface, VdpRenderHandler renderHandler) {
        this.renderHandler = renderHandler;
        this.panel = new JPanel();
        this.javaPalette = memoryInterface.getJavaColorPalette();
        this.initPanel();
    }

    public static PlaneViewer createInstance(MdVdpProvider vdp, VdpMemoryInterface memoryInterface, VdpRenderHandler renderHandler) {
        PlaneViewer p = new PlaneViewer(memoryInterface, renderHandler);
        vdp.addVdpEventListener(p);
        return p;
    }

    private static int[] getPixels(BufferedImage img) {
        return ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void initPanel() {
        int numCols = 3;
        int numRows = 2;
        SwingUtilities.invokeLater(() -> {
            this.panel = new JPanel(new GridLayout(numRows, numCols));
            int k = 0;
            for (final VdpMisc.RenderType type : VdpMisc.RenderType.values()) {
                JPanel cpanel = new JPanel(){

                    @Override
                    protected void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        if (g instanceof Graphics2D) {
                            Graphics2D g2 = (Graphics2D)g;
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2.drawString("MD " + type.name(), 70, 10);
                            g2.drawImage((Image)PlaneViewer.this.imageList[type.ordinal()], 0, 20, this);
                        }
                    }
                };
                cpanel.setBackground(Color.BLACK);
                cpanel.setForeground(Color.WHITE);
                cpanel.setBorder(BorderFactory.createLineBorder(Color.WHITE));
                cpanel.setName(type.name());
                cpanel.setSize(new Dimension(320, 276));
                this.panelList[k] = cpanel;
                ++k;
            }
            Arrays.stream(this.panelList).forEach(this.panel::add);
            this.panel.setSize(new Dimension(320 * numCols, 276 * numRows));
        });
        Arrays.stream(VdpMisc.RenderType.values()).forEach(t -> {
            this.imageList[t.ordinal()] = ImageUtil.createImage(VdpRenderDump.gd, layerDim);
        });
    }

    @Override
    public void update() {
        BufferedImage img = this.imageList[VdpMisc.RenderType.FULL.ordinal()];
        int[] imgData = PlaneViewer.getPixels(img);
        int[] data = this.renderHandler.getScreenDataLinear();
        System.arraycopy(data, 0, imgData, 0, data.length);
        this.panel.repaint();
    }

    @Override
    public void onVdpEvent(BaseVdpAdapterEventSupport.VdpEvent event, Object value) {
        if (event == BaseVdpAdapterEventSupport.VdpEvent.VIDEO_MODE) {
            this.adjustFullFrameSize((VideoMode)((Object)value));
        }
    }

    private void adjustFullFrameSize(VideoMode videoMode) {
        Dimension d = videoMode.getDimension();
        if (!d.equals(this.fullFrameDimension)) {
            this.imageList[VdpMisc.RenderType.FULL.ordinal()] = ImageUtil.createImage(VdpRenderDump.gd, d);
            this.fullFrameDimension = d;
        }
    }

    @Override
    public void updateLine(int line) {
        if (line >= PlaneViewer.layerDim.height) {
            return;
        }
        int pos = PlaneViewer.layerDim.width * line;
        for (VdpMisc.RenderType type : VdpMisc.RenderType.values()) {
            if (type == VdpMisc.RenderType.FULL) continue;
            int[] data = this.renderHandler.getPlaneData(type);
            if (this.colorData.length != data.length) {
                this.colorData = new int[data.length];
            }
            this.toJavaColor(data, this.colorData);
            BufferedImage img = this.imageList[type.ordinal()];
            int[] imgData = PlaneViewer.getPixels(img);
            System.arraycopy(this.colorData, 0, imgData, pos, this.colorData.length);
        }
    }

    private int[] toJavaColor(int[] in, int[] out) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = this.javaPalette[(in[i] & 0x7F) >> 1];
        }
        return out;
    }
}

