/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.util;

import java.awt.Color;
import java.awt.Dimension;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import omegadrive.util.LogHelper;
import omegadrive.util.PriorityThreadFactory;
import omegadrive.util.Util;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.model.VdpRenderHandler;
import omegadrive.vdp.util.CramViewer;
import omegadrive.vdp.util.PlaneViewer;
import omegadrive.vdp.util.TileViewer;
import omegadrive.vdp.util.UpdatableViewer;
import org.slf4j.Logger;

public class VdpDebugView
implements UpdatableViewer {
    private static final Logger LOG = LogHelper.getLogger(VdpDebugView.class.getSimpleName());
    private final ExecutorService service = Executors.newSingleThreadExecutor(new PriorityThreadFactory(1, this));
    public static final boolean DEBUG_VIEWER_ENABLED = Boolean.parseBoolean(System.getProperty("md.show.vdp.debug.viewer", "false"));
    private final CramViewer cramViewer;
    private final PlaneViewer planeViewer;
    private final TileViewer tileViewer;
    private JFrame frame;
    private JPanel panel;
    private JPanel additionalPanel;
    private boolean s32xMode = false;
    private AtomicInteger qLen = new AtomicInteger(0);

    private VdpDebugView(MdVdpProvider vdp, VdpMemoryInterface memoryInterface, VdpRenderHandler renderHandler) {
        this.cramViewer = CramViewer.createInstance(memoryInterface);
        this.planeViewer = PlaneViewer.createInstance(vdp, memoryInterface, renderHandler);
        this.tileViewer = TileViewer.createInstance(vdp, memoryInterface, renderHandler);
        this.init();
    }

    public static UpdatableViewer createInstance(MdVdpProvider vdp, VdpMemoryInterface memoryInterface, VdpRenderHandler renderHandler) {
        return DEBUG_VIEWER_ENABLED ? new VdpDebugView(vdp, memoryInterface, renderHandler) : UpdatableViewer.NO_OP_VIEWER;
    }

    private void init() {
        SwingUtilities.invokeLater(() -> {
            this.frame = new JFrame();
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.setBackground(Color.GRAY);
            this.buildPanel();
            this.frame.setTitle("Vdp Debug Viewer");
            this.frame.pack();
            this.frame.setVisible(true);
        });
    }

    private void buildPanel() {
        this.frame.remove(this.panel);
        this.frame.invalidate();
        JPanel planePanel = this.planeViewer.getPanel();
        JPanel cramPanel = this.cramViewer.getPanel();
        JPanel tilePanel = this.tileViewer.getPanel();
        int h = planePanel.getHeight() + cramPanel.getHeight() + tilePanel.getHeight();
        this.panel.add(planePanel);
        if (this.s32xMode) {
            this.panel.add(this.additionalPanel);
            h += this.additionalPanel.getHeight();
        } else {
            this.panel.add(tilePanel);
        }
        this.panel.add(cramPanel);
        int w = Math.max(planePanel.getWidth(), cramPanel.getWidth());
        w = Math.max(w, tilePanel.getWidth()) + 20;
        cramPanel.setMaximumSize(cramPanel.getSize());
        this.panel.setSize(new Dimension(w, h));
        this.frame.add(this.panel);
        this.frame.setMinimumSize(this.panel.getSize());
        this.frame.pack();
    }

    @Override
    public void update() {
        int res = this.qLen.incrementAndGet();
        if (res > 1) {
            this.qLen.decrementAndGet();
            return;
        }
        if (this.s32xMode) {
            this.planeViewer.update();
        }
        this.service.submit(Util.wrapRunnableEx(() -> {
            this.cramViewer.update();
            this.tileViewer.update();
            if (!this.s32xMode) {
                this.planeViewer.update();
            }
            this.qLen.decrementAndGet();
        }));
    }

    @Override
    public void updateLine(int line) {
        this.planeViewer.updateLine(line);
    }

    public void setAdditionalPanel(JPanel panel) {
        this.additionalPanel = panel;
        this.s32xMode = panel != null;
        this.buildPanel();
    }

    @Override
    public void reset() {
        this.service.shutdownNow();
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    static {
        if (DEBUG_VIEWER_ENABLED) {
            LOG.info("Debug viewer enabled");
        }
    }
}

