/*
 * Decompiled with CFR 0.152.
 */
package s32x;

import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import s32x.DmaFifo68k;
import s32x.event.PollSysEventManager;
import s32x.sh2.Sh2Helper;

public class StaticBootstrapSupport {
    public static NextCycleResettable instance;

    public static void initStatic(NextCycleResettable instance) {
        assert (instance != null);
        PollSysEventManager.instance.reset();
        PollSysEventManager.instance.addSysEventListener(instance.getClass().getSimpleName(), instance);
        DmaFifo68k.rv = false;
        Sh2Helper.clear();
        StaticBootstrapSupport.instance = instance;
        LogHelper.clear();
    }

    public static void afterStateLoad() {
        assert (instance != null);
        PollSysEventManager.instance.resetPoller(BufferUtil.CpuDeviceAccess.MASTER);
        PollSysEventManager.instance.resetPoller(BufferUtil.CpuDeviceAccess.SLAVE);
        Sh2Helper.clear();
        StaticBootstrapSupport.setNextCycleExt(BufferUtil.CpuDeviceAccess.MASTER, 0);
        StaticBootstrapSupport.setNextCycleExt(BufferUtil.CpuDeviceAccess.SLAVE, 0);
    }

    public static void setNextCycleExt(BufferUtil.CpuDeviceAccess cpu, int value) {
        instance.setNextCycle(cpu, value);
    }

    public static interface NextCycleResettable
    extends PollSysEventManager.SysEventListener {
        public void setNextCycle(BufferUtil.CpuDeviceAccess var1, int var2);
    }
}

