/*
 * Decompiled with CFR 0.152.
 */
package s32x.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import omegadrive.Device;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;
import s32x.sh2.drc.Sh2DrcBlockOptimizer;

public interface PollSysEventManager
extends Device {
    public static final Logger LOG;
    public static final PollSysEventManager instance;
    public static final Sh2DrcBlockOptimizer.PollerCtx[] currentPollers;
    public static final AtomicInteger pollerActiveMask;

    public void fireSysEvent(BufferUtil.CpuDeviceAccess var1, SysEvent var2);

    public boolean addSysEventListener(BufferUtil.CpuDeviceAccess var1, String var2, SysEventListener var3);

    public boolean removeSysEventListener(BufferUtil.CpuDeviceAccess var1, String var2, SysEventListener var3);

    default public boolean addSysEventListener(String name, SysEventListener l) {
        this.addSysEventListener(BufferUtil.CpuDeviceAccess.MASTER, name, l);
        this.addSysEventListener(BufferUtil.CpuDeviceAccess.SLAVE, name, l);
        return true;
    }

    default public int removeSysEventListener(String name, SysEventListener l) {
        int num = 0;
        boolean s1 = this.removeSysEventListener(BufferUtil.CpuDeviceAccess.MASTER, name, l);
        boolean s2 = this.removeSysEventListener(BufferUtil.CpuDeviceAccess.SLAVE, name, l);
        return num += (s1 ? 1 : 0) + (s2 ? 1 : 0);
    }

    default public void resetPoller(BufferUtil.CpuDeviceAccess cpu) {
        Sh2DrcBlockOptimizer.PollerCtx pctx = currentPollers[cpu.ordinal()];
        if (pctx != Sh2DrcBlockOptimizer.NO_POLLER) {
            pctx.stopPolling();
            PollSysEventManager.currentPollers[cpu.ordinal()] = Sh2DrcBlockOptimizer.NO_POLLER;
            pollerActiveMask.set(pollerActiveMask.get() & ~(cpu.ordinal() + 1));
        }
    }

    default public void setPoller(BufferUtil.CpuDeviceAccess cpu, Sh2DrcBlockOptimizer.PollerCtx ctx) {
        if (!1.$assertionsDisabled && currentPollers[cpu.ordinal()] != Sh2DrcBlockOptimizer.NO_POLLER) {
            throw new AssertionError();
        }
        PollSysEventManager.currentPollers[cpu.ordinal()] = ctx;
        pollerActiveMask.set(pollerActiveMask.get() | cpu.ordinal() + 1);
    }

    default public Sh2DrcBlockOptimizer.PollerCtx getPoller(BufferUtil.CpuDeviceAccess cpu) {
        return currentPollers[cpu.ordinal()];
    }

    default public int anyPollerActive() {
        return pollerActiveMask.get();
    }

    public static int readPollValue(Sh2DrcBlockOptimizer.PollerCtx blockPoller) {
        if (blockPoller.isPollingBusyLoop()) {
            return 0;
        }
        if (!blockPoller.piw.block.isValid()) {
            LOG.warn("Unexpected state, block is invalid?\n{}", (Object)blockPoller);
            return 0;
        }
        Sh2Bus memory = blockPoller.piw.block.drcContext.memory;
        return memory.readMemoryUncachedNoDelay(blockPoller.blockPollData.memLoadTarget, blockPoller.blockPollData.memLoadTargetSize);
    }

    public static boolean pollValueCheck(BufferUtil.CpuDeviceAccess cpu, SysEvent event, Sh2DrcBlockOptimizer.PollerCtx pctx) {
        if (event == SysEvent.INT) {
            return true;
        }
        if (!1.$assertionsDisabled && MdRuntimeData.getCpuDelayExt(cpu) != 0) {
            throw new AssertionError();
        }
        int value = PollSysEventManager.readPollValue(pctx);
        if (value == pctx.pollValue) {
            System.out.println("?? Poll stop but value unchanged: " + Util.th(pctx.pollValue) + "," + Util.th(value));
        }
        if (!1.$assertionsDisabled && value == pctx.pollValue) {
            throw new AssertionError();
        }
        return true;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        LOG = LogHelper.getLogger(PollSysEventManager.class.getSimpleName());
        instance = new SysEventManagerImpl();
        currentPollers = new Sh2DrcBlockOptimizer.PollerCtx[]{Sh2DrcBlockOptimizer.NO_POLLER, Sh2DrcBlockOptimizer.NO_POLLER};
        pollerActiveMask = new AtomicInteger();
    }

    public static interface SysEventListener {
        public void onSysEvent(BufferUtil.CpuDeviceAccess var1, SysEvent var2);
    }

    public static enum SysEvent {
        NONE,
        INT,
        SYS,
        SDRAM,
        FRAMEBUFFER,
        COMM,
        DMA,
        PWM,
        VDP,
        START_POLLING,
        SH2_RESET_ON,
        SH2_RESET_OFF;

    }

    public static class SysEventManagerImpl
    implements PollSysEventManager {
        private final Map<String, SysEventListener> listenerMapMaster = new HashMap<String, SysEventListener>();
        private final Map<String, SysEventListener> listenerMapSlave = new HashMap<String, SysEventListener>();
        private final SysEventListener[][] listenerArr = new SysEventListener[2][0];

        @Override
        public boolean addSysEventListener(BufferUtil.CpuDeviceAccess cpu, String name, SysEventListener l) {
            Map<String, SysEventListener> map = cpu == BufferUtil.CpuDeviceAccess.MASTER ? this.listenerMapMaster : this.listenerMapSlave;
            SysEventListener s = map.put(name, l);
            assert (s == null);
            this.listenerArr[cpu.ordinal()] = map.values().toArray(new SysEventListener[0]);
            assert (this.listenerArr[cpu.ordinal()].length == map.size());
            return true;
        }

        @Override
        public boolean removeSysEventListener(BufferUtil.CpuDeviceAccess cpu, String name, SysEventListener l) {
            Map<String, SysEventListener> map = cpu == BufferUtil.CpuDeviceAccess.MASTER ? this.listenerMapMaster : this.listenerMapSlave;
            SysEventListener s = map.remove(name);
            this.listenerArr[cpu.ordinal()] = map.values().toArray(new SysEventListener[0]);
            assert (this.listenerArr[cpu.ordinal()].length == map.size());
            return s != null;
        }

        @Override
        public void fireSysEvent(BufferUtil.CpuDeviceAccess cpu, SysEvent event) {
            assert (cpu.ordinal() < 2);
            SysEventListener[] a = this.listenerArr[cpu.ordinal()];
            for (int i = 0; i < a.length; ++i) {
                a[i].onSysEvent(cpu, event);
            }
        }

        @Override
        public void reset() {
            this.listenerMapMaster.clear();
            this.listenerMapSlave.clear();
            this.listenerArr[0] = new SysEventListener[0];
            this.listenerArr[1] = new SysEventListener[0];
            SysEventManagerImpl.currentPollers[0] = SysEventManagerImpl.currentPollers[1] = Sh2DrcBlockOptimizer.NO_POLLER;
            pollerActiveMask.set(0);
        }
    }
}

