/*
 * Decompiled with CFR 0.152.
 */
package s32x.pwm;

import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.SourceDataLine;
import omegadrive.sound.PwmProvider;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.PriorityThreadFactory;
import omegadrive.util.RegionDetector;
import omegadrive.util.SoundUtil;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.pwm.PwmUtil;
import s32x.util.blipbuffer.BlipBufferHelper;
import s32x.util.blipbuffer.BlipBufferIntf;
import s32x.util.blipbuffer.StereoBlipBuffer;

public class BlipPwmProvider
implements PwmProvider {
    private static final Logger LOG = LogHelper.getLogger(BlipPwmProvider.class.getSimpleName());
    private static final int BUF_SIZE_MS = 50;
    private final AtomicReference<BlipBufferContext> ref = new AtomicReference();
    private final float sh2ClockMhz;
    private final double frameIntervalMs;
    private double deltaTime;
    private int prevLSample;
    private int prevRSample;
    int[] preFilter = new int[0];
    int[] pfPrev = new int[2];
    static final double pfAlpha = 0.995;
    private final SourceDataLine dataLine;
    private PwmUtil.Warmup warmup = PwmUtil.NO_WARMUP;
    public static boolean mute = false;
    private final ExecutorService exec = Executors.newSingleThreadExecutor(new PriorityThreadFactory(10, "pwm"));
    private int prevSampleAvail = 0;
    private final AtomicInteger sync = new AtomicInteger();

    public BlipPwmProvider(RegionDetector.Region region) {
        this.ref.set(new BlipBufferContext());
        this.frameIntervalMs = region.getFrameIntervalMs();
        this.dataLine = SoundUtil.createDataLine(AbstractSoundManager.audioFormat);
        this.sh2ClockMhz = region == RegionDetector.Region.EUROPE ? 2.2801468E7f : 2.301136E7f;
        this.updatePwmCycle(1042);
    }

    @Override
    public void updatePwmCycle(int cycle) {
        BlipBufferContext context = this.ref.get();
        if (cycle == context.cycle) {
            return;
        }
        StereoBlipBuffer blip = new StereoBlipBuffer("pwm");
        blip.setSampleRate((int)AbstractSoundManager.audioFormat.getSampleRate(), 50);
        blip.setClockRate((int)(this.sh2ClockMhz / (float)cycle));
        BlipBufferContext bbc = new BlipBufferContext();
        bbc.cycle = cycle;
        bbc.scale = 65534.0f / (float)cycle;
        bbc.inputClocksForInterval = (int)(1.0 * (double)blip.clockRate() * this.frameIntervalMs / 1000.0);
        int outSamplesPerInterval = (int)((double)(AbstractSoundManager.audioFormat.getSampleRate() * 50.0f) / 1000.0);
        this.preFilter = new int[outSamplesPerInterval];
        bbc.lineBuffer = new byte[0];
        bbc.blipBuffer = blip;
        this.ref.set(bbc);
        this.warmup = PwmUtil.WARMUP;
        this.warmup.reset();
        this.warmup.isWarmup = true;
        this.logInfo(bbc);
        LOG.info("PWM warmup start");
    }

    @Override
    public void playSample(int left, int right) {
        int lsample = this.scalePwmSample(left);
        int rsample = this.scalePwmSample(right);
        if (lsample != this.prevLSample || rsample != this.prevRSample) {
            this.ref.get().blipBuffer.addDelta((int)this.deltaTime, lsample - this.prevLSample, rsample - this.prevRSample);
            this.prevLSample = lsample;
            this.prevRSample = rsample;
        }
        this.deltaTime += 1.0;
    }

    private int scalePwmSample(int sample) {
        int vsample = (int)((float)(sample - (this.ref.get().cycle >> 1)) * this.ref.get().scale);
        short scaled = (short)vsample;
        if (scaled != vsample) {
            float scale = this.ref.get().scale;
            this.ref.get().scale -= 1.0f;
            LOG.warn("PWM value out of range (16 bit signed): {}, scale: {}, pwmVal: {}", new Object[]{Util.th(scaled), Float.valueOf(scale), sample});
            LOG.warn("Reducing scale: {} -> {}", (Object)Float.valueOf(scale), (Object)Float.valueOf(this.ref.get().scale));
            scaled = (short)BlipBufferHelper.clampToShort(vsample);
        }
        return scaled;
    }

    @Override
    public int updateStereo16(int[] buf_lr, int offset, int countMono) {
        return countMono << 1;
    }

    @Override
    public void newFrame() {
        BlipBufferContext context = this.ref.get();
        BlipBufferIntf blip = context.blipBuffer;
        blip.endFrame(context.inputClocksForInterval);
        this.deltaTime = 0.0;
        int availMonoSamples = blip.samplesAvail();
        if (availMonoSamples + 5 < this.prevSampleAvail) {
            LOG.info("Audio underrun : {} -> {} samples", (Object)this.prevSampleAvail, (Object)availMonoSamples);
        }
        if (context.lineBuffer.length < availMonoSamples << 2) {
            LOG.info("Audio buffer size: {} -> {} bytes", (Object)context.lineBuffer.length, (Object)(availMonoSamples << 2));
            context.lineBuffer = new byte[availMonoSamples << 2];
        }
        long current = this.sync.incrementAndGet();
        int stereoBytes = blip.readSamples16bitStereo(context.lineBuffer, 0, availMonoSamples) << 2;
        if (stereoBytes > 0 && !mute) {
            this.exec.submit(Util.wrapRunnableEx(() -> {
                SoundUtil.writeBufferInternal(this.dataLine, context.lineBuffer, 0, stereoBytes);
                if (BufferUtil.assertionsEnabled && current != (long)this.sync.get()) {
                    LOG.info("Pwm audio thread too slow: {} vs {}", (Object)current, (Object)this.sync.get());
                }
            }));
        }
        this.prevSampleAvail = availMonoSamples;
    }

    private void logInfo(BlipBufferContext ctx) {
        int outSamplesPerInterval = (int)((double)(AbstractSoundManager.audioFormat.getSampleRate() * 50.0f) / 1000.0);
        int inSamplesPerInterval = (int)((double)(ctx.blipBuffer.clockRate() * 50) / 1000.0);
        LOG.info("{}\nOutput sampleRate: {}, Input sampleRate: {}, outputBufLenMs: {}, outputBufLenSamples: {}, inputBufLenSamples: {}", new Object[]{ctx, Float.valueOf(AbstractSoundManager.audioFormat.getSampleRate()), ctx.blipBuffer.clockRate(), 50, outSamplesPerInterval, inSamplesPerInterval});
    }

    @Override
    public void reset() {
        SoundUtil.close(this.dataLine);
    }

    static class BlipBufferContext {
        BlipBufferIntf blipBuffer;
        byte[] lineBuffer;
        int cycle;
        int inputClocksForInterval;
        float scale;

        BlipBufferContext() {
        }

        public String toString() {
            return new StringJoiner(", ", BlipBufferContext.class.getSimpleName() + "[", "]").add("cycle=" + this.cycle).add("inputClocksForInterval=" + this.inputClocksForInterval).add("scale=" + this.scale).toString();
        }
    }
}

