/*
 * Decompiled with CFR 0.152.
 */
package s32x.pwm;

import omegadrive.util.BufferUtil;
import omegadrive.util.Fifo;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class PwmUtil {
    private static final Logger LOG = LogHelper.getLogger(PwmUtil.class.getSimpleName());
    public static final Fifo<Integer> EMPTY_FIFO = Fifo.createIntegerFixedSizeFifo(0);
    public static final Warmup NO_WARMUP = new Warmup();
    public static final Warmup WARMUP = new Warmup();

    public static class Warmup {
        static final int stepSamples = 2047;
        static final double stepFactor = 0.02;
        boolean isWarmup;
        int currentSamples;
        double currentFactor = 0.0;

        public int doWarmup(int sample) {
            if (this.isWarmup) {
                int res = (int)((double)sample * this.currentFactor);
                this.addSampleCount(1);
                return res;
            }
            return sample;
        }

        private void addSampleCount(int add) {
            int start = this.currentSamples & 0x7FF;
            this.currentSamples += add;
            if ((this.currentSamples & 0x7FF) < start) {
                this.currentFactor += 0.02;
                if (this.currentFactor >= 1.0) {
                    this.reset();
                    LOG.info("PWM warmup done");
                }
                assert (this.currentFactor < 1.0);
            }
        }

        public void doWarmup(int[] out, int len) {
            if (this.isWarmup) {
                int start = this.currentSamples & 0x7FF;
                for (int i = 2; i < len; i += 2) {
                    int n = i;
                    out[n] = (int)((double)out[n] * this.currentFactor);
                    int n2 = i + 1;
                    out[n2] = (int)((double)out[n2] * this.currentFactor);
                }
                this.addSampleCount(len);
            }
        }

        public void reset() {
            this.isWarmup = false;
            this.currentSamples = 0;
            this.currentFactor = 0.0;
        }

        static {
            BufferUtil.assertPowerOf2Minus1("pwmStepSamples", 2047);
        }
    }

    static class PwmStats {
        public static final PwmStats NO_STATS = new PwmStats();
        public int monoSamplesFiller = 0;
        public int monoSamplesPull = 0;
        public int monoSamplesPush = 0;
        public int monoSamplesDiscard = 0;
        public int monoSamplesDiscardHalf = 0;

        PwmStats() {
        }

        public void print(int monoLen) {
            LOG.info("Pwm frame monoSamples, push: {} (discard: {}, discardHalf: {}), pop: {}, filler: {}, tot: {}, monoQLen: {}", new Object[]{this.monoSamplesPush, this.monoSamplesDiscard, this.monoSamplesDiscardHalf, this.monoSamplesPull, this.monoSamplesFiller, this.monoSamplesPull + this.monoSamplesFiller, monoLen});
        }

        public void reset() {
            this.monoSamplesDiscardHalf = 0;
            this.monoSamplesDiscard = 0;
            this.monoSamplesPush = 0;
            this.monoSamplesPull = 0;
            this.monoSamplesFiller = 0;
        }
    }
}

