/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2;

public class Sh2Disassembler {
    public static final int MOV0 = 57344;
    public static final int MOVW0 = 36864;
    public static final int MOVL0 = 53248;
    public static final int MOV1 = 24579;
    public static final int MOVB1 = 8192;
    public static final int MOVW1 = 8193;
    public static final int MOVL1 = 8194;
    public static final int MOVB2 = 24576;
    public static final int MOVW2 = 24577;
    public static final int MOVL2 = 24578;
    public static final int MOVB3 = 8196;
    public static final int MOVW3 = 8197;
    public static final int MOVL3 = 8198;
    public static final int MOVB4 = 24580;
    public static final int MOVW4 = 24581;
    public static final int MOVL4 = 24582;
    public static final int MOVB5 = 32768;
    public static final int MOVW5 = 33024;
    public static final int MOVL5 = 4096;
    public static final int MOVB6 = 33792;
    public static final int MOVW6 = 34048;
    public static final int MOVL6 = 20480;
    public static final int MOVB7 = 4;
    public static final int MOVW7 = 5;
    public static final int MOVL7 = 6;
    public static final int MOVB8 = 12;
    public static final int MOVW8 = 13;
    public static final int MOVL8 = 14;
    public static final int MOVB9 = 49152;
    public static final int MOVW9 = 49408;
    public static final int MOVL9 = 49664;
    public static final int MOVB10 = 50176;
    public static final int MOVW10 = 50432;
    public static final int MOVL10 = 50688;
    public static final int MOVA = 50944;
    public static final int MOVT = 41;
    public static final int SWAPB = 24584;
    public static final int SWAPW = 24585;
    public static final int XTRCT = 8205;
    public static final int ADD0 = 12300;
    public static final int ADD1 = 28672;
    public static final int ADDC = 12302;
    public static final int ADDV = 12303;
    public static final int CMPEQ0 = 34816;
    public static final int CMPEQ1 = 12288;
    public static final int CMPHS = 12290;
    public static final int CMPGE = 12291;
    public static final int CMPHI = 12294;
    public static final int CMPGT = 12295;
    public static final int CMPPZ = 16401;
    public static final int CMPPL = 16405;
    public static final int CMPSTR = 8204;
    public static final int DIV1 = 12292;
    public static final int DIV0S = 8199;
    public static final int DIV0U = 25;
    public static final int DMULSL = 12301;
    public static final int DMULUL = 12293;
    public static final int DT = 16400;
    public static final int EXTSB = 24590;
    public static final int EXTSW = 24591;
    public static final int EXTUB = 24588;
    public static final int EXTUW = 24589;
    public static final int MACL = 15;
    public static final int MACW = 16399;
    public static final int MULL = 7;
    public static final int MULSW = 8207;
    public static final int MULUW = 8206;
    public static final int NEG = 24587;
    public static final int NEGC = 24586;
    public static final int SUB = 12296;
    public static final int SUBC = 12298;
    public static final int SUBV = 12299;
    public static final int AND0 = 8201;
    public static final int AND1 = 51456;
    public static final int ANDB = 52480;
    public static final int NOT = 24583;
    public static final int OR0 = 8203;
    public static final int OR1 = 51968;
    public static final int ORB = 52992;
    public static final int TASB = 16411;
    public static final int TST0 = 8200;
    public static final int TST1 = 51200;
    public static final int TSTB = 52224;
    public static final int XOR0 = 8202;
    public static final int XOR1 = 51712;
    public static final int XORB = 52736;
    public static final int ROTL = 16388;
    public static final int ROTR = 16389;
    public static final int ROTCL = 16420;
    public static final int ROTCR = 16421;
    public static final int SHAD = 16396;
    public static final int SHAL = 16416;
    public static final int SHAR = 16417;
    public static final int SHLD = 16397;
    public static final int SHLL = 16384;
    public static final int SHLR = 16385;
    public static final int SHLL2 = 16392;
    public static final int SHLR2 = 16393;
    public static final int SHLL8 = 16408;
    public static final int SHLR8 = 16409;
    public static final int SHLL16 = 16424;
    public static final int SHLR16 = 16425;
    public static final int BF = 35584;
    public static final int BFS = 36608;
    public static final int BT = 35072;
    public static final int BTS = 36096;
    public static final int BRA = 40960;
    public static final int BRAF = 35;
    public static final int BSR = 45056;
    public static final int BSRF = 3;
    public static final int JMP = 16427;
    public static final int JSR = 16395;
    public static final int RTS = 11;
    public static final int CLRMAC = 40;
    public static final int CLRT = 8;
    public static final int LDC0 = 16398;
    public static final int LDC1 = 16414;
    public static final int LDC2 = 16430;
    public static final int LDCL0 = 16391;
    public static final int LDCL1 = 16407;
    public static final int LDCL2 = 16423;
    public static final int LDS0 = 16394;
    public static final int LDS1 = 16410;
    public static final int LDS2 = 16426;
    public static final int LDSL0 = 16390;
    public static final int LDSL1 = 16406;
    public static final int LDSL2 = 16422;
    public static final int NOP = 9;
    public static final int RTE = 43;
    public static final int SETT = 24;
    public static final int SLEEP = 27;
    public static final int STC0 = 2;
    public static final int STC1 = 18;
    public static final int STC2 = 34;
    public static final int STCL0 = 16387;
    public static final int STCL1 = 16403;
    public static final int STCL2 = 16419;
    public static final int STS0 = 10;
    public static final int STS1 = 26;
    public static final int STS2 = 42;
    public static final int STSL0 = 16386;
    public static final int STSL1 = 16402;
    public static final int STSL2 = 16418;
    public static final int TRAPA = 49920;

    private static final int RM(int opcode) {
        return (opcode & 0xF0) >> 4;
    }

    private static final int RN(int opcode) {
        return (opcode & 0xF00) >> 8;
    }

    private static final int DISP(int opcode) {
        return opcode & 0xF;
    }

    private static final int IMM(int opcode) {
        return opcode & 0xFF;
    }

    private static final int LABEL(int opcode) {
        return opcode & 0xFFF;
    }

    private static final int DRN(int opcode) {
        return (opcode & 0xE00) >> 8;
    }

    private static final int BANK(int opcode) {
        return (opcode & 0x70) >> 4;
    }

    public String disassemble(int pc, int opcode) {
        int reference = 0;
        int op = opcode & 0xF000;
        switch (op) {
            case 57344: {
                int temp = Sh2Disassembler.IMM(opcode) << 24 >> 24;
                return String.format(temp < 0 ? "mov H'%08x, R%d" : "mov H'%02x, R%d", temp, Sh2Disassembler.RN(opcode));
            }
            case 36864: {
                reference = Sh2Disassembler.IMM(opcode) * 2 + pc + 4;
                return String.format("mov.w @(H'%08x), R%d", reference, Sh2Disassembler.RN(opcode));
            }
            case 53248: {
                reference = Sh2Disassembler.IMM(opcode) * 4 + (pc & 0xFFFFFFFC) + 4;
                return String.format("mov.l @(H'%08x), R%d", reference, Sh2Disassembler.RN(opcode));
            }
            case 4096: {
                return String.format("mov.l R%d, @(%d, R%d)", Sh2Disassembler.RM(opcode), Sh2Disassembler.DISP(opcode), Sh2Disassembler.RN(opcode));
            }
            case 20480: {
                return String.format("mov.l @(%d, R%d), R%d", Sh2Disassembler.DISP(opcode), Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 28672: {
                int temp = Sh2Disassembler.IMM(opcode) << 24 >> 24;
                return String.format("add H'%s%02x, R%d", temp < 0 ? "-" : "", temp & 0xFF, Sh2Disassembler.RN(opcode));
            }
            case 40960: {
                int temp = (Sh2Disassembler.LABEL(opcode) << 20 >> 20) * 2;
                return String.format("bra H'%08x", temp + (pc + 4));
            }
            case 45056: {
                int temp = (Sh2Disassembler.LABEL(opcode) << 20 >> 20) * 2;
                return String.format("bsr H'%08x", temp + (pc + 4));
            }
        }
        op = opcode & 0xF00F;
        switch (op) {
            case 24579: {
                return String.format("mov R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8192: {
                return String.format("mov.b R%d, @R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8193: {
                return String.format("mov.w R%d, @R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8194: {
                return String.format("mov.l R%d, @R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24576: {
                return String.format("mov.b @R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24577: {
                return String.format("mov.w @R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24578: {
                return String.format("mov.l @R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8196: {
                return String.format("mov.b R%d, @-R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8197: {
                return String.format("mov.w R%d, @-R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8198: {
                return String.format("mov.l R%d, @-R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24580: {
                return String.format("mov.b @R%d+, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24581: {
                return String.format("mov.w @R%d+, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24582: {
                return String.format("mov.l @R%d+, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 4: {
                return String.format("mov.b R%d, @(R0, R%d)", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 5: {
                return String.format("mov.w R%d, @(R0, R%d)", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 6: {
                return String.format("mov.l R%d, @(R0, R%d)", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12: {
                return String.format("mov.b @(R0, R%d), R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 13: {
                return String.format("mov.w @(R0, R%d), R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 14: {
                return String.format("mov.l @(R0, R%d), R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24584: {
                return String.format("swap.b R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24585: {
                return String.format("swap.w R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8205: {
                return String.format("xtrct R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12300: {
                return String.format("add R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12302: {
                return String.format("addc R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12303: {
                return String.format("addv R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12288: {
                return String.format("cmp/eq R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12290: {
                return String.format("cmp/hs R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12291: {
                return String.format("cmp/ge R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12294: {
                return String.format("cmp/hi R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12295: {
                return String.format("cmp/gt R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8204: {
                return String.format("cmp/str R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12292: {
                return String.format("div1 R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8199: {
                return String.format("div0s R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12301: {
                return String.format("dmuls.l R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12293: {
                return String.format("dmulu.l R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24590: {
                return String.format("exts.b R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24591: {
                return String.format("exts.w R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24588: {
                return String.format("extu.b R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24589: {
                return String.format("extu.w R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 15: {
                return String.format("mac.l @R%d+, @R%d+", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 16399: {
                return String.format("mac.w @R%d+, @R%d+", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 7: {
                return String.format("mul.l R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8207: {
                return String.format("muls.w R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8206: {
                return String.format("mulu.w R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24587: {
                return String.format("neg R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24586: {
                return String.format("negc R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12296: {
                return String.format("sub R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12298: {
                return String.format("subc R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 12299: {
                return String.format("subv R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8201: {
                return String.format("and R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 24583: {
                return String.format("not R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8203: {
                return String.format("or R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8200: {
                return String.format("tst R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
            case 8202: {
                return String.format("xor R%d, R%d", Sh2Disassembler.RM(opcode), Sh2Disassembler.RN(opcode));
            }
        }
        op = opcode & 0xFF00;
        switch (op) {
            case 32768: {
                return String.format("mov.b R0, @(%d, R%d)", Sh2Disassembler.DISP(opcode), Sh2Disassembler.RM(opcode));
            }
            case 33024: {
                return String.format("mov.w R0, @(%d, R%d)", Sh2Disassembler.DISP(opcode), Sh2Disassembler.RM(opcode));
            }
            case 33792: {
                return String.format("mov.b @(%d, R%d), R0", Sh2Disassembler.DISP(opcode), Sh2Disassembler.RM(opcode));
            }
            case 34048: {
                return String.format("mov.w @(%d, R%d), R0", Sh2Disassembler.DISP(opcode), Sh2Disassembler.RM(opcode));
            }
            case 49152: {
                return String.format("mov.b R0, @(%d, GBR)", Sh2Disassembler.IMM(opcode));
            }
            case 49408: {
                return String.format("mov.w R0, @(%d, GBR)", Sh2Disassembler.IMM(opcode));
            }
            case 49664: {
                return String.format("mov.l R0, @(%d, GBR)", Sh2Disassembler.IMM(opcode));
            }
            case 50176: {
                return String.format("mov.b @(%d, GBR), R0", Sh2Disassembler.IMM(opcode));
            }
            case 50432: {
                return String.format("mov.w @(%d, GBR), R0", Sh2Disassembler.IMM(opcode));
            }
            case 50688: {
                return String.format("mov.l @(%d, GBR), R0", Sh2Disassembler.IMM(opcode));
            }
            case 50944: {
                return String.format("mova H'%08x, R0", Sh2Disassembler.IMM(opcode) * 4 + ((pc & 0xFFFFFFFC) + 4));
            }
            case 34816: {
                int temp = Sh2Disassembler.IMM(opcode) << 24 >> 24;
                return String.format("cmp/eq H'%02x, R0", temp);
            }
            case 51456: {
                return String.format("and H'%02x, R0", Sh2Disassembler.IMM(opcode));
            }
            case 52480: {
                return String.format("and.b H'%02x, @(R0, GBR)", Sh2Disassembler.IMM(opcode));
            }
            case 51968: {
                return String.format("or H'%02x, R0", Sh2Disassembler.IMM(opcode));
            }
            case 52992: {
                return String.format("or.b H'%02x, @(R0, GBR)", Sh2Disassembler.IMM(opcode));
            }
            case 51200: {
                return String.format("tst H'%02x, R0", Sh2Disassembler.IMM(opcode));
            }
            case 52224: {
                return String.format("tst.b H'%02x, @(R0, GBR)", Sh2Disassembler.IMM(opcode));
            }
            case 51712: {
                return String.format("xor H'%02x, R0", Sh2Disassembler.IMM(opcode));
            }
            case 52736: {
                return String.format("xor.b H'%02x, @(R0, GBR)", Sh2Disassembler.IMM(opcode));
            }
            case 35584: {
                int temp = (Sh2Disassembler.IMM(opcode) << 24 >> 24) * 2;
                return String.format("bf H'%08x", temp + (pc + 4));
            }
            case 36608: {
                int temp = (Sh2Disassembler.IMM(opcode) << 24 >> 24) * 2;
                return String.format("bf/s H'%08x", temp + (pc + 4));
            }
            case 35072: {
                int temp = (Sh2Disassembler.IMM(opcode) << 24 >> 24) * 2;
                return String.format("bt H'%08x", temp + (pc + 4));
            }
            case 36096: {
                int temp = (Sh2Disassembler.IMM(opcode) << 24 >> 24) * 2;
                return String.format("bt/s H'%08x", temp + (pc + 4));
            }
            case 49920: {
                return String.format("trapa H'%02x", Sh2Disassembler.IMM(opcode) << 2);
            }
        }
        op = opcode & 0xF0FF;
        switch (op) {
            case 41: {
                return String.format("movt R%d", Sh2Disassembler.RN(opcode));
            }
            case 16401: {
                return String.format("cmp/pz R%d", Sh2Disassembler.RN(opcode));
            }
            case 16405: {
                return String.format("cmp/pl R%d", Sh2Disassembler.RN(opcode));
            }
            case 16400: {
                return String.format("dt R%d", Sh2Disassembler.RN(opcode));
            }
            case 16411: {
                return String.format("tas.b @R%d", Sh2Disassembler.RN(opcode));
            }
            case 16388: {
                return String.format("rotl R%d", Sh2Disassembler.RN(opcode));
            }
            case 16389: {
                return String.format("rotr R%d", Sh2Disassembler.RN(opcode));
            }
            case 16420: {
                return String.format("rotcl R%d", Sh2Disassembler.RN(opcode));
            }
            case 16421: {
                return String.format("rotcr R%d", Sh2Disassembler.RN(opcode));
            }
            case 16416: {
                return String.format("shal R%d", Sh2Disassembler.RN(opcode));
            }
            case 16417: {
                return String.format("shar R%d", Sh2Disassembler.RN(opcode));
            }
            case 16384: {
                return String.format("shll R%d", Sh2Disassembler.RN(opcode));
            }
            case 16385: {
                return String.format("shlr R%d", Sh2Disassembler.RN(opcode));
            }
            case 16392: {
                return String.format("shll2 R%d", Sh2Disassembler.RN(opcode));
            }
            case 16393: {
                return String.format("shlr2 R%d", Sh2Disassembler.RN(opcode));
            }
            case 16408: {
                return String.format("shll8 R%d", Sh2Disassembler.RN(opcode));
            }
            case 16409: {
                return String.format("shlr8 R%d", Sh2Disassembler.RN(opcode));
            }
            case 16424: {
                return String.format("shll16 R%d", Sh2Disassembler.RN(opcode));
            }
            case 16425: {
                return String.format("shlr16 R%d", Sh2Disassembler.RN(opcode));
            }
            case 35: {
                return String.format("braf R%d", Sh2Disassembler.RN(opcode));
            }
            case 3: {
                return String.format("bsrf R%d", Sh2Disassembler.RN(opcode));
            }
            case 16427: {
                return String.format("jmp @R%d", Sh2Disassembler.RN(opcode));
            }
            case 16395: {
                return String.format("jsr @R%d", Sh2Disassembler.RN(opcode));
            }
            case 16398: {
                return String.format("ldc R%d, SR", Sh2Disassembler.RN(opcode));
            }
            case 16414: {
                return String.format("ldc R%d, GBR", Sh2Disassembler.RN(opcode));
            }
            case 16430: {
                return String.format("ldc R%d, VBR", Sh2Disassembler.RN(opcode));
            }
            case 16391: {
                return String.format("ldc.l @R%d+, SR", Sh2Disassembler.RN(opcode));
            }
            case 16407: {
                return String.format("ldc.l @R%d+, GBR", Sh2Disassembler.RN(opcode));
            }
            case 16423: {
                return String.format("ldc.l @R%d+, VBR", Sh2Disassembler.RN(opcode));
            }
            case 16394: {
                return String.format("lds R%d, MACH", Sh2Disassembler.RN(opcode));
            }
            case 16410: {
                return String.format("lds R%d, MACL", Sh2Disassembler.RN(opcode));
            }
            case 16426: {
                return String.format("lds R%d, PR", Sh2Disassembler.RN(opcode));
            }
            case 16390: {
                return String.format("lds.l @R%d+, MACH", Sh2Disassembler.RN(opcode));
            }
            case 16406: {
                return String.format("lds.l @R%d+, MACL", Sh2Disassembler.RN(opcode));
            }
            case 16422: {
                return String.format("lds.l @R%d+, PR", Sh2Disassembler.RN(opcode));
            }
            case 2: {
                return String.format("stc SR, R%d", Sh2Disassembler.RN(opcode));
            }
            case 18: {
                return String.format("stc GBR, R%d", Sh2Disassembler.RN(opcode));
            }
            case 34: {
                return String.format("stc VBR, R%d", Sh2Disassembler.RN(opcode));
            }
            case 16387: {
                return String.format("stc.l SR, @-R%d", Sh2Disassembler.RN(opcode));
            }
            case 16403: {
                return String.format("stc.l GBR, @-R%d", Sh2Disassembler.RN(opcode));
            }
            case 16419: {
                return String.format("stc.l VBR, @-R%d", Sh2Disassembler.RN(opcode));
            }
            case 10: {
                return String.format("sts MACH, R%d", Sh2Disassembler.RN(opcode));
            }
            case 26: {
                return String.format("sts MACL, R%d", Sh2Disassembler.RN(opcode));
            }
            case 42: {
                return String.format("sts PR, R%d", Sh2Disassembler.RN(opcode));
            }
            case 16386: {
                return String.format("sts.l MACH, @-R%d", Sh2Disassembler.RN(opcode));
            }
            case 16402: {
                return String.format("sts.l MACL, @-R%d", Sh2Disassembler.RN(opcode));
            }
            case 16418: {
                return String.format("sts.l PR, @-R%d", Sh2Disassembler.RN(opcode));
            }
        }
        op = opcode & 0xFFFF;
        switch (op) {
            case 25: {
                return String.format("div0u", new Object[0]);
            }
            case 11: {
                return String.format("rts", new Object[0]);
            }
            case 40: {
                return String.format("clrmac", new Object[0]);
            }
            case 8: {
                return String.format("clrt", new Object[0]);
            }
            case 9: {
                return String.format("nop", new Object[0]);
            }
            case 43: {
                return String.format("rte", new Object[0]);
            }
            case 24: {
                return String.format("sett", new Object[0]);
            }
            case 27: {
                return String.format("sleep", new Object[0]);
            }
        }
        return "??? (" + Integer.toHexString(opcode) + ")";
    }
}

