/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.Sh2Dict;
import s32x.sh2.device.IntControl;

public class DivUnit
implements BufferUtil.Sh2Device {
    private static final Logger LOG = LogHelper.getLogger(DivUnit.class.getSimpleName());
    private static final int DIV_OVERFLOW_BIT = 0;
    private static final int DIV_OVERFLOW_INT_EN_BIT = 1;
    private static final int DIV_CYCLES = 39;
    private static final int DIV_OVF_CYCLES = 6;
    private static final String formatDiv = "%s div%d, dvd: %16X, dvsr: %08X, quotLong: %16X, quot32: %08x, rem: %08X";
    private static final String formatOvf = "%s div%d overflow, dvd: %16X, dvsr: %08X, quotLong: %16X, quot32: %08x, rem: %08X";
    private static final String formatDivBy0 = "%s div%d overflow (div by 0), dvd: %16X, dvsr: %08X";
    private static final boolean verbose = false;
    private final BufferUtil.CpuDeviceAccess cpu;
    private final ByteBuffer regs;
    private final IntControl intControl;

    public DivUnit(BufferUtil.CpuDeviceAccess cpu, IntControl intControl, ByteBuffer regs) {
        this.cpu = cpu;
        this.regs = regs;
        this.intControl = intControl;
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 reg, int pos, int value, Size size) {
        assert (size == Size.LONG);
        reg.regSpec.write(this.regs, value, Size.LONG);
        switch (reg) {
            case DIV_DVDNTL: {
                this.div64Dsp();
                break;
            }
            case DIV_DVDNT: {
                this.div32Dsp(value);
            }
        }
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int reg, Size size) {
        return BufferUtil.readBuffer(this.regs, reg, size);
    }

    private void div64Dsp() {
        long dh = BufferUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTH);
        long dl = BufferUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTL);
        long dvd = dh << 32 | dl & 0xFFFFFFFFL;
        int dvsr = BufferUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVSR);
        if (dvsr == 0) {
            this.handleOverflow(0L, true, String.format(formatDivBy0, new Object[]{this.cpu, 64, dvd, dvsr}));
            return;
        }
        long quotL = dvd / (long)dvsr;
        int quot = (int)quotL;
        int rem = (int)(dvd - (long)(quot * dvsr));
        BufferUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTH, Sh2Dict.RegSpecSh2.DIV_DVDNTUH, rem);
        if ((long)quot != quotL) {
            this.handleOverflow(quotL, false, String.format(formatOvf, new Object[]{this.cpu, 64, dvd, dvsr, quotL, quot, rem}));
            return;
        }
        BufferUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNT, Sh2Dict.RegSpecSh2.DIV_DVDNTL, Sh2Dict.RegSpecSh2.DIV_DVDNTUL, quot);
    }

    private void div32Dsp(int value) {
        BufferUtil.writeBufferLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTH, value >> 31);
        BufferUtil.writeBufferLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTL, value);
        int dvd = BufferUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNT);
        int dvsr = BufferUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVSR);
        if (dvsr == 0) {
            this.handleOverflow(0L, true, String.format(formatDivBy0, new Object[]{this.cpu, 32, dvd, dvsr}));
            return;
        }
        int quot = dvd / dvsr;
        int rem = dvd - quot * dvsr;
        BufferUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTH, Sh2Dict.RegSpecSh2.DIV_DVDNTUH, rem);
        BufferUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNT, Sh2Dict.RegSpecSh2.DIV_DVDNTL, Sh2Dict.RegSpecSh2.DIV_DVDNTUL, quot);
    }

    private void handleOverflow(long quot, boolean divBy0, String msg) {
        BufferUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.DIV_DVCR.addr, 0, 1, Size.LONG);
        int dvcr = Util.readBufferWord(this.regs, Sh2Dict.RegSpecSh2.DIV_DVCR.addr);
        int val = quot >= 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        BufferUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNT, Sh2Dict.RegSpecSh2.DIV_DVDNTL, Sh2Dict.RegSpecSh2.DIV_DVDNTUL, val);
        if ((dvcr & 1) > 0) {
            this.intControl.setOnChipDeviceIntPending(IntControl.Sh2Interrupt.DIVU);
            LOG.info(msg);
            LOG.warn("{} DivUnit interrupt", (Object)this.cpu);
        }
    }

    @Override
    public void reset() {
        BufferUtil.writeBufferLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVCR, 0);
    }
}

