/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;
import s32x.bus.Sh2MemoryParallel;
import s32x.dict.Sh2Dict;
import s32x.sh2.device.DmaHelper;
import s32x.sh2.device.IntControl;

public class DmaC
implements BufferUtil.Sh2Device {
    private static final Logger LOG = LogHelper.getLogger(DmaC.class.getSimpleName());
    private static final int SH2_CHCR_TRANSFER_END_BIT = 1;
    private static final boolean verbose = false;
    private final ByteBuffer regs;
    private final IntControl intControl;
    private final Sh2Bus memory;
    private final BufferUtil.CpuDeviceAccess cpu;
    private final DmaHelper.DmaChannelSetup[] dmaChannelSetup;
    private boolean oneDmaInProgress = false;

    public DmaC(BufferUtil.CpuDeviceAccess cpu, IntControl intControl, Sh2Bus memory, ByteBuffer regs) {
        this.cpu = cpu;
        this.regs = regs;
        this.memory = memory;
        this.intControl = intControl;
        this.dmaChannelSetup = new DmaHelper.DmaChannelSetup[]{DmaHelper.createChannel(0), DmaHelper.createChannel(1)};
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 regSpec, int pos, int value, Size size) {
        BufferUtil.writeBufferRaw(this.regs, pos, value, size);
        switch (this.cpu.regSide) {
            case SH2: {
                assert (pos == regSpec.addr) : Util.th(pos) + ", " + Util.th(regSpec.addr);
                this.writeSh2(this.cpu, regSpec, value, size);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int reg, Size size) {
        return BufferUtil.readBuffer(this.regs, reg, size);
    }

    @Override
    public void step(int cycles) {
        if (!this.oneDmaInProgress) {
            return;
        }
        for (DmaHelper.DmaChannelSetup c : this.dmaChannelSetup) {
            if (!c.dmaInProgress || !c.chcr_autoReq && !c.dreqLevel) continue;
            this.dmaOneStep(c);
        }
    }

    private void writeSh2(BufferUtil.CpuDeviceAccess cpu, Sh2Dict.RegSpecSh2 regSpec, int value, Size size) {
        switch (regSpec) {
            case DMA_CHCR0: 
            case DMA_CHCR1: {
                assert (size == Size.LONG);
                this.handleChannelControlWrite(regSpec.addr, value);
                break;
            }
            case DMA_DMAOR: {
                assert (size == Size.LONG);
                this.handleOperationRegWrite(value);
            }
        }
    }

    private void handleChannelControlWrite(int reg, int value) {
        int channel = reg >> 4 & 1;
        DmaHelper.DmaChannelSetup chan = this.dmaChannelSetup[channel];
        boolean wasEn = chan.chcr_dmaEn;
        DmaHelper.updateChannelControl(chan, value);
        if (wasEn != chan.chcr_dmaEn) {
            if (chan.chcr_dmaEn) {
                this.checkDmaStart(chan);
            } else {
                this.dmaEnd(chan, false);
            }
        }
    }

    private void handleOperationRegWrite(int value) {
        boolean dme;
        DmaHelper.updateChannelDmaor(this.dmaChannelSetup[0], value);
        DmaHelper.updateChannelDmaor(this.dmaChannelSetup[1], value);
        boolean bl = dme = (value & 1) > 0;
        if (dme) {
            this.checkDmaStart(this.dmaChannelSetup[0]);
            this.checkDmaStart(this.dmaChannelSetup[1]);
        } else {
            this.dmaEnd(this.dmaChannelSetup[0], false);
            this.dmaEnd(this.dmaChannelSetup[1], false);
        }
    }

    private void checkDmaStart(DmaHelper.DmaChannelSetup chan) {
        if (chan.chcr_dmaEn && chan.dmaor_dme && !chan.chcr_tranEndOk && (chan.chcr_autoReq || chan.dreqLevel) && !chan.dmaInProgress) {
            chan.dmaInProgress = true;
            this.updateOneDmaInProgress();
        }
    }

    @Deprecated
    public void dmaReqTriggerPwm(int channel, boolean enable) {
        DmaHelper.DmaChannelSetup d = this.dmaChannelSetup[channel];
        d.dreqLevel = enable;
        if (enable) {
            this.checkDmaStart(d);
            if (d.dmaInProgress) {
                MdRuntimeData.setAccessTypeExt(this.cpu);
                this.dmaOneStep(d);
                d.dreqLevel = false;
                d.dmaInProgress = false;
                this.updateOneDmaInProgress();
            }
        }
    }

    public void dmaReqTrigger(int channel, boolean enable) {
        this.dmaChannelSetup[channel].dreqLevel = enable;
        if (enable) {
            this.checkDmaStart(this.dmaChannelSetup[channel]);
        }
    }

    private void dmaOneStep(DmaHelper.DmaChannelSetup c) {
        int len = this.readBufferForChannel(c.channel, Sh2Dict.RegSpecSh2.DMA_TCR0.addr, Size.LONG) & 0xFFFFFF;
        int srcAddress = this.readBufferForChannel(c.channel, Sh2Dict.RegSpecSh2.DMA_SAR0.addr, Size.LONG);
        int destAddress = this.readBufferForChannel(c.channel, Sh2Dict.RegSpecSh2.DMA_DAR0.addr, Size.LONG);
        int steps = c.transfersPerStep;
        assert (this.cpu == MdRuntimeData.getAccessTypeExt());
        destAddress |= 0x20000000;
        srcAddress |= 0x20000000;
        assert (!(this.memory instanceof Sh2MemoryParallel));
        do {
            int val = this.memory.read(srcAddress, c.trnSize);
            this.memory.write(destAddress, val, c.trnSize);
            srcAddress += c.srcDelta;
            destAddress += c.destDelta;
            len = len - 1 & 0xFFFFFF;
        } while (--steps > 0 && len >= 0);
        this.writeBufferForChannel(c.channel, Sh2Dict.RegSpecSh2.DMA_DAR0.addr, destAddress, Size.LONG);
        this.writeBufferForChannel(c.channel, Sh2Dict.RegSpecSh2.DMA_SAR0.addr, srcAddress, Size.LONG);
        if (len <= 0) {
            this.dmaEnd(c, true);
            len = 0;
        }
        this.writeBufferForChannel(c.channel, Sh2Dict.RegSpecSh2.DMA_TCR0.addr, Math.max(len, 0), Size.LONG);
    }

    private void dmaEnd(DmaHelper.DmaChannelSetup c, boolean normal) {
        if (c.dmaInProgress) {
            c.dmaInProgress = false;
            c.dreqLevel = false;
            this.updateOneDmaInProgress();
            if (normal) {
                int chcr = this.setDmaChannelBitVal(c.channel, Sh2Dict.RegSpecSh2.DMA_CHCR0.addr + 2, 1, 1, Size.WORD);
                DmaHelper.updateChannelControl(c, chcr);
                if (c.chcr_intEn) {
                    this.intControl.setOnChipDeviceIntPending(c.channel == 0 ? IntControl.Sh2Interrupt.DMAC0 : IntControl.Sh2Interrupt.DMAC1);
                }
            }
        }
    }

    private void updateOneDmaInProgress() {
        this.oneDmaInProgress = this.dmaChannelSetup[0].dmaInProgress || this.dmaChannelSetup[1].dmaInProgress;
    }

    @Override
    public void reset() {
        this.writeBufferForChannel(0, Sh2Dict.RegSpecSh2.DMA_CHCR0.addr, 0, Size.LONG);
        this.writeBufferForChannel(1, Sh2Dict.RegSpecSh2.DMA_CHCR0.addr, 0, Size.LONG);
        BufferUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.DMA_DRCR0.addr, 0, Size.BYTE);
        BufferUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.DMA_DRCR1.addr, 0, Size.BYTE);
        BufferUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.DMA_DMAOR.addr, 0, Size.LONG);
        this.oneDmaInProgress = false;
    }

    public DmaHelper.DmaChannelSetup[] getDmaChannelSetup() {
        return this.dmaChannelSetup;
    }

    private void setDmaChannelBit(int channel, int regChan0, int bitPos, int bitVal, Size size) {
        BufferUtil.setBit(this.regs, regChan0 + (channel << 4) & 0x1FF, bitPos, bitVal, size);
    }

    private int setDmaChannelBitVal(int channel, int regChan0, int bitPos, int bitVal, Size size) {
        return BufferUtil.setBitVal(this.regs, regChan0 + (channel << 4) & 0x1FF, bitPos, bitVal, size);
    }

    private int readVcrDma(int channel) {
        return Util.readBufferLong(this.regs, Sh2Dict.RegSpecSh2.DMA_VRCDMA0.addr + (channel << 3) & 0x1FF) & 0xFF;
    }

    private int readBufferForChannel(int channel, int regChan0, Size size) {
        return BufferUtil.readBuffer(this.regs, regChan0 + (channel << 4) & 0x1FF, size);
    }

    private void writeBufferForChannel(int channel, int regChan0, int value, Size size) {
        BufferUtil.writeBufferRaw(this.regs, regChan0 + (channel << 4) & 0x1FF, value, size);
    }
}

