/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.S32xDict;
import s32x.dict.Sh2Dict;
import s32x.event.PollSysEventManager;
import s32x.sh2.device.IntControl;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.sh2.drc.Sh2DrcBlockOptimizer;

public class IntControlImpl
implements IntControl {
    private static final Logger LOG = LogHelper.getLogger(IntControlImpl.class.getSimpleName());
    private static final boolean verbose = false;
    private final Map<Sh2DeviceHelper.Sh2DeviceType, Integer> onChipDevicePriority;
    protected final Map<IntControl.Sh2Interrupt, IntControl.InterruptContext> s32xInt;
    protected IntControl.InterruptContext[] orderedIntCtx;
    static final int VALID_BIT_POS = 0;
    static final int PENDING_BIT_POS = 1;
    static final int TRIGGER_BIT_POS = 2;
    static final int INT_VALID_MASK = 1;
    static final int INT_PENDING_MASK = 2;
    static final int INT_TRIGGER_MASK = 4;
    private IntControl.InterruptContext currentInterrupt = LEV_0;
    private final ByteBuffer sh2_int_mask = ByteBuffer.allocate(2);
    private final ByteBuffer regs;
    private final BufferUtil.CpuDeviceAccess cpu;

    public static IntControl createInstance(BufferUtil.CpuDeviceAccess cpu, ByteBuffer regs) {
        return new IntControlImpl(cpu, regs);
    }

    public IntControlImpl(BufferUtil.CpuDeviceAccess cpu, ByteBuffer regs) {
        this.regs = regs;
        this.cpu = cpu;
        this.s32xInt = new HashMap<IntControl.Sh2Interrupt, IntControl.InterruptContext>(IntControl.Sh2Interrupt.values().length);
        this.onChipDevicePriority = new HashMap<Sh2DeviceHelper.Sh2DeviceType, Integer>();
        this.init();
    }

    @Override
    public void init() {
        this.s32xInt.clear();
        this.onChipDevicePriority.clear();
        Arrays.stream(Sh2DeviceHelper.Sh2DeviceType.values()).forEach(d -> this.onChipDevicePriority.put((Sh2DeviceHelper.Sh2DeviceType)((Object)d), 0));
        Arrays.stream(IntControl.Sh2Interrupt.values()).forEach(s -> {
            IntControl.InterruptContext intCtx = new IntControl.InterruptContext();
            intCtx.source = s;
            intCtx.level = s.level;
            IntControlImpl.setBit(intCtx, 0, 1);
            this.s32xInt.put((IntControl.Sh2Interrupt)((Object)s), intCtx);
        });
        this.orderedIntCtx = (IntControl.InterruptContext[])Arrays.stream(IntControl.Sh2Interrupt.vals).filter(si -> si.supported > 0).map(this.s32xInt::get).toArray(IntControl.InterruptContext[]::new);
        this.setIntsMasked(0);
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 regSh2, int pos, int value, Size size) {
        boolean changed = regSh2.regSpec.write(this.regs, pos, value, size);
        if (!changed) {
            return;
        }
        int val = this.read(regSh2, Size.WORD);
        switch (regSh2) {
            case INTC_IPRA: {
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.DIV, val >> 12 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.DMA, val >> 8 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.WDT, val >> 4 & 0xF);
                this.logExternalIntLevel(regSh2, val);
                break;
            }
            case INTC_IPRB: {
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.SCI, val >> 12 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.FRT, val >> 8 & 0xF);
                this.logExternalIntLevel(regSh2, val);
                break;
            }
            case INTC_ICR: {
                if ((val & 1) <= 0) break;
                LOG.error("{} Not supported: IRL Interrupt vector mode: External Vector", (Object)this.cpu);
                break;
            }
            case INTC_VCRA: 
            case INTC_VCRB: 
            case INTC_VCRC: 
            case INTC_VCRD: {
                LOG.info("{} uncommon: {}, val {} {}", new Object[]{this.cpu, regSh2.getName(), Util.th(value), size});
            }
        }
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int reg, Size size) {
        return BufferUtil.readBuffer(this.regs, reg, size);
    }

    private IntControl.InterruptContext getContextFromExternalInterrupt(IntControl.Sh2Interrupt intp) {
        IntControl.InterruptContext ctx = this.s32xInt.get((Object)intp);
        assert (ctx != null && ctx.source == intp && ctx.level == intp.level && intp.external > 0) : ctx;
        return ctx;
    }

    private void setIntMasked(int ipt, int isValid) {
        boolean change;
        IntControl.Sh2Interrupt sh2Interrupt = intVals[ipt];
        IntControl.InterruptContext source = this.getContextFromExternalInterrupt(sh2Interrupt);
        boolean bl = change = (source.intState & 1) != isValid;
        if (change) {
            IntControlImpl.setBit(source, 0, isValid);
            if (ipt == IntControl.Sh2Interrupt.CMD_08.level) {
                IntControlImpl.setBit(source, 2, isValid > 0 && (source.intState & 2) > 0);
            }
            this.resetInterruptLevel();
            this.logInfo("MASK", source);
        }
    }

    @Override
    public void setIntsMasked(int value) {
        for (int i = 0; i < 4; ++i) {
            int imask = value & 1 << i;
            int sh2Int = 6 + (i << 1);
            this.setIntMasked(sh2Int, imask > 0 ? 1 : 0);
        }
    }

    @Override
    public void reloadSh2IntMask() {
        int newVal = BufferUtil.readBuffer(this.sh2_int_mask, S32xDict.RegSpecS32x.SH2_INT_MASK.addr, Size.WORD);
        this.setIntsMasked(newVal & 0xF);
    }

    @Override
    public void setOnChipDeviceIntPending(IntControl.Sh2Interrupt source) {
        assert (source != null);
        IntControl.InterruptContext intCtx = this.s32xInt.get((Object)source);
        assert (intCtx != null);
        intCtx.source = source;
        intCtx.level = this.onChipDevicePriority.get((Object)source.deviceType);
        if (intCtx.level > 0) {
            IntControlImpl.setBit(intCtx, 1, 1);
            IntControlImpl.setBit(intCtx, 2, 1);
            this.resetInterruptLevel();
        }
    }

    @Override
    public int readSh2IntMaskReg(int pos, Size size) {
        return BufferUtil.readBuffer(this.sh2_int_mask, pos, size);
    }

    @Override
    public void setIntPending(IntControl.Sh2Interrupt intpt, boolean isPending) {
        boolean val;
        assert (intpt.external > 0);
        IntControl.InterruptContext source = this.getContextFromExternalInterrupt(intpt);
        boolean bl = val = (source.intState & 2) > 0;
        if (val != isPending) {
            boolean valid;
            boolean bl2 = valid = (source.intState & 1) > 0;
            if (valid) {
                IntControlImpl.setBit(source, 1, isPending);
                if (valid && isPending) {
                    IntControlImpl.setBit(source, 2, 1);
                    source.level = intpt.level;
                    this.resetInterruptLevel();
                } else {
                    IntControlImpl.setBit(source, 2, 0);
                }
                this.logInfo("PENDING", source);
            }
        }
    }

    private void checkMultiInterrupt() {
        int cnt = (int)Arrays.stream(this.orderedIntCtx).filter(c -> c.intState > 4).count();
        if (cnt > 1) {
            String str = Arrays.stream(this.orderedIntCtx).filter(c -> c.intState > 4).map(IntControl.InterruptContext::toString).collect(Collectors.joining(","));
            LogHelper.logWarnOnce(LOG, "Multiple interrupts: " + str, new Object[0]);
        }
    }

    private IntControl.InterruptContext getCurrentInterrupt() {
        IntControl.InterruptContext current = LEV_0;
        if (BufferUtil.assertionsEnabled) {
            this.checkMultiInterrupt();
        }
        int max = 0;
        for (int i = 0; i < this.orderedIntCtx.length; ++i) {
            IntControl.InterruptContext ctx = this.orderedIntCtx[i];
            if (ctx.intState <= 4 || ctx.level <= max) continue;
            current = ctx;
            max = ctx.level;
        }
        return current;
    }

    private void resetInterruptLevel() {
        IntControl.InterruptContext prev = this.currentInterrupt;
        IntControl.InterruptContext current = this.getCurrentInterrupt();
        assert (current == LEV_0 || current.level > 0);
        this.currentInterrupt = current;
        this.fireInterruptSysEventMaybe(prev);
    }

    private void fireInterruptSysEventMaybe(IntControl.InterruptContext prev) {
        Sh2DrcBlockOptimizer.PollerCtx ctx;
        if (this.currentInterrupt.level != prev.level && this.currentInterrupt.level > 0 && (ctx = PollSysEventManager.instance.getPoller(this.cpu)) != Sh2DrcBlockOptimizer.NO_POLLER && (ctx.isPollingActive() || ctx.isPollingBusyLoop())) {
            PollSysEventManager.instance.fireSysEvent(this.cpu, PollSysEventManager.SysEvent.INT);
        }
    }

    @Override
    public void clearExternalInterrupt(IntControl.Sh2Interrupt intType) {
        this.clearInterrupt(this.getContextFromExternalInterrupt(intType));
    }

    private void clearInterrupt(IntControl.InterruptContext source) {
        source.intState &= 0xFFFFFFF9;
        source.clearLevel();
        this.resetInterruptLevel();
        this.logInfo("CLEAR", source);
    }

    @Override
    public void clearCurrentInterrupt() {
        this.clearInterrupt(this.currentInterrupt);
    }

    @Override
    public IntControl.InterruptContext getInterruptContext() {
        return this.currentInterrupt;
    }

    @Override
    public int getVectorNumber() {
        if (this.currentInterrupt.source.external == 0) {
            return this.getOnChipDeviceVectorNumber(this.currentInterrupt);
        }
        return 64 + (this.currentInterrupt.level >> 1);
    }

    private int getOnChipDeviceVectorNumber(IntControl.InterruptContext ctx) {
        int vn = -1;
        switch (ctx.source.deviceType) {
            case DMA: {
                int offset = ctx.source.subType == IntControl.OnChipSubType.DMA_C0 ? 0 : 1;
                vn = BufferUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.INTC_VCRDMA0.addr + (offset << 3), Size.LONG) & 0xFF;
                break;
            }
            case WDT: {
                vn = BufferUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.INTC_VCRWDT.addr, Size.BYTE);
                break;
            }
            case DIV: {
                vn = BufferUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.INTC_VCRDIV.addr, Size.LONG) & 0x7F;
                break;
            }
            case SCI: {
                int pos = ctx.source.subType == IntControl.OnChipSubType.RXI ? Sh2Dict.RegSpecSh2.INTC_VCRA.addr + 1 : Sh2Dict.RegSpecSh2.INTC_VCRB.addr;
                vn = BufferUtil.readBuffer(this.regs, pos, Size.BYTE);
                break;
            }
            case FRT: {
                vn = BufferUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.INTC_VCRD.addr, Size.BYTE) & 0x7F;
                break;
            }
            case NONE: {
                break;
            }
            default: {
                LOG.error("{} Unhandled interrupt for device: {}, level: {}", new Object[]{this.cpu, ctx.source.deviceType, ctx.level});
            }
        }
        return vn;
    }

    @Override
    public ByteBuffer getSh2_int_mask_regs() {
        return this.sh2_int_mask;
    }

    private void logInfo(String action, IntControl.InterruptContext source) {
    }

    private void logExternalIntLevel(Sh2Dict.RegSpecSh2 regSpec, int val) {
        if (regSpec == Sh2Dict.RegSpecSh2.INTC_IPRA) {
            LOG.info("{} set IPRA levels, {}:{}, {}:{}, {}:{}", new Object[]{this.cpu, Sh2DeviceHelper.Sh2DeviceType.DIV, val >> 12, Sh2DeviceHelper.Sh2DeviceType.DMA, val >> 8 & 0xF, Sh2DeviceHelper.Sh2DeviceType.WDT, val >> 4 & 0xF});
        } else if (regSpec == Sh2Dict.RegSpecSh2.INTC_IPRB) {
            LOG.info("{} set IPRB levels, {}:{}, {}:{}", new Object[]{this.cpu, Sh2DeviceHelper.Sh2DeviceType.SCI, val >> 12, Sh2DeviceHelper.Sh2DeviceType.FRT, val >> 8 & 0xF});
        }
    }

    private static void setBit(IntControl.InterruptContext ctx, int bitPos, boolean bitValue) {
        IntControlImpl.setBit(ctx, bitPos, bitValue ? 1 : 0);
    }

    private static void setBit(IntControl.InterruptContext ctx, int bitPos, int bitValue) {
        ctx.intState = Util.setBit(ctx.intState, bitPos, bitValue);
    }

    @Override
    public void reset() {
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_IPRA, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_IPRB, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRA, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRB, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRC, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRD, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRWDT, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRDIV, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRDMA0, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRDMA1, this.regs, 0, Size.WORD);
        BufferUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_ICR, this.regs, 0, Size.WORD);
    }
}

