/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.drc;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import omegadrive.util.LogHelper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.slf4j.Logger;
import s32x.Sh2MMREG;
import s32x.bus.Sh2Bus;
import s32x.sh2.Sh2Context;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.sh2.drc.Ow2Sh2Bytecode;
import s32x.sh2.drc.Ow2Sh2Helper;
import s32x.sh2.drc.Sh2Block;
import s32x.sh2.drc.Sh2BlockRecompiler;
import s32x.sh2.prefetch.Sh2Prefetch;

public class Ow2Sh2BlockRecompiler
implements Sh2BlockRecompiler.InternalSh2BlockRecompiler {
    private static final Logger LOG = LogHelper.getLogger(Ow2Sh2BlockRecompiler.class.getSimpleName());
    public static final String intArrayDesc = Type.getDescriptor(int[].class);
    public static final String intDesc = Type.getDescriptor(Integer.TYPE);
    public static final String noArgsNoRetDesc = "()V";
    public static final String classConstructor = "<init>";
    public static final String runMethodName = "run";

    @Override
    public byte[] createClassBinary(Sh2Block block, Sh2Prefetch.Sh2DrcContext drcCtx, String blockClass, Class<?> memoryClass) {
        String blockClassDesc = blockClass.replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        cw.visit(55, 17, blockClassDesc, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(Runnable.class)});
        cw.visitField(18, Ow2Sh2Helper.DRC_CLASS_FIELD.regs.name(), intArrayDesc, null, null).visitEnd();
        cw.visitField(18, Ow2Sh2Helper.DRC_CLASS_FIELD.opcodes.name(), intArrayDesc, null, null).visitEnd();
        cw.visitField(18, Ow2Sh2Helper.DRC_CLASS_FIELD.sh2DrcContext.name(), Type.getDescriptor(Sh2Prefetch.Sh2DrcContext.class), null, null).visitEnd();
        cw.visitField(18, Ow2Sh2Helper.DRC_CLASS_FIELD.sh2Context.name(), Type.getDescriptor(Sh2Context.class), null, null).visitEnd();
        cw.visitField(18, Ow2Sh2Helper.DRC_CLASS_FIELD.sh2MMREG.name(), Type.getDescriptor(Sh2MMREG.class), null, null).visitEnd();
        cw.visitField(18, Ow2Sh2Helper.DRC_CLASS_FIELD.memory.name(), Type.getDescriptor(memoryClass), null, null).visitEnd();
        MethodVisitor mv = cw.visitMethod(1, classConstructor, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(int[].class), Type.getType(int[].class), Type.getType(Sh2Prefetch.Sh2DrcContext.class)}), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), classConstructor, noArgsNoRetDesc, false);
        Ow2Sh2BlockRecompiler.setClassField(mv, blockClassDesc, 1, Ow2Sh2Helper.DRC_CLASS_FIELD.regs, intArrayDesc);
        Ow2Sh2BlockRecompiler.setClassField(mv, blockClassDesc, 2, Ow2Sh2Helper.DRC_CLASS_FIELD.opcodes, intArrayDesc);
        Ow2Sh2BlockRecompiler.setClassField(mv, blockClassDesc, 3, Ow2Sh2Helper.DRC_CLASS_FIELD.sh2DrcContext, Type.getDescriptor(Sh2Prefetch.Sh2DrcContext.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitFieldInsn(180, Type.getInternalName(Sh2Prefetch.Sh2DrcContext.class), Ow2Sh2Helper.SH2_DRC_CTX_CLASS_FIELD.sh2Ctx.name(), Type.getDescriptor(Sh2Context.class));
        mv.visitFieldInsn(181, blockClassDesc, Ow2Sh2Helper.DRC_CLASS_FIELD.sh2Context.name(), Type.getDescriptor(Sh2Context.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitFieldInsn(180, Type.getInternalName(Sh2Prefetch.Sh2DrcContext.class), Ow2Sh2Helper.SH2_DRC_CTX_CLASS_FIELD.sh2Ctx.name(), Type.getDescriptor(Sh2Context.class));
        mv.visitFieldInsn(180, Type.getInternalName(Sh2Context.class), Ow2Sh2Helper.SH2CTX_CLASS_FIELD.devices.name(), Type.getDescriptor(Sh2DeviceHelper.Sh2DeviceContext.class));
        mv.visitFieldInsn(180, Type.getInternalName(Sh2DeviceHelper.Sh2DeviceContext.class), Ow2Sh2Helper.SH2_DEVICE_CTX_CLASS_FIELD.sh2MMREG.name(), Type.getDescriptor(Sh2MMREG.class));
        mv.visitFieldInsn(181, blockClassDesc, Ow2Sh2Helper.DRC_CLASS_FIELD.sh2MMREG.name(), Type.getDescriptor(Sh2MMREG.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitFieldInsn(180, Type.getInternalName(Sh2Prefetch.Sh2DrcContext.class), Ow2Sh2Helper.SH2_DRC_CTX_CLASS_FIELD.memory.name(), Type.getDescriptor(Sh2Bus.class));
        if (memoryClass != Sh2Bus.class) {
            mv.visitTypeInsn(192, Type.getInternalName(memoryClass));
        }
        mv.visitFieldInsn(181, blockClassDesc, Ow2Sh2Helper.DRC_CLASS_FIELD.memory.name(), Type.getDescriptor(memoryClass));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(17, runMethodName, noArgsNoRetDesc, null, null);
        LocalVariablesSorter lvs = new LocalVariablesSorter(17, noArgsNoRetDesc, mv);
        int limit = block.prefetchWords.length;
        Sh2Prefetch.BytecodeContext ctx = new Sh2Prefetch.BytecodeContext();
        Sh2Prefetch.BytecodeContext dsCtx = new Sh2Prefetch.BytecodeContext();
        ctx.classDesc = dsCtx.classDesc = blockClassDesc;
        ctx.drcCtx = dsCtx.drcCtx = drcCtx;
        ctx.mv = dsCtx.mv = lvs;
        int totCycles = 0;
        for (int i = 0; i < block.prefetchLenWords; ++i) {
            Sh2BlockRecompiler.setDrcContext(ctx, block.inst[i], false);
            if (ctx.sh2Inst.isBranchDelaySlot()) {
                Sh2BlockRecompiler.setDrcContext(dsCtx, block.inst[i + 1], true);
                ctx.delaySlotCtx = dsCtx;
            }
            Ow2Sh2Helper.createInst(ctx);
            if (!ctx.sh2Inst.isBranch()) {
                totCycles += ctx.sh2Inst.cycles;
            }
            if (ctx.sh2Inst.isBranchDelaySlot()) break;
        }
        if (block.isNoJump()) {
            Ow2Sh2Bytecode.setPcExt(ctx, block.inst[limit - 1].pc + 2);
        }
        Ow2Sh2Bytecode.subCyclesExt(ctx, totCycles);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void setClassField(MethodVisitor mv, String classDesc, int varIndex, Ow2Sh2Helper.DRC_CLASS_FIELD field, String typeDesc) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, varIndex);
        mv.visitFieldInsn(181, classDesc, field.name(), typeDesc);
    }

    @Override
    public void printSource(Path file, byte[] code) {
        try (FileWriter fileWriter = new FileWriter(file.toFile());
             PrintWriter pw = new PrintWriter(fileWriter);){
            ClassReader reader = new ClassReader(code);
            TraceClassVisitor visitor = new TraceClassVisitor(null, (Printer)new Textifier(), pw);
            reader.accept((ClassVisitor)visitor, 8);
        }
        catch (Exception e) {
            LOG.error(file.toString(), (Throwable)e);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        String p = "./res/drc_1652793435182/sh2.sh2.drc.S_6000390_19768421105194.class";
        ASMifier.main((String[])new String[]{p});
    }
}

