/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.drc;

import java.util.Arrays;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import org.slf4j.Logger;
import s32x.Sh2MMREG;
import s32x.bus.Sh2MemoryParallel;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Helper;
import s32x.sh2.drc.Sh2Block;
import s32x.sh2.drc.Sh2DrcBlockOptimizer;

public class Sh2BlockParallel
extends Sh2Block {
    private static final Logger LOG = LogHelper.getLogger(Sh2BlockParallel.class.getSimpleName());
    private Sh2Context[] cloneCtxs;
    private static final boolean verbose = false;

    public Sh2BlockParallel(int pc, BufferUtil.CpuDeviceAccess cpu) {
        super(pc, cpu);
    }

    private void runBlockParallel(Sh2 sh2, Sh2MMREG sm) {
        assert (this.prefetchPc != -1);
        assert ((this.blockFlags & 8) > 0);
        if (this.stage2Drc != null) {
            if (Sh2Helper.Sh2Config.get().pollDetectEn) {
                Sh2DrcBlockOptimizer.handlePoll(this);
            }
            this.prepareInterpreterParallel();
            this.stage2Drc.run();
            this.runInterpreterParallel(sh2, sm);
            return;
        }
        ((Sh2MemoryParallel)this.drcContext.memory).setActive(false);
        this.runInterpreter(sh2, sm, this.drcContext.sh2Ctx);
    }

    private void prepareInterpreterParallel() {
        if (this.cloneCtxs == null) {
            this.cloneCtxs = new Sh2Context[]{new Sh2Context(BufferUtil.CpuDeviceAccess.MASTER, false), new Sh2Context(BufferUtil.CpuDeviceAccess.SLAVE, false)};
        }
        Sh2Context ctx = this.drcContext.sh2Ctx;
        Sh2Context cloneCtx = this.cloneCtxs[ctx.cpuAccess.ordinal()];
        cloneCtx.PC = ctx.PC;
        cloneCtx.delayPC = ctx.delayPC;
        cloneCtx.GBR = ctx.GBR;
        cloneCtx.MACL = ctx.MACL;
        cloneCtx.SR = ctx.SR;
        cloneCtx.MACH = ctx.MACH;
        cloneCtx.VBR = ctx.VBR;
        cloneCtx.PR = ctx.PR;
        cloneCtx.opcode = ctx.opcode;
        cloneCtx.fetchResult = ctx.fetchResult;
        cloneCtx.cycles = ctx.cycles;
        cloneCtx.cycles_ran = ctx.cycles_ran;
        System.arraycopy(ctx.registers, 0, cloneCtx.registers, 0, ctx.registers.length);
        Sh2MemoryParallel sp = (Sh2MemoryParallel)this.drcContext.memory;
        sp.setActive(true);
    }

    private void runInterpreterParallel(Sh2 sh2, Sh2MMREG sm) {
        int delay = MdRuntimeData.getCpuDelayExt();
        Sh2MemoryParallel sp = (Sh2MemoryParallel)this.drcContext.memory;
        sp.setReplayMode(true);
        Sh2Context ctx = this.drcContext.sh2Ctx;
        Sh2Context intCtx = this.cloneCtxs[ctx.cpuAccess.ordinal()];
        sh2.setCtx(intCtx);
        boolean log = false;
        try {
            this.runInterpreter(sh2, sm, intCtx);
        }
        catch (Error | Exception e) {
            LOG.error("", e);
            log = true;
        }
        sh2.setCtx(ctx);
        log = ctx.equals(intCtx) ? (log |= !Arrays.equals(ctx.registers, intCtx.registers)) : true;
        if (log) {
            LOG.info("\ndrc: {}\nint: {}\n{}", new Object[]{ctx, intCtx, Sh2Helper.toListOfInst(this)});
            throw new RuntimeException();
        }
        sp.setReplayMode(false);
        sp.clear();
        sp.setActive(false);
        MdRuntimeData.resetCpuDelayExt(delay);
    }
}

