/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.prefetch;

import java.nio.ByteBuffer;
import java.util.Arrays;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;
import s32x.dict.S32xDict;
import s32x.dict.S32xMemAccessDelay;
import s32x.event.PollSysEventManager;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Debug;
import s32x.sh2.Sh2Helper;
import s32x.sh2.Sh2Instructions;
import s32x.sh2.cache.Sh2Cache;
import s32x.sh2.drc.Sh2Block;
import s32x.sh2.drc.Sh2DrcBlockOptimizer;
import s32x.sh2.prefetch.Sh2Prefetcher;
import s32x.util.BiosHolder;

public class Sh2Prefetch
implements Sh2Prefetcher {
    private static final Logger LOG = LogHelper.getLogger(Sh2Prefetch.class.getSimpleName());
    private static final boolean ENABLE_BLOCK_RECYCLING = true;
    private static final boolean SH2_LOG_PC_HITS = false;
    public static final int PC_CACHE_AREA_SHIFT = 28;
    private static final boolean verbose = false;
    private static final boolean collectStats = false;
    private final Sh2Prefetcher.Stats[] stats = new Sh2Prefetcher.Stats[]{new Sh2Prefetcher.Stats(BufferUtil.CpuDeviceAccess.MASTER), new Sh2Prefetcher.Stats(BufferUtil.CpuDeviceAccess.SLAVE)};
    private final Sh2Bus memory;
    private final Sh2Cache[] cache;
    private final Sh2DrcContext[] drcContext;
    private final Sh2Helper.Sh2Config sh2Config;
    private final int[] opcodeWords;
    public final int romSize;
    public final int romMask;
    public final BiosHolder.BiosData[] bios;
    public final ByteBuffer sdram;
    public final ByteBuffer rom;
    private final Sh2Block baseBlock;
    static final int RANGE_MASK = 0xFFFFFFF;
    long cnt = 0L;

    public Sh2Prefetch(Sh2Bus memory, Sh2Cache[] cache, Sh2DrcContext[] sh2Ctx) {
        this.cache = cache;
        this.memory = memory;
        this.drcContext = sh2Ctx;
        Sh2Bus.MemoryDataCtx mdc = memory.getMemoryDataCtx();
        this.romMask = mdc.romMask;
        this.romSize = mdc.romSize;
        this.sdram = mdc.sdram;
        this.rom = mdc.rom;
        this.bios = mdc.bios;
        this.opcodeWords = new int[Sh2Block.MAX_INST_LEN];
        this.sh2Config = Sh2Helper.Sh2Config.get();
        this.baseBlock = new Sh2Block(0, BufferUtil.CpuDeviceAccess.MASTER);
    }

    private Sh2Block doPrefetch(Sh2Helper.Sh2PcInfoWrapper piw, int pc, BufferUtil.CpuDeviceAccess cpu) {
        boolean addBlockToList;
        Sh2Block baseBlock = this.doPrefetchInternal(pc, cpu);
        Sh2Block match = this.findMatchingBlockIfAny(baseBlock, piw);
        if (match != Sh2Block.INVALID_BLOCK) {
            return match;
        }
        Sh2Block block = new Sh2Block(pc, cpu);
        this.populate(baseBlock, block);
        assert (block.getCpu() == block.drcContext.cpu && block.getCpu() == cpu);
        boolean bl = addBlockToList = !piw.knownBlocks.isEmpty();
        if (addBlockToList) {
            Sh2Block prev = piw.addToKnownBlocks(block);
            assert (prev == null);
        }
        return block;
    }

    private Sh2Block findMatchingBlockIfAny(Sh2Block baseBlock, Sh2Helper.Sh2PcInfoWrapper piw) {
        Sh2Block entry;
        boolean tryRecycleBlock = !piw.knownBlocks.isEmpty();
        Sh2Block res = Sh2Block.INVALID_BLOCK;
        if (tryRecycleBlock && (entry = piw.knownBlocks.getOrDefault(baseBlock.hashCodeWords & 0xFFFF, Sh2Block.INVALID_BLOCK)) != Sh2Block.INVALID_BLOCK) {
            if (entry.hashCodeWords != baseBlock.hashCodeWords) {
                LOG.error("Hash collision:\n{}\n{}", (Object)baseBlock, (Object)entry);
                return Sh2Block.INVALID_BLOCK;
            }
            assert (Arrays.equals(entry.prefetchWords, 0, baseBlock.prefetchLenWords, this.opcodeWords, 0, baseBlock.prefetchLenWords));
            entry.setValid();
            entry.nextBlock = Sh2Block.INVALID_BLOCK;
            res = entry;
        }
        return res;
    }

    private void populate(Sh2Block from, Sh2Block to) {
        to.start = from.start;
        to.pcMasked = from.pcMasked;
        to.fetchBuffer = from.fetchBuffer;
        to.fetchMemAccessDelay = from.fetchMemAccessDelay;
        to.pcMasked = from.pcMasked;
        to.setCacheFetch(from.isCacheFetch());
        to.prefetchLenWords = from.prefetchLenWords;
        to.hashCodeWords = from.hashCodeWords;
        to.end = from.start + (from.prefetchLenWords - 1 << 1);
        to.prefetchWords = Arrays.copyOf(this.opcodeWords, from.prefetchLenWords);
        to.drcContext = this.drcContext[to.getCpu().ordinal()];
        to.setNoJump(from.isNoJump());
        to.stage1(Sh2Instructions.generateInst(to.prefetchWords));
    }

    private Sh2Block doPrefetchInternal(int pc, BufferUtil.CpuDeviceAccess cpu) {
        Sh2Block block = this.baseBlock;
        Sh2Cache sh2Cache = this.cache[cpu.ordinal()];
        boolean isCache = pc >>> 28 == 0 && sh2Cache.getCacheContext().cacheEn > 0;
        block.setCacheFetch(pc >>> 28 == 0);
        this.setupPrefetch(block, pc, cpu);
        if (isCache) {
            sh2Cache.cacheMemoryRead(pc, Size.WORD);
        }
        int wordsCount = this.fillOpcodes(cpu, pc, block);
        assert (wordsCount > 0 && wordsCount <= this.opcodeWords.length);
        block.prefetchLenWords = wordsCount;
        block.hashCodeWords = BufferUtil.hashCode(this.opcodeWords, wordsCount);
        return block;
    }

    private int fillOpcodes(BufferUtil.CpuDeviceAccess cpu, int pc, Sh2Block block) {
        return this.fillOpcodes(cpu, pc, block.start, block.fetchBuffer, block, this.opcodeWords);
    }

    private int fillOpcodes(BufferUtil.CpuDeviceAccess cpu, int pc, int blockStart, ByteBuffer fetchBuffer, Sh2Block block, int[] opcodeWords) {
        Sh2Cache sh2Cache = this.cache[cpu.ordinal()];
        int pcLimit = pc + Sh2Block.SH2_DRC_MAX_BLOCK_LEN_BYTES - 2;
        boolean isCache = pc >>> 28 == 0 && sh2Cache.getCacheContext().cacheEn > 0;
        Sh2Instructions.Sh2InstructionWrapper[] op = Sh2Instructions.instOpcodeMap;
        boolean breakOnJump = false;
        int wordsCount = 0;
        int bytePos = blockStart;
        int currentPc = pc;
        do {
            int val = isCache ? sh2Cache.readDirect(currentPc, Size.WORD) : Util.readBufferWord(fetchBuffer, bytePos) & 0xFFFF;
            Sh2Instructions.Sh2BaseInstruction inst = op[val].inst;
            opcodeWords[wordsCount++] = val;
            if (inst.isIllegal()) {
                LOG.error("{} Invalid fetch, start PC: {}, current: {} opcode: {}", new Object[]{cpu, Util.th(pc), Util.th(bytePos), Util.th(val)});
                break;
            }
            if (inst.isBranch()) {
                if (inst.isBranchDelaySlot()) {
                    int nextVal = isCache ? sh2Cache.readDirect(currentPc + 2, Size.WORD) : Util.readBufferWord(fetchBuffer, bytePos + 2) & 0xFFFF;
                    opcodeWords[wordsCount++] = nextVal;
                    if (BufferUtil.assertionsEnabled && op[nextVal].inst.isIllegalSlot()) {
                        LogHelper.logWarnOnce(LOG, "{} Illegal delay slot opcode, start PC: {}, current: {} opcode: {}, inst: {}", new Object[]{cpu, Util.th(pc), Util.th(bytePos), Util.th(nextVal), op[nextVal].inst});
                    }
                }
                breakOnJump = true;
                break;
            }
            bytePos += 2;
        } while ((currentPc += 2) < pcLimit);
        assert (currentPc != pcLimit || !breakOnJump);
        block.setNoJump(currentPc == pcLimit && !breakOnJump);
        return wordsCount;
    }

    private void setupPrefetch(Sh2Block block, int pc, BufferUtil.CpuDeviceAccess cpu) {
        block.start = pc & 0xFFFFFF;
        switch (pc >> 24) {
            case 6: 
            case 38: {
                block.pcMasked = pc & 0x3FFFF;
                block.fetchMemAccessDelay = 6;
                block.fetchBuffer = this.sdram;
                break;
            }
            case 2: 
            case 34: {
                block.pcMasked = pc & this.romMask;
                block.fetchMemAccessDelay = 0;
                block.fetchBuffer = this.rom;
                break;
            }
            case 0: 
            case 32: {
                block.fetchBuffer = this.bios[cpu.ordinal()].buffer;
                block.pcMasked = pc;
                block.fetchMemAccessDelay = 5;
                break;
            }
            default: {
                if (pc >>> 28 == 12) {
                    int twoWay = this.cache[cpu.ordinal()].getCacheContext().twoWay;
                    int mask = 4095 >> twoWay;
                    block.start = Math.max(0, block.start) & mask;
                    block.fetchMemAccessDelay = 4;
                    block.fetchBuffer = this.cache[cpu.ordinal()].getDataArray();
                    block.pcMasked = pc & mask;
                    break;
                }
                LOG.error("{} Unhandled prefetch: {}", (Object)cpu, (Object)Util.th(pc));
                throw new RuntimeException("Unhandled prefetch: " + Util.th(pc));
            }
        }
        block.start = block.pcMasked;
        assert (block.fetchBuffer != null && block.fetchBuffer.array().length > 1) : String.valueOf((Object)cpu) + " " + Util.th(pc) + " " + String.valueOf(block);
    }

    private void checkBlock(Sh2Helper.FetchResult fetchResult, BufferUtil.CpuDeviceAccess cpu) {
        int pc = fetchResult.pc;
        Sh2Helper.Sh2PcInfoWrapper piw = Sh2Helper.get(pc, cpu);
        assert (piw != null);
        if (piw == Sh2Helper.SH2_NOT_VISITED) {
            piw = Sh2Helper.getOrCreate(pc, cpu);
        }
        if (piw.block.isValid()) {
            assert (fetchResult.pc == piw.block.prefetchPc) : Util.th(fetchResult.pc);
            piw.block.addHit();
            fetchResult.block = piw.block;
            return;
        }
        Sh2Block block = this.doPrefetch(piw, pc, cpu);
        Sh2Block prev = piw.block;
        assert (prev != null);
        assert (block != null && block.isValid());
        assert (Sh2Helper.SH2_NOT_VISITED.block == Sh2Block.INVALID_BLOCK) : String.valueOf((Object)cpu) + "," + Util.th(pc) + "," + String.valueOf(Sh2Helper.SH2_NOT_VISITED.block);
        if (prev != Sh2Block.INVALID_BLOCK && !block.equals(prev)) {
            LOG.warn("{} New block generated at PC: {}\nPrev: {}\nNew : {}", new Object[]{cpu, Util.th(pc), prev, block});
        }
        piw.setBlock(block);
        fetchResult.block = block;
    }

    @Override
    public void fetch(Sh2Helper.FetchResult fetchResult, BufferUtil.CpuDeviceAccess cpu) {
        boolean isPrevInvalid;
        int pc = fetchResult.pc;
        if (!this.sh2Config.prefetchEn) {
            fetchResult.opcode = this.memory.read(pc, Size.WORD);
            return;
        }
        Sh2Block prev = fetchResult.block;
        boolean bl = isPrevInvalid = !prev.isValid();
        assert (fetchResult.pc != fetchResult.block.prefetchPc);
        this.checkBlock(fetchResult, cpu);
        Sh2Block block = fetchResult.block;
        assert (block != prev || isPrevInvalid) : "\n" + String.valueOf(block);
        block.poller.spinCount = 0;
        this.cacheOnFetch(pc, block.prefetchWords[0], cpu);
        S32xMemAccessDelay.addReadCpuDelay(block.fetchMemAccessDelay);
        assert (block != Sh2Block.INVALID_BLOCK && block.prefetchWords != null && block.prefetchWords.length > 0);
        fetchResult.opcode = block.prefetchWords[0];
        assert (fetchResult.block != null);
    }

    @Override
    public int fetchDelaySlot(int pc, Sh2Helper.FetchResult ft, BufferUtil.CpuDeviceAccess cpu) {
        if (!this.sh2Config.prefetchEn) {
            return this.memory.read(pc, Size.WORD);
        }
        Sh2Block block = ft.block;
        int blockPc = block.prefetchPc;
        if (!block.isValid()) {
            blockPc &= 0xFFFFFFFE;
        }
        int pcDeltaWords = pc - blockPc >> 1;
        assert (pcDeltaWords < block.prefetchLenWords && pcDeltaWords >= 0) : Util.th(pc) + "," + Util.th(pcDeltaWords);
        S32xMemAccessDelay.addReadCpuDelay(block.fetchMemAccessDelay);
        int res = block.prefetchWords[pcDeltaWords];
        this.cacheOnFetch(pc, res, cpu);
        return res;
    }

    @Override
    public void dataWrite(BufferUtil.CpuDeviceAccess cpuWrite, int addr, int val, Size size) {
        if (Sh2Debug.pcAreaMaskMap[addr >>> 24] == 0) {
            return;
        }
        if (addr >= 0 && addr < 256) {
            return;
        }
        this.invalidateMemoryRegion(addr, cpuWrite, addr + size.getByteSize() - 1, val);
    }

    public static void checkPoller(BufferUtil.CpuDeviceAccess cpuWrite, S32xDict.S32xRegType type, int addr, int val, Size size) {
        Sh2Prefetch.checkPoller(cpuWrite, PollSysEventManager.SysEvent.valueOf(type.name()), addr, val, size);
    }

    public static void checkPollersVdp(S32xDict.S32xRegType type, int addr, int val, Size size) {
        Sh2Prefetch.checkPoller(null, PollSysEventManager.SysEvent.valueOf(type.name()), addr, val, size);
    }

    public static void checkPoller(BufferUtil.CpuDeviceAccess cpuWrite, PollSysEventManager.SysEvent type, int addr, int val, Size size) {
        Sh2DrcBlockOptimizer.PollerCtx c;
        int res = PollSysEventManager.instance.anyPollerActive();
        if (res == 0) {
            return;
        }
        if ((res & 1) > 0 && (c = PollSysEventManager.instance.getPoller(BufferUtil.CpuDeviceAccess.MASTER)).isPollingActive() && type == c.event) {
            Sh2Prefetch.checkPollerInternal(c, cpuWrite, type, addr, val, size);
        }
        if ((res & 2) > 0 && (c = PollSysEventManager.instance.getPoller(BufferUtil.CpuDeviceAccess.SLAVE)).isPollingActive() && type == c.event) {
            Sh2Prefetch.checkPollerInternal(c, cpuWrite, type, addr, val, size);
        }
    }

    private static void checkPollerInternal(Sh2DrcBlockOptimizer.PollerCtx c, BufferUtil.CpuDeviceAccess cpuWrite, PollSysEventManager.SysEvent type, int addr, int val, Size size) {
        Sh2DrcBlockOptimizer.BlockPollData bpd = c.blockPollData;
        if (Sh2Prefetch.rangeIntersect(bpd.memLoadTarget & 0xFFFFFFF, bpd.memLoadTargetEnd & 0xFFFFFFF, addr &= 0xFFFFFFF, addr + size.getByteSize() - 1)) {
            boolean skipVdp;
            boolean bl = skipVdp = type == PollSysEventManager.SysEvent.VDP && c.pollValue == PollSysEventManager.readPollValue(c);
            if (!skipVdp) {
                PollSysEventManager.instance.fireSysEvent(c.cpu, type);
            }
        }
    }

    private void invalidateMemoryRegion(int addr, BufferUtil.CpuDeviceAccess blockOwner, int wend, int val) {
        boolean ignore;
        boolean bl = ignore = addr >>> 24 > 192;
        if (ignore) {
            return;
        }
        BufferUtil.CpuDeviceAccess otherCpu = BufferUtil.CpuDeviceAccess.cdaValues[blockOwner.ordinal() + 1 & 1];
        boolean isWriteThrough = addr >>> 28 == 2;
        int addrEven = addr & 0xFFFFFFFE;
        for (int i = addrEven + 2; i > addrEven - Sh2Block.SH2_DRC_MAX_BLOCK_LEN_BYTES; i -= 2) {
            Sh2Helper.Sh2PcInfoWrapper piw = Sh2Helper.getOrDefault(i, blockOwner);
            assert (piw != null);
            if (!piw.block.isValid()) continue;
            Sh2Block b = piw.block;
            int bend = b.prefetchPc + (b.prefetchLenWords - 1 << 1);
            if (!Sh2Prefetch.rangeIntersect(b.prefetchPc, bend, addr, wend)) continue;
            this.invalidateMemoryLocationForCpu(blockOwner, piw, addr, i, val);
            if (!isWriteThrough) continue;
            this.invalidateMemoryLocationForCpu(otherCpu, addr, i, val);
        }
    }

    private void invalidateMemoryLocationForCpu(BufferUtil.CpuDeviceAccess cpu, Sh2Helper.Sh2PcInfoWrapper piw, int addr, int i, int val) {
        boolean isCpuCacheOff;
        if (piw.block.isValid()) {
            this.invalidateWrapper(addr, piw, false, val);
        }
        boolean bl = isCpuCacheOff = this.cache[cpu.ordinal()].getCacheContext().cacheEn == 0;
        if (isCpuCacheOff) {
            LOG.error("Check!");
            piw = Sh2Helper.getOrDefault(i & 0xFFFFFFF, cpu);
            if (piw.block.isValid()) {
                this.invalidateWrapper(addr, piw, false, val);
            }
        }
    }

    private void invalidateMemoryLocationForCpu(BufferUtil.CpuDeviceAccess cpu, int addr, int i, int val) {
        this.invalidateMemoryLocationForCpu(cpu, Sh2Helper.getOrDefault(i, cpu), addr, i, val);
    }

    public static boolean rangeIntersect(int r1start, int r1end, int r2start, int r2end) {
        return (r1start & 0xFFFFFFF) <= (r2end & 0xFFFFFFF) && (r1end & 0xFFFFFFF) >= (r2start & 0xFFFFFFF);
    }

    private void invalidateWrapperFromCache(int addr, Sh2Helper.Sh2PcInfoWrapper pcInfoWrapper) {
        this.invalidateWrapper(addr, pcInfoWrapper, true, -1);
    }

    private void invalidateWrapper(int addr, Sh2Helper.Sh2PcInfoWrapper pcInfoWrapper, boolean cacheOnly, int val) {
        assert (pcInfoWrapper != Sh2Helper.SH2_NOT_VISITED);
        if (cacheOnly && !pcInfoWrapper.block.isCacheFetch()) {
            return;
        }
        Sh2Block block = pcInfoWrapper.block;
        assert (block != Sh2Block.INVALID_BLOCK);
        this.invalidateBlock(pcInfoWrapper);
    }

    private void invalidateBlock(Sh2Helper.Sh2PcInfoWrapper piw) {
        Sh2Block b = piw.block;
        assert (b.getCpu() != null);
        piw.addToKnownBlocks(b);
        piw.invalidateBlock();
    }

    private void cacheOnFetch(int pc, int expOpcode, BufferUtil.CpuDeviceAccess cpu) {
        boolean isCache;
        boolean bl = isCache = pc >>> 28 == 0;
        if (isCache && this.cache[cpu.ordinal()].getCacheContext().cacheEn > 0) {
            int cached = this.cache[cpu.ordinal()].cacheMemoryRead(pc, Size.WORD);
            assert ((cached & 0xFFFF) == expOpcode) : Util.th(pc) + "," + Util.th(expOpcode) + "," + Util.th(cached);
        }
    }

    @Override
    public void invalidateCachePrefetch(Sh2Cache.CacheInvalidateContext ctx) {
        int addrEven;
        boolean ignore;
        int addr = ctx.prevCacheAddr;
        if (addr >= 0 && addr < 256) {
            return;
        }
        boolean bl = ignore = addr >>> 24 > 192;
        if (ignore) {
            return;
        }
        for (int i = addrEven = ctx.prevCacheAddr + 16; i > addr - Sh2Block.SH2_DRC_MAX_BLOCK_LEN_BYTES; i -= 2) {
            Sh2Helper.Sh2PcInfoWrapper piw = Sh2Helper.getOrDefault(i, ctx.cpu);
            assert (piw != null);
            if (!piw.block.isValid()) continue;
            this.invalidateWrapper(i, piw, true, -1);
        }
    }

    @Override
    public void newFrame() {
    }

    public static class Sh2DrcContext {
        public BufferUtil.CpuDeviceAccess cpu;
        public Sh2 sh2;
        public Sh2Context sh2Ctx;
        public Sh2Bus memory;
    }

    public static class BytecodeContext {
        public Sh2DrcContext drcCtx;
        public String classDesc;
        public LocalVariablesSorter mv;
        public int opcode;
        public int pc;
        public int branchPc;
        public Sh2Instructions.Sh2BaseInstruction sh2Inst;
        public BytecodeContext delaySlotCtx;
        public boolean delaySlot;
    }
}

