/*
 * Decompiled with CFR 0.152.
 */
package s32x.util;

import com.google.common.collect.ObjectArrays;
import java.util.function.BiFunction;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.memory.ReadableByteMemory;
import omegadrive.util.MdRuntimeData;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.util.MemView;
import omegadrive.vdp.util.UpdatableViewer;
import omegadrive.vdp.util.VdpDebugView;

public class S32xMemView
extends MemView {
    public static final MemView.MemViewData[] s32xMemViewData = (MemView.MemViewData[])ObjectArrays.concat((Object[])mdMemViewData, (Object[])S32xMemViewType.values(), MemView.MemViewData.class);

    public static UpdatableViewer createInstance(MdMainBusProvider m, ReadableByteMemory s32x, VdpMemoryInterface vdpMem) {
        return VdpDebugView.DEBUG_VIEWER_ENABLED ? new S32xMemView(m, s32x, vdpMem) : NO_MEMVIEW;
    }

    protected S32xMemView(MdMainBusProvider m, ReadableByteMemory s32x, VdpMemoryInterface vdpMem) {
        super(s32xMemViewData, m, s32x, vdpMem);
    }

    @Override
    protected void doMemoryRead(MemView.MemViewData current, int len, BiFunction<MemView.MemViewData, Integer, Integer> readerFn) {
        int v = MdRuntimeData.getCpuDelayExt();
        if (current == S32xMemViewType.S32X_PALETTE) {
            this.doMemoryRead_WordBE(current, len);
        } else {
            super.doMemoryRead(current, len, readerFn);
        }
        MdRuntimeData.resetCpuDelayExt(v);
    }

    static enum S32xMemViewType implements MemView.MemViewData
    {
        S32X_SDRAM(MemView.MemViewOwner.SH2, 0x26000000, 637796352),
        S32X_FRAMEBUFFER(MemView.MemViewOwner.SH2, 0x24000000, 0x24020000),
        S32X_PALETTE(MemView.MemViewOwner.SH2, 0x20004200, 0x20004400),
        M68K_ROM(MemView.MemViewOwner.M68K, 0x880000, 0x900000),
        M68K_VECTOR_ROM(MemView.MemViewOwner.M68K, 0, 256);

        public final int start;
        public final int end;
        public final MemView.MemViewOwner owner;

        private S32xMemViewType(MemView.MemViewOwner c, int s, int e) {
            this.start = s;
            this.end = e;
            this.owner = c;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public MemView.MemViewOwner getOwner() {
            return this.owner;
        }
    }
}

