/*
 * Decompiled with CFR 0.152.
 */
package s32x.util.blipbuffer;

import omegadrive.util.ArrayEndianUtil;
import omegadrive.util.SoundFilterUtil;
import s32x.util.blipbuffer.BlipBuffer;
import s32x.util.blipbuffer.BlipBufferHelper;
import s32x.util.blipbuffer.BlipBufferIntf;

public final class StereoBlipBuffer
implements BlipBufferIntf {
    private final BlipBuffer[] bufs = new BlipBuffer[2];
    private final String name;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    static int[] preFilter = new int[0];
    static int[] postFilterL = new int[0];
    static int[] postFilterR = new int[0];
    static int prevSampleL;
    static int prevSampleR;

    public StereoBlipBuffer(String name) {
        int i = this.bufs.length;
        while (--i >= 0) {
            this.bufs[i] = new BlipBuffer();
        }
        this.name = name;
    }

    @Override
    public void setSampleRate(int rate, int msec) {
        int i = this.bufs.length;
        while (--i >= 0) {
            this.bufs[i].setSampleRate(rate, msec);
        }
    }

    @Override
    public void setClockRate(int rate) {
        int i = this.bufs.length;
        while (--i >= 0) {
            this.bufs[i].setClockRate(rate);
        }
    }

    @Override
    public int clockRate() {
        assert (this.bufs[0].clockRate() == this.bufs[1].clockRate());
        return this.bufs[0].clockRate();
    }

    @Override
    public int getBufLen() {
        return this.bufs[0].getBufLen();
    }

    @Override
    public int countSamples(int time) {
        return this.bufs[0].countSamples(time);
    }

    @Override
    public void clear() {
        int i = this.bufs.length;
        while (--i >= 0) {
            this.bufs[i].clear();
        }
    }

    @Override
    public void setVolume(double v) {
        int i = this.bufs.length;
        while (--i >= 0) {
            this.bufs[i].setVolume(v);
        }
    }

    public BlipBuffer left() {
        return this.bufs[0];
    }

    public BlipBuffer right() {
        return this.bufs[1];
    }

    @Override
    public void endFrame(int time) {
        int i = this.bufs.length;
        while (--i >= 0) {
            this.bufs[i].endFrame(time);
        }
    }

    @Override
    public int samplesAvail() {
        return this.bufs[0].samplesAvail() << 1;
    }

    @Override
    public void addDelta(int time, int leftDelta, int rightDelta) {
        this.bufs[0].addDelta(time, leftDelta);
        this.bufs[1].addDelta(time, rightDelta);
    }

    @Override
    public int readSamples16bitStereo(byte[] out, int pos, int countMono) {
        if (postFilterL.length < countMono) {
            postFilterL = new int[countMono];
            postFilterR = new int[countMono];
        }
        assert (pos == 0);
        int actualMonoLeft = BlipBufferHelper.readSamples16bitMono(this.left(), postFilterL, pos, countMono);
        int actualMonoRight = BlipBufferHelper.readSamples16bitMono(this.right(), postFilterR, pos, countMono);
        assert (actualMonoRight == actualMonoLeft);
        for (int i = 0; i < countMono; ++i) {
            assert ((short)postFilterL[i] == postFilterL[i]);
            assert ((short)postFilterR[i] == postFilterR[i]);
            ArrayEndianUtil.setSigned16LE((short)postFilterL[i], out, pos);
            ArrayEndianUtil.setSigned16LE((short)postFilterR[i], out, pos + 2);
            pos += 4;
        }
        return actualMonoLeft;
    }

    public int readSamples16bitStereoFilter(byte[] out, int pos, int countMono) {
        if (preFilter.length < countMono) {
            preFilter = new int[countMono];
            postFilterL = new int[countMono];
            postFilterR = new int[countMono];
        }
        assert (pos == 0);
        int actualMonoLeft = BlipBufferHelper.readSamples16bitMono(this.left(), preFilter, pos, countMono);
        prevSampleL = SoundFilterUtil.dcBlockerLpfMono(preFilter, postFilterL, prevSampleL, actualMonoLeft);
        int actualMonoRight = BlipBufferHelper.readSamples16bitMono(this.right(), preFilter, pos, countMono);
        assert (actualMonoRight == actualMonoLeft);
        prevSampleR = SoundFilterUtil.dcBlockerLpfMono(preFilter, postFilterR, prevSampleR, actualMonoRight);
        for (int i = 0; i < countMono; ++i) {
            ArrayEndianUtil.setSigned16LE((short)postFilterL[i], out, pos);
            ArrayEndianUtil.setSigned16LE((short)postFilterR[i], out, pos + 2);
            pos += 4;
        }
        return actualMonoLeft;
    }
}

