/*
 * Decompiled with CFR 0.152.
 */
package s32x.vdp;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Optional;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.util.UpdatableViewer;
import omegadrive.vdp.util.VdpDebugView;
import org.slf4j.Logger;
import s32x.S32XMMREG;
import s32x.dict.S32xDict;
import s32x.dict.S32xMemAccessDelay;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.device.IntControl;
import s32x.sh2.prefetch.Sh2Prefetch;
import s32x.vdp.MarsVdp;
import s32x.vdp.debug.MarsVdpDebugView;

public class MarsVdpImpl
implements MarsVdp {
    private static final Logger LOG = LogHelper.getLogger(MarsVdpImpl.class.getSimpleName());
    private final ByteBuffer colorPalette = ByteBuffer.allocate(512);
    private final ByteBuffer[] dramBanks = new ByteBuffer[2];
    private final ShortBuffer[] frameBuffersWord = new ShortBuffer[2];
    private final ShortBuffer colorPaletteWords = this.colorPalette.asShortBuffer();
    private final short[] fbDataWords = new short[65536];
    private final int[] lineTableWords = new int[256];
    private ByteBuffer vdpRegs;
    private MarsVdpDebugView view;
    private MarsVdpSaveContext ctx;
    private MarsVdp.MarsVdpContext vdpContext;
    private S32XMMREG s32XMMREG;
    private S32XMMREG.RegContext regContext;
    private int[] buffer;
    private static final boolean verbose = false;
    private static final boolean verboseRead = false;
    private static int[] mdStretchH40;

    public static MarsVdp createInstance(MarsVdp.MarsVdpContext vdpContext, ShortBuffer frameBuffer0, ShortBuffer frameBuffer1, ShortBuffer colorPalette) {
        MarsVdpImpl v = (MarsVdpImpl)MarsVdpImpl.createInstance(vdpContext, new S32XMMREG());
        v.colorPaletteWords.put(colorPalette);
        v.frameBuffersWord[0].put(frameBuffer0);
        v.frameBuffersWord[1].put(frameBuffer1);
        return v;
    }

    public static MarsVdp createInstance(MarsVdp.MarsVdpContext vdpContext, S32XMMREG s32XMMREG) {
        MarsVdpSaveContext vsc;
        MarsVdpImpl v = new MarsVdpImpl();
        v.s32XMMREG = s32XMMREG;
        v.regContext = s32XMMREG.regContext;
        v.vdpRegs = v.regContext.vdpRegs;
        v.dramBanks[0] = ByteBuffer.allocate(131072);
        v.dramBanks[1] = ByteBuffer.allocate(131072);
        v.frameBuffersWord[0] = v.dramBanks[0].asShortBuffer();
        v.frameBuffersWord[1] = v.dramBanks[1].asShortBuffer();
        v.view = MarsVdpDebugView.createInstance();
        v.ctx = vsc = new MarsVdpSaveContext();
        vsc.renderContext = new MarsVdp.MarsVdpRenderContext();
        vsc.renderContext.screen = v.buffer;
        vsc.renderContext.vdpContext = v.vdpContext = vdpContext;
        v.updateVideoModeInternal(vdpContext.videoMode);
        Gs32xStateHandler.addDevice(v);
        v.init();
        return v;
    }

    @Override
    public void init() {
        this.writeBufferWord(S32xDict.RegSpecS32x.VDP_BITMAP_MODE, this.ctx.pal * 32768);
        int fbcrVal = (this.vdpContext.vBlankOn ? 1 : 0) * 32768 | this.ctx.pen * 8192;
        BufferUtil.writeBufferRaw(this.regContext.vdpRegs, S32xDict.RegSpecS32x.FBCR.addr, fbcrVal, Size.WORD);
    }

    @Override
    public void write(int address, int value, Size size) {
        if (address >= 16896 && address < 17408) {
            assert (MdRuntimeData.getAccessTypeExt() != BufferUtil.CpuDeviceAccess.Z80);
            switch (size) {
                case WORD: 
                case LONG: {
                    BufferUtil.writeBufferRaw(this.colorPalette, address & 0x1FF, value, size);
                    break;
                }
                default: {
                    LogHelper.logWarnOnce(LOG, "{} write, unable to access colorPalette as {}", new Object[]{MdRuntimeData.getAccessTypeExt(), size});
                }
            }
            S32xMemAccessDelay.addWriteCpuDelay(2);
        } else if (address >= 0x4000000 && address < 0x4020000) {
            if (size == Size.BYTE && value == 0) {
                return;
            }
            BufferUtil.writeBufferRaw(this.dramBanks[this.vdpContext.frameBufferWritable], address & 0x1FFFF, value, size);
            S32xMemAccessDelay.addWriteCpuDelay(1);
        } else if (address >= 0x4020000 && address < 0x4040000) {
            this.writeFrameBufferOver(address, value, size);
            S32xMemAccessDelay.addWriteCpuDelay(1);
        } else {
            LOG.error("{} unhandled write at {}, val: {} {}", new Object[]{MdRuntimeData.getAccessTypeExt(), Util.th(address), Util.th(value), size});
        }
    }

    @Override
    public int read(int address, Size size) {
        int res = 0;
        if (address >= 16896 && address < 17408) {
            assert (MdRuntimeData.getAccessTypeExt() != BufferUtil.CpuDeviceAccess.Z80);
            if (size == Size.WORD) {
                res = BufferUtil.readBuffer(this.colorPalette, address & 0x1FF, size);
            } else {
                LogHelper.logWarnOnce(LOG, "{} read, unable to access colorPalette as {}", new Object[]{MdRuntimeData.getAccessTypeExt(), size});
            }
            S32xMemAccessDelay.addWriteCpuDelay(2);
        } else if (address >= 0x4000000 && address < 0x4020000) {
            res = BufferUtil.readBuffer(this.dramBanks[this.vdpContext.frameBufferWritable], address & 0x1FFFF, size);
            S32xMemAccessDelay.addWriteCpuDelay(1);
        } else if (address >= 0x4020000 && address < 0x4040000) {
            res = BufferUtil.readBuffer(this.dramBanks[this.vdpContext.frameBufferWritable], address & 0x1FFFF, size);
            S32xMemAccessDelay.addWriteCpuDelay(1);
        } else {
            LOG.error("{} unhandled read: {} {}", new Object[]{MdRuntimeData.getAccessTypeExt(), Util.th(address), size});
        }
        return res;
    }

    @Override
    public boolean vdpRegWrite(S32xDict.RegSpecS32x reg32x, int reg, int value, Size size) {
        switch (size) {
            case WORD: 
            case BYTE: {
                return this.handleVdpRegWriteInternal(reg32x, reg, value, size);
            }
            case LONG: {
                S32xDict.RegSpecS32x regSpec2 = S32xDict.getRegSpec(reg32x.regCpuType, reg32x.regSpec.fullAddr + 2);
                boolean res = this.handleVdpRegWriteInternal(reg32x, reg, value >> 16 & 0xFFFF, Size.WORD);
                return res |= this.handleVdpRegWriteInternal(regSpec2, reg + 2, value & 0xFFFF, Size.WORD);
            }
        }
        return false;
    }

    private boolean handleVdpRegWriteInternal(S32xDict.RegSpecS32x regSpec, int reg, int value, Size size) {
        assert (size != Size.LONG) : regSpec;
        if (size == Size.BYTE && (reg & 1) == 0) {
            LOG.warn("{} even byte write: {} {}", new Object[]{regSpec, Util.th(value), size});
            return false;
        }
        boolean regChanged = false;
        switch (regSpec) {
            case VDP_BITMAP_MODE: {
                regChanged = this.handleBitmapModeWrite(reg, value, size);
                break;
            }
            case FBCR: {
                regChanged = this.handleFBCRWrite(reg, value, size);
                break;
            }
            case AFDR: {
                assert (size == Size.WORD);
                this.runAutoFill(value);
                regChanged = true;
                break;
            }
            case SSCR: {
                value &= 1;
            }
            case AFLR: {
                value &= 0xFF;
            }
            default: {
                int res = BufferUtil.readBufferReg(this.regContext, regSpec, reg, size);
                if (res == value) break;
                BufferUtil.writeBufferReg(this.regContext, regSpec, reg, value, size);
                regChanged = true;
            }
        }
        return regChanged;
    }

    private boolean handleBitmapModeWrite(int reg, int value, Size size) {
        int prio;
        int val = this.readWordFromBuffer(S32xDict.RegSpecS32x.VDP_BITMAP_MODE);
        int prevPrio = val >> 7 & 1;
        BufferUtil.writeBufferReg(this.regContext, S32xDict.RegSpecS32x.VDP_BITMAP_MODE, reg, value, size);
        int newVal = this.readWordFromBuffer(S32xDict.RegSpecS32x.VDP_BITMAP_MODE) & 0xFFFF7FBF;
        int v240 = this.ctx.pal == 0 && this.vdpContext.videoMode.isV30() ? 1 : 0;
        newVal = newVal & 0xC3 | this.ctx.pal * 32768 | v240 * 64;
        this.writeBufferWord(S32xDict.RegSpecS32x.VDP_BITMAP_MODE, newVal);
        this.vdpContext.bitmapMode = MarsVdp.BitmapMode.vals[newVal & 3];
        if (MarsVdp.BitmapMode.vals[val & 3] != this.vdpContext.bitmapMode) {
            // empty if block
        }
        if (prevPrio != (prio = newVal >> 7 & 1)) {
            MarsVdp.VdpPriority vdpPriority = this.vdpContext.priority = prio == 0 ? MarsVdp.VdpPriority.MD : MarsVdp.VdpPriority.S32X;
            if (!this.vdpContext.vBlankOn) {
                LogHelper.logWarnOnce(LOG, "Illegal Vdp priority change outside VBlank: {} -> {}", new Object[]{prevPrio == 0 ? "MD" : "32x", this.vdpContext.priority});
            }
        }
        return val != newVal;
    }

    private boolean handleFBCRWrite(int reg, int value, Size size) {
        int val = this.readWordFromBuffer(S32xDict.RegSpecS32x.FBCR);
        BufferUtil.writeBufferRaw(this.regContext.vdpRegs, reg, value, size);
        int val1 = val & 0xE000 | this.readWordFromBuffer(S32xDict.RegSpecS32x.FBCR) & 3;
        int regVal = 0;
        if (this.vdpContext.vBlankOn || this.vdpContext.bitmapMode == MarsVdp.BitmapMode.BLANK) {
            regVal = val & 0xFFFC | val1 & 3;
            this.updateFrameBuffer(regVal);
        } else {
            regVal = val & 0xFFFD | val1 & 2;
        }
        BufferUtil.writeBufferRaw(this.regContext.vdpRegs, S32xDict.RegSpecS32x.FBCR.addr, regVal, Size.WORD);
        this.vdpContext.fsLatch = val1 & 1;
        assert ((regVal & 0x1FFC) == 0);
        return val != regVal;
    }

    private void updateFrameBuffer(int val) {
        this.vdpContext.frameBufferDisplay = val & 1;
        this.vdpContext.frameBufferWritable = this.vdpContext.frameBufferDisplay + 1 & 1;
    }

    private void runAutoFill(int data) {
        this.writeBufferWord(S32xDict.RegSpecS32x.AFDR, data);
        int startAddr = this.readWordFromBuffer(S32xDict.RegSpecS32x.AFSAR);
        int len = this.readWordFromBuffer(S32xDict.RegSpecS32x.AFLR) & 0xFF;
        this.runAutoFillInternal(this.dramBanks[this.vdpContext.frameBufferWritable], startAddr, data, len);
    }

    public void runAutoFillInternal(ByteBuffer buffer, int startAddrWord, int data, int len) {
        int wordAddrFixed = startAddrWord & 0xFF00;
        int wordAddrVariable = startAddrWord & 0xFF;
        int dataWord = data & 0xFFFF;
        int afsarEnd = wordAddrFixed + (len & 0xFF);
        do {
            BufferUtil.writeBufferRaw(buffer, wordAddrFixed + wordAddrVariable << 1, dataWord, Size.WORD);
            wordAddrVariable = wordAddrVariable + 1 & 0xFF;
        } while (--len >= 0);
        assert (len == -1);
        this.writeBufferWord(S32xDict.RegSpecS32x.AFSAR, wordAddrFixed + wordAddrVariable);
        this.vdpRegChange(S32xDict.RegSpecS32x.AFSAR);
    }

    private void setPen(int pen) {
        this.ctx.pen = pen;
        int val = pen << 5 | Util.readBufferByte(this.vdpRegs, S32xDict.RegSpecS32x.FBCR.addr) & 0xDF;
        BufferUtil.writeBufferRaw(this.vdpRegs, S32xDict.RegSpecS32x.FBCR.addr, val, Size.BYTE);
    }

    @Override
    public void setVBlank(boolean vBlankOn) {
        this.vdpContext.vBlankOn = vBlankOn;
        this.setBitFromWord(S32xDict.RegSpecS32x.FBCR, 15, vBlankOn ? 1 : 0);
        if (vBlankOn) {
            this.vdpContext.screenShift = this.readWordFromBuffer(S32xDict.RegSpecS32x.SSCR) & 1;
            this.draw(this.vdpContext);
            int currentFb = this.readWordFromBuffer(S32xDict.RegSpecS32x.FBCR) & 1;
            if (currentFb != this.vdpContext.fsLatch) {
                this.setBitFromWord(S32xDict.RegSpecS32x.FBCR, 0, this.vdpContext.fsLatch);
                this.updateFrameBuffer(this.vdpContext.fsLatch);
            }
        }
        this.setPen(this.vdpContext.hBlankOn || vBlankOn ? 1 : 0);
        this.vdpRegChange(S32xDict.RegSpecS32x.FBCR);
        this.s32XMMREG.interruptControls[0].setIntPending(IntControl.Sh2Interrupt.VINT_12, vBlankOn);
        this.s32XMMREG.interruptControls[1].setIntPending(IntControl.Sh2Interrupt.VINT_12, vBlankOn);
    }

    @Override
    public void setHBlank(boolean hBlankOn, int hen) {
        this.vdpContext.hBlankOn = hBlankOn;
        this.setBitFromWord(S32xDict.RegSpecS32x.FBCR, 14, hBlankOn ? 1 : 0);
        this.setBitFromWord(S32xDict.RegSpecS32x.FBCR, 1, hBlankOn ? 1 : 0);
        boolean hintOn = false;
        if (hBlankOn) {
            if (hen > 0 || !this.vdpContext.vBlankOn) {
                if (--this.vdpContext.hCount < 0) {
                    this.vdpContext.hCount = this.readWordFromBuffer(S32xDict.RegSpecS32x.SH2_HCOUNT_REG) & 0xFF;
                    hintOn = true;
                }
            } else {
                this.vdpContext.hCount = this.readWordFromBuffer(S32xDict.RegSpecS32x.SH2_HCOUNT_REG) & 0xFF;
            }
        }
        this.s32XMMREG.interruptControls[0].setIntPending(IntControl.Sh2Interrupt.HINT_10, hintOn);
        this.s32XMMREG.interruptControls[1].setIntPending(IntControl.Sh2Interrupt.HINT_10, hintOn);
        this.setPen(hBlankOn || this.vdpContext.vBlankOn ? 1 : 0);
        this.vdpRegChange(S32xDict.RegSpecS32x.FBCR);
    }

    private void vdpRegChange(S32xDict.RegSpecS32x reg32x) {
        assert (reg32x.regSpec.regSize == Size.WORD);
        int val = this.readWordFromBuffer(reg32x);
        int addr = 0x20004000 | reg32x.regSpec.fullAddr;
        assert (S32xDict.getRegSpec(S32xDict.S32xRegCpuType.REG_MD, addr) == S32xDict.getRegSpec(S32xDict.S32xRegCpuType.REG_SH2, addr));
        Sh2Prefetch.checkPollersVdp(reg32x.deviceType, addr, val, Size.WORD);
    }

    private void writeBufferWord(S32xDict.RegSpecS32x reg, int value) {
        BufferUtil.writeBufferReg(this.regContext, reg, reg.addr, value, Size.WORD);
    }

    private int readWordFromBuffer(S32xDict.RegSpecS32x reg) {
        return BufferUtil.readWordFromBuffer(this.regContext, reg);
    }

    private void setBitFromWord(S32xDict.RegSpecS32x reg, int pos, int value) {
        BufferUtil.setBit(this.vdpRegs, reg.addr & 0xFF, pos, value, Size.WORD);
    }

    private void writeFrameBufferOver(int address, int value, Size size) {
        if (value == 0) {
            return;
        }
        switch (size) {
            case WORD: {
                this.writeFrameBufferByte(address, value >> 8 & 0xFF);
                this.writeFrameBufferByte(address + 1, value & 0xFF);
                break;
            }
            case BYTE: {
                this.writeFrameBufferByte(address, value);
                break;
            }
            case LONG: {
                this.writeFrameBufferByte(address, value >> 24 & 0xFF);
                this.writeFrameBufferByte(address + 1, value >> 16 & 0xFF);
                this.writeFrameBufferByte(address + 2, value >> 8 & 0xFF);
                this.writeFrameBufferByte(address + 3, value >> 0 & 0xFF);
            }
        }
    }

    private void writeFrameBufferByte(int address, int value) {
        if (value != 0) {
            this.dramBanks[this.vdpContext.frameBufferWritable].put(address & 0x1FFFF, (byte)value);
        }
    }

    @Override
    public void draw(MarsVdp.MarsVdpContext context) {
        switch (context.bitmapMode) {
            case BLANK: {
                this.drawBlank();
                break;
            }
            case PACKED_PX: {
                this.drawPackedPixel(context);
                break;
            }
            case RUN_LEN: {
                this.drawRunLen(context);
                break;
            }
            case DIRECT_COL: {
                this.drawDirectColor(context);
            }
        }
        this.view.update(context, this.buffer);
    }

    private void drawBlank() {
        if (this.ctx.wasBlankScreen) {
            return;
        }
        Arrays.fill(this.buffer, 0, this.buffer.length, this.vdpContext.priority.ordinal());
        this.ctx.wasBlankScreen = true;
    }

    private void drawDirectColor(MarsVdp.MarsVdpContext context) {
        int w = context.videoMode.getDimension().width;
        int h = context.videoMode.getDimension().height;
        ShortBuffer b = this.frameBuffersWord[context.frameBufferDisplay];
        int[] imgData = this.buffer;
        this.populateLineTable(b);
        b.position(0);
        b.get(this.fbDataWords);
        short[] fb = this.fbDataWords;
        for (int row = 0; row < h; ++row) {
            int linePos = this.lineTableWords[row] + context.screenShift;
            int fbBasePos = row * w;
            for (int col = 0; col < w; ++col) {
                if (BufferUtil.assertionsEnabled && fbBasePos + col >= imgData.length) {
                    LOG.warn("row: {}, base: {}, col: {}", new Object[]{row, Util.th(fbBasePos), Util.th(col)});
                    continue;
                }
                imgData[fbBasePos + col] = this.getDirectColorWithPriority(fb[linePos + col] & 0xFFFF);
            }
        }
        this.ctx.wasBlankScreen = false;
    }

    private void drawRunLen(MarsVdp.MarsVdpContext context) {
        int h = context.videoMode.getDimension().height;
        int w = context.videoMode.getDimension().width;
        ShortBuffer b = this.frameBuffersWord[context.frameBufferDisplay];
        int[] imgData = this.buffer;
        this.populateLineTable(b);
        b.position(0);
        b.get(this.fbDataWords);
        for (int row = 0; row < h; ++row) {
            int linePos;
            int col = 0;
            int basePos = row * w;
            int nextWord = linePos = this.lineTableWords[row];
            if (basePos >= imgData.length) break;
            do {
                short rl = this.fbDataWords[nextWord++];
                int dotColorIdx = rl & 0xFF;
                int dotLen = (rl >> 8 & 0xFF) + 1;
                int nextLimit = Math.min(col + dotLen, imgData.length - basePos);
                int color = this.getColorWithPriority(dotColorIdx);
                while (col < nextLimit) {
                    imgData[basePos + col] = color;
                    ++col;
                }
            } while (col < w && nextWord < this.fbDataWords.length);
        }
        this.ctx.wasBlankScreen = false;
    }

    void drawPackedPixel(MarsVdp.MarsVdpContext context) {
        ShortBuffer b = this.frameBuffersWord[context.frameBufferDisplay];
        int[] imgData = this.buffer;
        this.populateLineTable(b);
        b.position(0);
        b.get(this.fbDataWords);
        int h = context.videoMode.getDimension().height;
        int w = context.videoMode.getDimension().width;
        for (int row = 0; row < h; ++row) {
            int linePos = this.lineTableWords[row] + context.screenShift;
            int basePos = row * w;
            int col = 0;
            int wordOffset = 0;
            while (col < w) {
                int palWordIdx1 = this.fbDataWords[linePos + wordOffset] >> 8 & 0xFF;
                int palWordIdx2 = this.fbDataWords[linePos + wordOffset] & 0xFF;
                imgData[basePos + col] = this.getColorWithPriority(palWordIdx1);
                imgData[basePos + col + 1] = this.getColorWithPriority(palWordIdx2);
                col += 2;
                ++wordOffset;
            }
        }
        this.ctx.wasBlankScreen = false;
    }

    @Override
    public int[] doCompositeRendering(VideoMode mdVideoMode, int[] mdData, MarsVdp.MarsVdpRenderContext ctx) {
        int[] out = MarsVdpImpl.doCompositeRenderingExt(mdVideoMode, mdData, ctx);
        this.view.updateFinalImage(out);
        return out;
    }

    public static int[] doCompositeRenderingExt(VideoMode mdVideoMode, int[] mdData, MarsVdp.MarsVdpRenderContext ctx) {
        boolean md_h32;
        int[] marsData = Optional.ofNullable(ctx.screen).orElse(BufferUtil.EMPTY_INT_ARRAY);
        int[] out = mdData;
        boolean bl = md_h32 = ctx.vdpContext.videoMode.isH40() && mdVideoMode.isH32();
        if (md_h32) {
            if (mdStretchH40.length != marsData.length) {
                mdStretchH40 = new int[marsData.length];
            }
            BufferUtil.vidH32StretchToH40(mdVideoMode, mdData, mdStretchH40);
            mdData = mdStretchH40;
        }
        if (mdData.length == marsData.length) {
            boolean prio32x = ctx.vdpContext.priority == MarsVdp.VdpPriority.S32X;
            boolean s32xRegBlank = ctx.vdpContext.bitmapMode == MarsVdp.BitmapMode.BLANK;
            boolean s32xBgBlank = !prio32x && s32xRegBlank;
            boolean s32xFgBlank = prio32x && s32xRegBlank;
            int[] fg = prio32x ? marsData : mdData;
            int[] bg = prio32x ? mdData : marsData;
            for (int i = 0; i < fg.length; ++i) {
                boolean throughBit = (marsData[i] & 1) > 0;
                boolean mdBlanking = (mdData[i] & 1) > 0;
                boolean bgBlanking = prio32x && mdBlanking || s32xBgBlank;
                boolean fgBlanking = !prio32x && mdBlanking || s32xFgBlank;
                fg[i] = fgBlanking && !bgBlanking || throughBit && !bgBlanking ? bg[i] : fg[i];
            }
            out = fg;
        }
        return out;
    }

    private void populateLineTable(ShortBuffer b) {
        b.position(0);
        for (int i = 0; i < this.lineTableWords.length; ++i) {
            this.lineTableWords[i] = b.get() & 0xFFFF;
        }
    }

    private int getColorWithPriority(int palWordIdx) {
        int palValue = this.colorPaletteWords.get(palWordIdx) & 0xFFFF;
        return this.getDirectColorWithPriority(palValue);
    }

    private int getDirectColorWithPriority(int palValue) {
        int prio = palValue >> 15 & 1;
        int color = bgr5toRgb8Mapper[palValue];
        return color & 0xFFFFFFFE | prio;
    }

    public void updateVdpBitmapMode(VideoMode video) {
        this.ctx.pal = video.isPal() ? 0 : 1;
        int v240 = video.isPal() && video.isV30() ? 1 : 0;
        int val = this.readWordFromBuffer(S32xDict.RegSpecS32x.VDP_BITMAP_MODE) & 0xFFFF7FBF;
        this.writeBufferWord(S32xDict.RegSpecS32x.VDP_BITMAP_MODE, val | this.ctx.pal * 32768 | v240 * 64);
    }

    @Override
    public void updateVideoMode(VideoMode v) {
        if (v.equals((Object)this.vdpContext.videoMode)) {
            return;
        }
        if (!v.isH40()) {
            VideoMode prev = v;
            v = VideoMode.getVideoMode(v.getRegion(), true, v.isV30(), prev);
        }
        this.updateVdpBitmapMode(v);
        this.updateVideoModeInternal(v);
        this.vdpContext.videoMode = v;
    }

    private void updateVideoModeInternal(VideoMode videoMode) {
        this.buffer = new int[videoMode.getDimension().width * videoMode.getDimension().height];
        this.ctx.renderContext.screen = this.buffer;
        LOG.info("Updating videoMode, {} -> {}", (Object)this.vdpContext.videoMode, (Object)videoMode);
    }

    @Override
    public MarsVdp.MarsVdpRenderContext getMarsVdpRenderContext() {
        return this.ctx.renderContext;
    }

    @Override
    public void updateDebugView(UpdatableViewer debugView) {
        if (debugView instanceof VdpDebugView) {
            ((VdpDebugView)debugView).setAdditionalPanel(this.view.getPanel());
        }
    }

    @Override
    public void saveContext(ByteBuffer bb) {
        MarsVdp.super.saveContext(bb);
        this.ctx.renderContext.screen = this.buffer;
        this.dramBanks[0].rewind().get(this.ctx.fb0);
        this.dramBanks[1].rewind().get(this.ctx.fb1);
        this.colorPalette.rewind().get(this.ctx.palette);
        bb.put(Util.serializeObject(this.ctx));
    }

    @Override
    public void loadContext(ByteBuffer bb) {
        MarsVdp.super.loadContext(bb);
        Serializable s = Util.deserializeObject(bb);
        assert (s instanceof MarsVdpSaveContext);
        this.ctx = (MarsVdpSaveContext)s;
        this.buffer = this.ctx.renderContext.screen;
        this.vdpContext = this.ctx.renderContext.vdpContext;
        this.dramBanks[0].rewind().put(this.ctx.fb0);
        this.dramBanks[1].rewind().put(this.ctx.fb1);
        this.colorPalette.rewind().put(this.ctx.palette);
    }

    @Override
    public void dumpMarsData() {
        MarsVdp.DebugMarsVdpRenderContext d = new MarsVdp.DebugMarsVdpRenderContext();
        d.renderContext = this.getMarsVdpRenderContext();
        this.frameBuffersWord[0].position(0);
        this.frameBuffersWord[1].position(0);
        d.frameBuffer0 = new short[this.frameBuffersWord[0].capacity()];
        d.frameBuffer1 = new short[this.frameBuffersWord[1].capacity()];
        this.frameBuffersWord[0].get(d.frameBuffer0);
        this.frameBuffersWord[1].get(d.frameBuffer1);
        this.colorPaletteWords.position(0);
        d.palette = new short[this.colorPaletteWords.capacity()];
        this.colorPaletteWords.get(d.palette);
        this.draw(d.renderContext.vdpContext);
        d.renderContext.screen = this.buffer;
        MarsVdp.storeMarsData(d);
    }

    @Override
    public void reset() {
        this.view.reset();
    }

    static {
        MarsVdp.initBgrMapper();
        mdStretchH40 = new int[0];
    }

    private static class MarsVdpSaveContext
    implements Serializable {
        private static final long serialVersionUID = -7332632984301857483L;
        public MarsVdp.MarsVdpRenderContext renderContext;
        private final byte[] fb0 = new byte[131072];
        private final byte[] fb1 = new byte[131072];
        private final byte[] palette = new byte[512];
        private int pal = 1;
        private int pen = 1;
        private boolean wasBlankScreen = false;

        private MarsVdpSaveContext() {
        }
    }
}

