/*
 * Decompiled with CFR 0.152.
 */
package ru.krlvm.swingdpi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingDPI {
    public static final String VERSION = "1.1.6";
    private static boolean scaleFactorSet = false;
    private static float scaleFactor = 1.0f;
    private static final float DEFAULT_SCALE_FACTOR = 1.0f;
    private static boolean scaleApplied = false;
    private static final String[] SUFFIXES_FOR_SCALE = new String[]{"width", "height", "indent", "size", "gap"};
    private static Set<String> BLACKLISTED_DEFAULTS;
    private static Set<String> WHITELISTED_DEFAULTS;

    public static void applyScalingAutomatically() {
        SwingDPI.determineScaleFactor();
        if (scaleFactor != 1.0f) {
            SwingDPI.setScaleApplied(true);
        }
    }

    public static float determineScaleFactor() {
        float resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        if (resolution != 100.0f) {
            SwingDPI.setScaleFactor(resolution / 96.0f);
        }
        return scaleFactor;
    }

    public static void setScaleApplied(boolean apply) {
        SwingDPI.setScaleApplied(apply, true);
    }

    public static void setScaleApplied(boolean apply, boolean scaleExistingFrames) {
        if (apply == scaleApplied) {
            return;
        }
        scaleApplied = apply;
        if (!apply) {
            SwingDPI.setScaleFactor(1.0f);
        }
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        for (Object key : Collections.list(defaults.keys())) {
            if (BLACKLISTED_DEFAULTS == null ? WHITELISTED_DEFAULTS != null && !WHITELISTED_DEFAULTS.contains(key.toString()) : BLACKLISTED_DEFAULTS.contains(key.toString())) continue;
            Object original = defaults.get(key);
            Object newValue = SwingDPI.scale(key, original);
            if (newValue == null || newValue == original) continue;
            defaults.put(key, newValue);
        }
        if (scaleExistingFrames) {
            for (Frame frame : Frame.getFrames()) {
                if (!(frame instanceof JFrame)) {
                    return;
                }
                Dimension dimension = frame.getSize();
                frame.setSize(SwingDPI.scale(dimension));
                for (Component component : ((JFrame)frame).getContentPane().getComponents()) {
                    dimension = component.getSize();
                    Dimension newDimension = SwingDPI.scale(dimension);
                    if (component instanceof JTextField) {
                        component.setPreferredSize(newDimension);
                        continue;
                    }
                    component.setSize(newDimension);
                }
            }
        }
    }

    public static boolean isScaleApplied() {
        return scaleApplied;
    }

    public static void setScaleFactor(float scaleFactor) {
        if (!scaleFactorSet) {
            scaleFactorSet = true;
        }
        SwingDPI.scaleFactor = scaleFactor;
    }

    public static float getScaleFactor() {
        if (!scaleFactorSet) {
            SwingDPI.determineScaleFactor();
        }
        return scaleFactor;
    }

    private static Object scale(Object key, Object original) {
        if (original instanceof Font) {
            if (original instanceof FontUIResource && key.toString().endsWith(".font")) {
                int newSize = (int)((float)Math.round(((Font)original).getSize()) * scaleFactor);
                return new FontUIResource(((Font)original).getName(), ((Font)original).getStyle(), newSize);
            }
            return original;
        }
        if (original instanceof Integer) {
            if (!SwingDPI.endsWithOneOf(key instanceof String ? ((String)key).toLowerCase() : "")) {
                return original;
            }
            return (int)((float)((Integer)original).intValue() * scaleFactor);
        }
        return null;
    }

    public static Dimension scale(Dimension dimension) {
        if (!scaleFactorSet) {
            return dimension;
        }
        dimension.setSize((int)(dimension.getWidth() * (double)scaleFactor), (int)(dimension.getHeight() * (double)scaleFactor));
        return dimension;
    }

    public static Dimension getScaledDimension(Dimension dimension) {
        if (!scaleFactorSet) {
            return dimension;
        }
        return new Dimension((int)(dimension.getWidth() * (double)scaleFactor), (int)(dimension.getHeight() * (double)scaleFactor));
    }

    public static Dimension scale(int width, int height) {
        return SwingDPI.scale(new Dimension(width, height));
    }

    public static int scale(int i) {
        if (!scaleFactorSet) {
            return i;
        }
        return (int)((float)i * scaleFactor);
    }

    private static boolean endsWithOneOf(String text) {
        for (String suffix : SUFFIXES_FOR_SCALE) {
            if (!suffix.endsWith(text)) continue;
            return true;
        }
        return false;
    }

    public static Dimension scaleFrame(Dimension dimension) {
        if (!scaleFactorSet) {
            return dimension;
        }
        return SwingDPI.scale((int)((double)dimension.width - (double)dimension.width * 0.2), (int)((double)dimension.height - (double)dimension.height * 0.15));
    }

    public static void scaleFont(Component component) {
        Font font = component.getFont();
        float size = (float)font.getSize() * scaleFactor;
        component.setFont(font.deriveFont(size));
    }

    public static void excludeDefaults(Collection<String> toExclude) {
        if (WHITELISTED_DEFAULTS != null) {
            throw new IllegalStateException("UI Defaults is in whitelist mode");
        }
        if (BLACKLISTED_DEFAULTS == null) {
            BLACKLISTED_DEFAULTS = new HashSet<String>();
        }
        BLACKLISTED_DEFAULTS.addAll(toExclude);
    }

    public static void excludeDefaults(String ... toExclude) {
        SwingDPI.excludeDefaults(Arrays.asList(toExclude));
    }

    public static void whitelistDefaults(Collection<String> toWhitelist) {
        if (BLACKLISTED_DEFAULTS != null) {
            throw new IllegalStateException("UI Defaults is in blacklist mode");
        }
        if (WHITELISTED_DEFAULTS == null) {
            WHITELISTED_DEFAULTS = new HashSet<String>();
        }
        WHITELISTED_DEFAULTS.addAll(toWhitelist);
    }

    public static void whitelistDefaults(String ... toWhitelist) {
        SwingDPI.whitelistDefaults(Arrays.asList(toWhitelist));
    }
}

