/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.GameboyOptions;
import eu.rekawek.coffeegb.controller.Controller;
import eu.rekawek.coffeegb.controller.Joypad;
import eu.rekawek.coffeegb.cpu.Cpu;
import eu.rekawek.coffeegb.cpu.InterruptManager;
import eu.rekawek.coffeegb.cpu.Registers;
import eu.rekawek.coffeegb.cpu.SpeedMode;
import eu.rekawek.coffeegb.debug.IConsole;
import eu.rekawek.coffeegb.gpu.Display;
import eu.rekawek.coffeegb.gpu.Gpu;
import eu.rekawek.coffeegb.memory.Dma;
import eu.rekawek.coffeegb.memory.GbcRam;
import eu.rekawek.coffeegb.memory.Hdma;
import eu.rekawek.coffeegb.memory.Mmu;
import eu.rekawek.coffeegb.memory.Ram;
import eu.rekawek.coffeegb.memory.ShadowAddressSpace;
import eu.rekawek.coffeegb.memory.UndocumentedGbcRegisters;
import eu.rekawek.coffeegb.memory.cart.Cartridge;
import eu.rekawek.coffeegb.serial.SerialEndpoint;
import eu.rekawek.coffeegb.serial.SerialPort;
import eu.rekawek.coffeegb.sound.Sound;
import eu.rekawek.coffeegb.sound.SoundOutput;
import eu.rekawek.coffeegb.timer.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Gameboy
implements Runnable {
    public static final int TICKS_PER_SEC = 0x400000;
    private final InterruptManager interruptManager;
    private final Gpu gpu;
    private final Mmu mmu;
    private final Cpu cpu;
    private final Timer timer;
    private final Dma dma;
    private final Hdma hdma;
    private final Display display;
    private final Sound sound;
    private final SerialPort serialPort;
    private final boolean gbc;
    private final SpeedMode speedMode;
    private final Optional<IConsole> console;
    private volatile boolean doStop;
    private final List<Runnable> tickListeners = new ArrayList<Runnable>();

    public Gameboy(GameboyOptions options, Cartridge rom, Display display, Controller controller, SoundOutput soundOutput, SerialEndpoint serialEndpoint) {
        this(options, rom, display, controller, soundOutput, serialEndpoint, Optional.empty());
    }

    public Gameboy(GameboyOptions options, Cartridge rom, Display display, Controller controller, SoundOutput soundOutput, SerialEndpoint serialEndpoint, Optional<IConsole> console) {
        this.display = display;
        this.gbc = rom.isGbc();
        this.speedMode = new SpeedMode();
        this.interruptManager = new InterruptManager(this.gbc);
        this.timer = new Timer(this.interruptManager, this.speedMode);
        this.mmu = new Mmu();
        Ram oamRam = new Ram(65024, 160);
        this.dma = new Dma(this.mmu, oamRam, this.speedMode);
        this.gpu = new Gpu(display, this.interruptManager, this.dma, oamRam, this.gbc);
        this.hdma = new Hdma(this.mmu);
        this.sound = new Sound(soundOutput, this.gbc);
        this.serialPort = new SerialPort(this.interruptManager, serialEndpoint, this.speedMode);
        this.mmu.addAddressSpace(rom);
        this.mmu.addAddressSpace(this.gpu);
        this.mmu.addAddressSpace(new Joypad(this.interruptManager, controller));
        this.mmu.addAddressSpace(this.interruptManager);
        this.mmu.addAddressSpace(this.serialPort);
        this.mmu.addAddressSpace(this.timer);
        this.mmu.addAddressSpace(this.dma);
        this.mmu.addAddressSpace(this.sound);
        this.mmu.addAddressSpace(new Ram(49152, 4096));
        if (this.gbc) {
            this.mmu.addAddressSpace(this.speedMode);
            this.mmu.addAddressSpace(this.hdma);
            this.mmu.addAddressSpace(new GbcRam());
            this.mmu.addAddressSpace(new UndocumentedGbcRegisters());
        } else {
            this.mmu.addAddressSpace(new Ram(53248, 4096));
        }
        this.mmu.addAddressSpace(new Ram(65408, 127));
        this.mmu.addAddressSpace(new ShadowAddressSpace(this.mmu, 57344, 49152, 7680));
        this.cpu = new Cpu(this.mmu, this.interruptManager, this.gpu, display, this.speedMode);
        this.interruptManager.disableInterrupts(false);
        if (!options.isUsingBootstrap()) {
            this.initRegs();
        }
        this.console = console;
    }

    private void initRegs() {
        Registers r = this.cpu.getRegisters();
        r.setAF(432);
        if (this.gbc) {
            r.setA(17);
        }
        r.setBC(19);
        r.setDE(216);
        r.setHL(333);
        r.setSP(65534);
        r.setPC(256);
    }

    @Override
    public void run() {
        boolean requestedScreenRefresh = false;
        boolean lcdDisabled = false;
        this.doStop = false;
        while (!this.doStop) {
            Gpu.Mode newMode = this.tick();
            if (newMode != null) {
                this.hdma.onGpuUpdate(newMode);
            }
            if (!lcdDisabled && !this.gpu.isLcdEnabled()) {
                lcdDisabled = true;
                this.display.requestRefresh();
                this.hdma.onLcdSwitch(false);
            } else if (newMode == Gpu.Mode.VBlank) {
                requestedScreenRefresh = true;
                this.display.requestRefresh();
            }
            if (lcdDisabled && this.gpu.isLcdEnabled()) {
                lcdDisabled = false;
                this.display.waitForRefresh();
                this.hdma.onLcdSwitch(true);
            } else if (requestedScreenRefresh && newMode == Gpu.Mode.OamSearch) {
                requestedScreenRefresh = false;
                this.display.waitForRefresh();
            }
            this.console.ifPresent(IConsole::tick);
            this.tickListeners.forEach(Runnable::run);
        }
    }

    public void stop() {
        this.doStop = true;
    }

    public Gpu.Mode tick() {
        this.timer.tick();
        if (this.hdma.isTransferInProgress()) {
            this.hdma.tick();
        } else {
            this.cpu.tick();
        }
        this.dma.tick();
        this.sound.tick();
        this.serialPort.tick();
        return this.gpu.tick();
    }

    public AddressSpace getAddressSpace() {
        return this.mmu;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public SpeedMode getSpeedMode() {
        return this.speedMode;
    }

    public Gpu getGpu() {
        return this.gpu;
    }

    public void registerTickListener(Runnable tickListener) {
        this.tickListeners.add(tickListener);
    }

    public void unregisterTickListener(Runnable tickListener) {
        this.tickListeners.remove(tickListener);
    }

    public Sound getSound() {
        return this.sound;
    }
}

