/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.controller;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.controller.ButtonListener;
import eu.rekawek.coffeegb.controller.Controller;
import eu.rekawek.coffeegb.cpu.InterruptManager;
import java.util.HashSet;
import java.util.Set;

public class Joypad
implements AddressSpace {
    private Set<ButtonListener.Button> buttons = new HashSet<ButtonListener.Button>();
    private int p1;

    public Joypad(final InterruptManager interruptManager, Controller controller) {
        controller.setButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(ButtonListener.Button button) {
                interruptManager.requestInterrupt(InterruptManager.InterruptType.P10_13);
                Joypad.this.buttons.add(button);
            }

            @Override
            public void onButtonRelease(ButtonListener.Button button) {
                Joypad.this.buttons.remove((Object)button);
            }
        });
    }

    @Override
    public boolean accepts(int address) {
        return address == 65280;
    }

    @Override
    public void setByte(int address, int value) {
        this.p1 = value & 0x30;
    }

    @Override
    public int getByte(int address) {
        int result = this.p1 | 0xCF;
        for (ButtonListener.Button b : this.buttons) {
            if ((b.getLine() & this.p1) != 0) continue;
            result &= 0xFF & ~b.getMask();
        }
        return result;
    }
}

