/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu.opcode;

import eu.rekawek.coffeegb.cpu.op.Op;
import eu.rekawek.coffeegb.cpu.opcode.OpcodeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Opcode {
    private final int opcode;
    private final String label;
    private final List<Op> ops;
    private final int length;

    Opcode(OpcodeBuilder builder) {
        this.opcode = builder.getOpcode();
        this.label = builder.getLabel();
        this.ops = Collections.unmodifiableList(new ArrayList<Op>(builder.getOps()));
        this.length = this.ops.stream().mapToInt(o -> o.operandLength()).max().orElse(0);
    }

    public int getOperandLength() {
        return this.length;
    }

    public String toString() {
        return String.format("%02x %s", this.opcode, this.label);
    }

    public List<Op> getOps() {
        return this.ops;
    }

    public String getLabel() {
        return this.label;
    }

    public int getOpcode() {
        return this.opcode;
    }
}

