/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.debug;

import java.util.Optional;
import java.util.Set;

public class CommandArgument {
    private final String name;
    private final boolean required;
    private final Optional<Set<String>> allowedValues;

    public CommandArgument(String name, boolean required) {
        this.name = name;
        this.required = required;
        this.allowedValues = Optional.empty();
    }

    public CommandArgument(String name, boolean required, Set<String> allowedValues) {
        this.name = name;
        this.required = required;
        this.allowedValues = Optional.of(allowedValues);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Optional<Set<String>> getAllowedValues() {
        return this.allowedValues;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.required) {
            builder.append('[');
        }
        if (this.allowedValues.isPresent()) {
            builder.append('{');
            builder.append(String.join((CharSequence)",", (Iterable<? extends CharSequence>)this.allowedValues.get()));
            builder.append('}');
        } else {
            builder.append(this.name.toUpperCase());
        }
        if (!this.required) {
            builder.append(']');
        }
        return builder.toString();
    }
}

