/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.debug;

import eu.rekawek.coffeegb.Gameboy;
import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.debug.Command;
import eu.rekawek.coffeegb.debug.CommandPattern;
import eu.rekawek.coffeegb.debug.command.Quit;
import eu.rekawek.coffeegb.debug.command.ShowHelp;
import eu.rekawek.coffeegb.debug.command.apu.Channel;
import eu.rekawek.coffeegb.debug.command.cpu.ShowOpcode;
import eu.rekawek.coffeegb.debug.command.cpu.ShowOpcodes;
import eu.rekawek.coffeegb.debug.command.ppu.ShowBackground;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.slf4j.Logger;

public class Console
implements eu.rekawek.coffeegb.debug.IConsole {
    private static final Logger LOG = LoggerHelper.getLogger(Console.class);
    private final Deque<CommandExecution> commandBuffer = new ArrayDeque<CommandExecution>();
    private final Semaphore semaphore = new Semaphore(0);
    private volatile boolean isStarted;
    private List<Command> commands;

    @Override
    public void init(Gameboy gameboy) {
        this.commands = new ArrayList<Command>();
        this.commands.add(new ShowHelp(this.commands));
        this.commands.add(new ShowOpcode());
        this.commands.add(new ShowOpcodes());
        this.commands.add(new Quit());
        this.commands.add(new ShowBackground(gameboy, ShowBackground.Type.WINDOW));
        this.commands.add(new ShowBackground(gameboy, ShowBackground.Type.BACKGROUND));
        this.commands.add(new Channel(gameboy.getSound()));
        Collections.sort(this.commands, Comparator.comparing(c -> c.getPattern().getCommandNames().get(0)));
    }

    @Override
    public void run() {
        this.isStarted = true;
        LineReader lineReader = LineReaderBuilder.builder().build();
        while (true) {
            try {
                block5: while (true) {
                    String line = lineReader.readLine("coffee-gb> ");
                    Iterator<Command> iterator = this.commands.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        Command cmd = iterator.next();
                        if (!cmd.getPattern().matches(line)) continue;
                        CommandPattern.ParsedCommandLine parsed = cmd.getPattern().parse(line);
                        this.commandBuffer.add(new CommandExecution(cmd, parsed));
                        this.semaphore.acquire();
                    }
                    break;
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                continue;
            }
            catch (UserInterruptException e) {
                System.exit(0);
                continue;
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted", (Throwable)e);
                return;
            }
            break;
        }
    }

    @Override
    public void tick() {
        if (!this.isStarted) {
            return;
        }
        while (!this.commandBuffer.isEmpty()) {
            this.commandBuffer.poll().run();
            this.semaphore.release();
        }
    }

    private class CommandExecution {
        private final Command command;
        private final CommandPattern.ParsedCommandLine arguments;

        public CommandExecution(Command command, CommandPattern.ParsedCommandLine arguments) {
            this.command = command;
            this.arguments = arguments;
        }

        public void run() {
            this.command.run(this.arguments);
        }
    }

    public static interface IConsole
    extends Runnable {
        public void init(Gameboy var1);

        public void tick();
    }
}

