/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.debug.command.ppu;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.Gameboy;
import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.cpu.BitUtils;
import eu.rekawek.coffeegb.debug.Command;
import eu.rekawek.coffeegb.debug.CommandPattern;
import eu.rekawek.coffeegb.gpu.Fetcher;
import eu.rekawek.coffeegb.gpu.Gpu;
import eu.rekawek.coffeegb.gpu.GpuRegister;
import eu.rekawek.coffeegb.gpu.Lcdc;
import eu.rekawek.coffeegb.gpu.TileAttributes;
import eu.rekawek.coffeegb.gui.SwingDisplay;
import eu.rekawek.coffeegb.memory.MemoryRegisters;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;

public class ShowBackground
implements Command {
    private static final Logger LOG = LoggerHelper.getLogger(ShowBackground.class);
    private static final CommandPattern PATTERN_BACKGROUND = CommandPattern.Builder.create("ppu show background").withDescription("display the background tiles").build();
    private static final CommandPattern PATTERN_WINDOW = CommandPattern.Builder.create("ppu show window").withDescription("display the window tiles").build();
    private final Gameboy gameboy;
    private volatile boolean windowPresent;
    private final Type type;

    public ShowBackground(Gameboy gameboy, Type type) {
        this.gameboy = gameboy;
        this.type = type;
    }

    @Override
    public CommandPattern getPattern() {
        return this.type == Type.WINDOW ? PATTERN_WINDOW : PATTERN_BACKGROUND;
    }

    @Override
    public void run(CommandPattern.ParsedCommandLine commandLine) {
        if (this.windowPresent) {
            System.out.println("Window already present");
            return;
        }
        SwingUtilities.invokeLater(() -> {
            final BackgroundTiles panel = new BackgroundTiles(this.gameboy.getGpu());
            panel.setPreferredSize(new Dimension(544, 544));
            new Thread(panel).start();
            final Runnable panelTick = panel::tick;
            JFrame mainWindow = new JFrame(this.type == Type.BACKGROUND ? "Background tiles" : "Window tiles");
            mainWindow.setDefaultCloseOperation(2);
            mainWindow.setLocationRelativeTo(null);
            mainWindow.addWindowListener(new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    ShowBackground.this.gameboy.unregisterTickListener(panelTick);
                    panel.doStop = true;
                    BackgroundTiles backgroundTiles = panel;
                    synchronized (backgroundTiles) {
                        panel.notify();
                    }
                    ShowBackground.this.windowPresent = false;
                }
            });
            mainWindow.setContentPane(panel);
            mainWindow.setResizable(false);
            mainWindow.setVisible(true);
            mainWindow.pack();
            this.gameboy.registerTickListener(panelTick);
            this.windowPresent = true;
        });
    }

    public class BackgroundTiles
    extends JPanel
    implements Runnable {
        private boolean doRefresh;
        private boolean doStop;
        private final BufferedImage img;
        private final GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        private final Gpu gpu;
        private Gpu.Mode lastMode;

        public BackgroundTiles(Gpu gpu) {
            this.img = this.gfxConfig.createCompatibleImage(544, 544);
            this.gpu = gpu;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.drawImage(this.img, 0, 0, 544, 544, null);
            g2d.dispose();
        }

        private void drawBackground() {
            Graphics2D g2d = this.img.createGraphics();
            g2d.clearRect(0, 0, 544, 544);
            Lcdc lcdc = this.gpu.getLcdc();
            AddressSpace videoRam0 = this.gpu.getVideoRam0();
            AddressSpace videoRam1 = this.gpu.getVideoRam1();
            MemoryRegisters reg = this.gpu.getRegisters();
            int tileMap = ShowBackground.this.type == Type.BACKGROUND ? lcdc.getBgTileMapDisplay() : lcdc.getWindowTileMapDisplay();
            int tileData = lcdc.getBgWindowTileData();
            int dmgPalette = reg.get(GpuRegister.BGP);
            int[][] tile = new int[8][8];
            for (int x = 0; x < 32; ++x) {
                for (int y = 0; y < 32; ++y) {
                    int i;
                    int tileId = videoRam0.getByte(tileMap + x + 32 * y);
                    TileAttributes attr = videoRam1 == null ? TileAttributes.valueOf(0) : TileAttributes.valueOf(videoRam1.getByte(tileMap + x + 32 * y));
                    int tileAddress = lcdc.isBgWindowTileDataSigned() ? tileData + BitUtils.toSigned(tileId) * 16 : tileData + tileId * 16;
                    for (i = 0; i < 16; i += 2) {
                        AddressSpace bank = attr.getBank() == 0 ? videoRam0 : videoRam1;
                        int b1 = bank.getByte(tileAddress + i);
                        int b2 = bank.getByte(tileAddress + i + 1);
                        Fetcher.zip(b1, b2, attr.isXflip(), tile[i / 2]);
                    }
                    if (attr.isYflip()) {
                        for (i = 0; i < 8; ++i) {
                            int[] tmp = tile[i];
                            tile[i] = tile[7 - i];
                            tile[7 - i] = tmp;
                        }
                    }
                    int[] palette = new int[4];
                    if (this.gpu.isGbc()) {
                        int[] gbcPalette = this.gpu.getBgPalette().getPalette(attr.getColorPaletteIndex());
                        for (int i2 = 0; i2 < palette.length; ++i2) {
                            palette[i2] = SwingDisplay.translateGbcRgb(gbcPalette[i2]);
                        }
                    } else {
                        for (int i3 = 0; i3 < palette.length; ++i3) {
                            palette[i3] = SwingDisplay.COLORS[3 & dmgPalette >> i3 * 2];
                        }
                    }
                    this.drawTile(g2d, tile, palette, x, y);
                }
            }
            if (ShowBackground.this.type == Type.BACKGROUND) {
                this.drawScrollFrame(g2d, reg.get(GpuRegister.SCX), reg.get(GpuRegister.SCY));
            }
        }

        private void drawTile(Graphics2D g2d, int[][] tile, int[] palette, int x, int y) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    g2d.setColor(new Color(palette[tile[j][i]]));
                    g2d.fillRect(x * 17 + i * 2, y * 17 + j * 2, 2, 2);
                }
            }
        }

        private void drawScrollFrame(Graphics2D g2d, int scx, int scy) {
            g2d.setColor(Color.RED);
            this.drawHorizontalLine(g2d, scx, scy);
            this.drawVerticalLine(g2d, scx, scy);
            this.drawVerticalLine(g2d, (scx + 160) % 256, scy);
            this.drawHorizontalLine(g2d, scx, (scy + 144) % 256);
        }

        private void drawHorizontalLine(Graphics2D g2d, int x1, int y1) {
            if (x1 + 160 < 256) {
                this.drawLine(g2d, x1, y1, x1 + 160, y1);
            } else {
                this.drawLine(g2d, x1, y1, 255, y1);
                this.drawLine(g2d, 0, y1, x1 + 160 - 256, y1);
            }
        }

        private void drawVerticalLine(Graphics2D g2d, int x1, int y1) {
            if (y1 + 144 < 256) {
                this.drawLine(g2d, x1, y1, x1, y1 + 144);
            } else {
                this.drawLine(g2d, x1, y1, x1, 255);
                this.drawLine(g2d, x1, 0, x1, y1 + 144 - 256);
            }
        }

        private void drawLine(Graphics2D g2d, int x1, int y1, int x2, int y2) {
            g2d.drawLine(this.translate(x1), this.translate(y1), this.translate(x2), this.translate(y2));
            if (x1 == x2) {
                g2d.drawLine(this.translate(x1) + 1, this.translate(y1), this.translate(x2) + 1, this.translate(y2));
            }
            if (y1 == y2) {
                g2d.drawLine(this.translate(x1), this.translate(y1) + 1, this.translate(x2), this.translate(y2) + 1);
            }
        }

        private int translate(int point) {
            return point / 8 * 17 + point % 8 * 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.doStop) {
                BackgroundTiles backgroundTiles = this;
                synchronized (backgroundTiles) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.error("Can't refresh background window", (Throwable)e);
                        return;
                    }
                }
                if (!this.doRefresh) continue;
                this.doRefresh = false;
                this.validate();
                this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tick() {
            Gpu.Mode currentMode = this.gpu.getMode();
            if (currentMode != this.lastMode && currentMode == Gpu.Mode.VBlank) {
                this.drawBackground();
                this.doRefresh = true;
                BackgroundTiles backgroundTiles = this;
                synchronized (backgroundTiles) {
                    this.notify();
                }
            }
            this.lastMode = currentMode;
        }
    }

    public static enum Type {
        WINDOW,
        BACKGROUND;

    }
}

