/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu;

import eu.rekawek.coffeegb.AddressSpace;

public class ColorPalette
implements AddressSpace {
    private final int indexAddr;
    private final int dataAddr;
    private int[][] palettes = new int[8][4];
    private int index;
    private boolean autoIncrement;

    public ColorPalette(int offset) {
        this.indexAddr = offset;
        this.dataAddr = offset + 1;
    }

    @Override
    public boolean accepts(int address) {
        return address == this.indexAddr || address == this.dataAddr;
    }

    @Override
    public void setByte(int address, int value) {
        if (address == this.indexAddr) {
            this.index = value & 0x3F;
            this.autoIncrement = (value & 0x80) != 0;
        } else if (address == this.dataAddr) {
            int color = this.palettes[this.index / 8][this.index % 8 / 2];
            color = this.index % 2 == 0 ? color & 0xFF00 | value : color & 0xFF | value << 8;
            this.palettes[this.index / 8][this.index % 8 / 2] = color;
            if (this.autoIncrement) {
                this.index = this.index + 1 & 0x3F;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getByte(int address) {
        if (address == this.indexAddr) {
            return this.index | (this.autoIncrement ? 128 : 0) | 0x40;
        }
        if (address == this.dataAddr) {
            int color = this.palettes[this.index / 8][this.index % 8 / 2];
            if (this.index % 2 == 0) {
                return color & 0xFF;
            }
            return color >> 8 & 0xFF;
        }
        throw new IllegalArgumentException();
    }

    public int[] getPalette(int index) {
        return this.palettes[index];
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            int[] palette;
            b.append(i).append(": ");
            for (int c : palette = this.getPalette(i)) {
                b.append(String.format("%04X", c)).append(' ');
            }
            b.setCharAt(b.length() - 1, '\n');
        }
        return b.toString();
    }

    public void fillWithFF() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.palettes[i][j] = Short.MAX_VALUE;
            }
        }
    }
}

