/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu;

import eu.rekawek.coffeegb.gpu.ColorPalette;
import eu.rekawek.coffeegb.gpu.Display;
import eu.rekawek.coffeegb.gpu.IntQueue;
import eu.rekawek.coffeegb.gpu.Lcdc;
import eu.rekawek.coffeegb.gpu.PixelFifo;
import eu.rekawek.coffeegb.gpu.TileAttributes;

public class ColorPixelFifo
implements PixelFifo {
    private final IntQueue pixels = new IntQueue(16);
    private final IntQueue palettes = new IntQueue(16);
    private final IntQueue priorities = new IntQueue(16);
    private final Lcdc lcdc;
    private final Display display;
    private final ColorPalette bgPalette;
    private final ColorPalette oamPalette;

    public ColorPixelFifo(Lcdc lcdc, Display display, ColorPalette bgPalette, ColorPalette oamPalette) {
        this.lcdc = lcdc;
        this.display = display;
        this.bgPalette = bgPalette;
        this.oamPalette = oamPalette;
    }

    @Override
    public int getLength() {
        return this.pixels.size();
    }

    @Override
    public void putPixelToScreen() {
        this.display.putColorPixel(this.dequeuePixel());
    }

    private int dequeuePixel() {
        return this.getColor(this.priorities.dequeue(), this.palettes.dequeue(), this.pixels.dequeue());
    }

    @Override
    public void dropPixel() {
        this.dequeuePixel();
    }

    @Override
    public void enqueue8Pixels(int[] pixelLine, TileAttributes tileAttributes) {
        for (int p : pixelLine) {
            this.pixels.enqueue(p);
            this.palettes.enqueue(tileAttributes.getColorPaletteIndex());
            this.priorities.enqueue(tileAttributes.isPriority() ? 100 : -1);
        }
    }

    @Override
    public void setOverlay(int[] pixelLine, int offset, TileAttributes spriteAttr, int oamIndex) {
        for (int j = offset; j < pixelLine.length; ++j) {
            int p = pixelLine[j];
            int i = j - offset;
            if (p == 0) continue;
            int oldPriority = this.priorities.get(i);
            boolean put = false;
            if (!(oldPriority != -1 && oldPriority != 100 || this.lcdc.isBgAndWindowDisplay())) {
                put = true;
            } else if (oldPriority == 100) {
                put = this.pixels.get(i) == 0;
            } else if (oldPriority == -1 && !spriteAttr.isPriority()) {
                put = true;
            } else if (oldPriority == -1 && spriteAttr.isPriority() && this.pixels.get(i) == 0) {
                put = true;
            } else if (oldPriority >= 0 && oldPriority < 10) {
                boolean bl = put = oldPriority > oamIndex;
            }
            if (!put) continue;
            this.pixels.set(i, p);
            this.palettes.set(i, spriteAttr.getColorPaletteIndex());
            this.priorities.set(i, oamIndex);
        }
    }

    @Override
    public void clear() {
        this.pixels.clear();
        this.palettes.clear();
        this.priorities.clear();
    }

    private int getColor(int priority, int palette, int color) {
        if (priority >= 0 && priority < 10) {
            return this.oamPalette.getPalette(palette)[color];
        }
        return this.bgPalette.getPalette(palette)[color];
    }
}

