/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gui;

import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.controller.ButtonListener;
import eu.rekawek.coffeegb.controller.Controller;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class SwingController
implements Controller,
KeyListener {
    private static final Logger LOG = LoggerHelper.getLogger(SwingController.class);
    private ButtonListener listener;
    private Map<Integer, ButtonListener.Button> mapping;

    public static SwingController createController(Properties properties) {
        SwingController sc = new SwingController();
        EnumMap<ButtonListener.Button, Integer> buttonToKey = sc.addDefaultMapping();
        buttonToKey = sc.parseMappings(buttonToKey, properties);
        return sc;
    }

    public static SwingController createIntController(Properties properties) {
        SwingController sc = new SwingController();
        EnumMap<ButtonListener.Button, Integer> buttonToKey = sc.addDefaultMapping();
        buttonToKey = sc.parseMappings2(buttonToKey, properties);
        return sc;
    }

    private EnumMap<ButtonListener.Button, Integer> addDefaultMapping() {
        EnumMap<ButtonListener.Button, Integer> buttonToKey = new EnumMap<ButtonListener.Button, Integer>(ButtonListener.Button.class);
        buttonToKey.put(ButtonListener.Button.LEFT, 37);
        buttonToKey.put(ButtonListener.Button.RIGHT, 39);
        buttonToKey.put(ButtonListener.Button.UP, 38);
        buttonToKey.put(ButtonListener.Button.DOWN, 40);
        buttonToKey.put(ButtonListener.Button.A, 90);
        buttonToKey.put(ButtonListener.Button.B, 88);
        buttonToKey.put(ButtonListener.Button.START, 10);
        buttonToKey.put(ButtonListener.Button.SELECT, 8);
        return buttonToKey;
    }

    private EnumMap<ButtonListener.Button, Integer> parseMappings(EnumMap<ButtonListener.Button, Integer> buttonToKey, Properties properties) {
        for (String k : properties.stringPropertyNames()) {
            String v = properties.getProperty(k);
            if (!k.startsWith("btn_") || !v.startsWith("VK_")) continue;
            try {
                ButtonListener.Button button = ButtonListener.Button.valueOf(k.substring(4).toUpperCase());
                Field field = KeyEvent.class.getField(properties.getProperty(k));
                if (field.getType() != Integer.TYPE) continue;
                int value = field.getInt(null);
                buttonToKey.put(button, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
                LOG.error("Can't parse button configuration", (Throwable)e);
            }
        }
        this.mapping = buttonToKey.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        return buttonToKey;
    }

    private EnumMap<ButtonListener.Button, Integer> parseMappings2(EnumMap<ButtonListener.Button, Integer> buttonToKey, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String k;
            if (!(entry.getKey() instanceof String) || !(k = String.valueOf(entry.getKey())).startsWith("btn_")) continue;
            try {
                int v = Integer.valueOf(entry.getValue().toString());
                ButtonListener.Button button = ButtonListener.Button.valueOf(k.substring(4).toUpperCase());
                buttonToKey.put(button, v);
                LOG.debug("{} -> {}", (Object)k, (Object)v);
            }
            catch (Exception e) {
                LOG.debug("Ignoring button {}", (Object)k);
            }
        }
        this.mapping = buttonToKey.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        return buttonToKey;
    }

    @Override
    public void setButtonListener(ButtonListener listener) {
        this.listener = listener;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.listener == null) {
            return;
        }
        ButtonListener.Button b = this.getButton(e);
        if (b != null) {
            this.listener.onButtonPress(b);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.listener == null) {
            return;
        }
        ButtonListener.Button b = this.getButton(e);
        if (b != null) {
            this.listener.onButtonRelease(b);
        }
    }

    private ButtonListener.Button getButton(KeyEvent e) {
        return this.mapping.get(e.getKeyCode());
    }
}

