/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gui;

import eu.rekawek.coffeegb.gpu.Display;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class SwingDisplay
extends JPanel
implements Display,
Runnable {
    public static final int DISPLAY_WIDTH = 160;
    public static final int DISPLAY_HEIGHT = 144;
    private final BufferedImage img;
    public static final int[] COLORS = new int[]{15136986, 10078342, 4421993, 335658};
    private final int[] rgb;
    private boolean enabled;
    private int scale;
    private boolean doStop;
    private boolean doRefresh;
    private int i;

    public SwingDisplay(int scale) {
        GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        this.img = gfxConfig.createCompatibleImage(160, 144);
        this.rgb = new int[23040];
        this.scale = scale;
    }

    @Override
    public void putDmgPixel(int color) {
        this.rgb[this.i++] = COLORS[color];
        this.i %= this.rgb.length;
    }

    @Override
    public void putColorPixel(int gbcRgb) {
        this.rgb[this.i++] = SwingDisplay.translateGbcRgb(gbcRgb);
    }

    public static int translateGbcRgb(int gbcRgb) {
        int r = gbcRgb >> 0 & 0x1F;
        int g = gbcRgb >> 5 & 0x1F;
        int b = gbcRgb >> 10 & 0x1F;
        int result = r * 8 << 16;
        result |= g * 8 << 8;
        return result |= b * 8 << 0;
    }

    @Override
    public synchronized void requestRefresh() {
        this.doRefresh = true;
        this.notifyAll();
    }

    @Override
    public synchronized void waitForRefresh() {
        while (this.doRefresh) {
            try {
                this.wait(1L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Override
    public void enableLcd() {
        this.enabled = true;
    }

    @Override
    public void disableLcd() {
        this.enabled = false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.enabled) {
            g2d.drawImage(this.img, 0, 0, 160 * this.scale, 144 * this.scale, null);
        } else {
            g2d.setColor(new Color(COLORS[0]));
            g2d.drawRect(0, 0, 160 * this.scale, 144 * this.scale);
        }
        g2d.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.doStop = false;
        this.doRefresh = false;
        this.enabled = true;
        while (!this.doStop) {
            SwingDisplay swingDisplay = this;
            synchronized (swingDisplay) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (!this.doRefresh) continue;
            this.img.setRGB(0, 0, 160, 144, this.rgb, 0, 160);
            this.validate();
            this.repaint();
            swingDisplay = this;
            synchronized (swingDisplay) {
                this.i = 0;
                this.doRefresh = false;
                this.notifyAll();
            }
        }
    }

    @Override
    public void stop() {
        this.doStop = true;
    }
}

