/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory;

import eu.rekawek.coffeegb.AddressSpace;

public class GbcRam
implements AddressSpace {
    private int[] ram = new int[28672];
    private int svbk;

    @Override
    public boolean accepts(int address) {
        return address == 65392 || address >= 53248 && address < 57344;
    }

    @Override
    public void setByte(int address, int value) {
        if (address == 65392) {
            this.svbk = value;
        } else {
            this.ram[this.translate((int)address)] = value;
        }
    }

    @Override
    public int getByte(int address) {
        if (address == 65392) {
            return this.svbk;
        }
        return this.ram[this.translate(address)];
    }

    private int translate(int address) {
        int result;
        int ramBank = this.svbk & 7;
        if (ramBank == 0) {
            ramBank = 1;
        }
        if ((result = address - 53248 + (ramBank - 1) * 4096) < 0 || result >= this.ram.length) {
            throw new IllegalArgumentException();
        }
        return result;
    }
}

