/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory.cart.battery;

import com.google.common.io.ByteStreams;
import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.memory.cart.battery.Battery;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;

public class FileBattery
implements Battery {
    private static final Logger LOG = LoggerHelper.getLogger(FileBattery.class);
    private final File saveFile;

    public FileBattery(File parent, String baseName) {
        this.saveFile = new File(parent, baseName + ".sav");
    }

    @Override
    public void loadRam(int[] ram) {
        this.loadRamWithClock(ram, null);
    }

    @Override
    public void saveRam(int[] ram) {
        this.saveRamWithClock(ram, null);
    }

    @Override
    public void loadRamWithClock(int[] ram, long[] clockData) {
        if (!this.saveFile.exists()) {
            return;
        }
        long saveLength = this.saveFile.length();
        saveLength -= saveLength % 8192L;
        try (FileInputStream is = new FileInputStream(this.saveFile);){
            this.loadRam(ram, is, saveLength);
            if (clockData != null) {
                this.loadClock(clockData, is);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveRamWithClock(int[] ram, long[] clockData) {
        try (FileOutputStream os = new FileOutputStream(this.saveFile);){
            this.saveRam(ram, os);
            if (clockData != null) {
                this.saveClock(clockData, os);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadClock(long[] clockData, InputStream is) throws IOException {
        byte[] byteBuff = new byte[4 * clockData.length];
        ByteStreams.readFully((InputStream)is, (byte[])byteBuff);
        ByteBuffer buff = ByteBuffer.wrap(byteBuff);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (buff.hasRemaining()) {
            clockData[i++] = buff.getInt() & 0xFFFFFFFF;
        }
    }

    private void saveClock(long[] clockData, OutputStream os) throws IOException {
        byte[] byteBuff = new byte[4 * clockData.length];
        ByteBuffer buff = ByteBuffer.wrap(byteBuff);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        for (long d : clockData) {
            buff.putInt((int)d);
        }
        os.write(byteBuff);
    }

    private void loadRam(int[] ram, InputStream is, long length) throws IOException {
        byte[] buffer = new byte[ram.length];
        ByteStreams.read((InputStream)is, (byte[])buffer, (int)0, (int)Math.min((int)length, ram.length));
        for (int i = 0; i < ram.length; ++i) {
            ram[i] = buffer[i] & 0xFF;
        }
    }

    private void saveRam(int[] ram, OutputStream os) throws IOException {
        byte[] buffer = new byte[ram.length];
        for (int i = 0; i < ram.length; ++i) {
            buffer[i] = (byte)ram[i];
        }
        os.write(buffer);
    }
}

