/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory.cart.rtc;

import eu.rekawek.coffeegb.memory.cart.rtc.Clock;

public class RealTimeClock {
    private final Clock clock;
    private long offsetSec;
    private long clockStart;
    private boolean halt;
    private long latchStart;
    private int haltSeconds;
    private int haltMinutes;
    private int haltHours;
    private int haltDays;

    public RealTimeClock(Clock clock) {
        this.clock = clock;
        this.clockStart = clock.currentTimeMillis();
    }

    public void latch() {
        this.latchStart = this.clock.currentTimeMillis();
    }

    public void unlatch() {
        this.latchStart = 0L;
    }

    public int getSeconds() {
        return (int)(this.clockTimeInSec() % 60L);
    }

    public int getMinutes() {
        return (int)(this.clockTimeInSec() % 3600L / 60L);
    }

    public int getHours() {
        return (int)(this.clockTimeInSec() % 86400L / 3600L);
    }

    public int getDayCounter() {
        return (int)(this.clockTimeInSec() % 44236800L / 86400L);
    }

    public boolean isHalt() {
        return this.halt;
    }

    public boolean isCounterOverflow() {
        return this.clockTimeInSec() >= 44236800L;
    }

    public void setSeconds(int seconds) {
        if (!this.halt) {
            return;
        }
        this.haltSeconds = seconds;
    }

    public void setMinutes(int minutes) {
        if (!this.halt) {
            return;
        }
        this.haltMinutes = minutes;
    }

    public void setHours(int hours) {
        if (!this.halt) {
            return;
        }
        this.haltHours = hours;
    }

    public void setDayCounter(int dayCounter) {
        if (!this.halt) {
            return;
        }
        this.haltDays = dayCounter;
    }

    public void setHalt(boolean halt) {
        if (halt && !this.halt) {
            this.latch();
            this.haltSeconds = this.getSeconds();
            this.haltMinutes = this.getMinutes();
            this.haltHours = this.getHours();
            this.haltDays = this.getDayCounter();
            this.unlatch();
        } else if (!halt && this.halt) {
            this.offsetSec = this.haltSeconds + this.haltMinutes * 60 + this.haltHours * 60 * 60 + this.haltDays * 60 * 60 * 24;
            this.clockStart = this.clock.currentTimeMillis();
        }
        this.halt = halt;
    }

    public void clearCounterOverflow() {
        while (this.isCounterOverflow()) {
            this.offsetSec -= 44236800L;
        }
    }

    private long clockTimeInSec() {
        long now = this.latchStart == 0L ? this.clock.currentTimeMillis() : this.latchStart;
        return (now - this.clockStart) / 1000L + this.offsetSec;
    }

    public void deserialize(long[] clockData) {
        long seconds = clockData[0];
        long minutes = clockData[1];
        long hours = clockData[2];
        long days = clockData[3];
        long daysHigh = clockData[4];
        long timestamp = clockData[10];
        this.clockStart = timestamp * 1000L;
        this.offsetSec = seconds + minutes * 60L + hours * 60L * 60L + days * 24L * 60L * 60L + daysHigh * 256L * 24L * 60L * 60L;
    }

    public long[] serialize() {
        long[] clockData = new long[11];
        this.latch();
        clockData[0] = clockData[5] = (long)this.getSeconds();
        clockData[1] = clockData[6] = (long)this.getMinutes();
        clockData[2] = clockData[7] = (long)this.getHours();
        clockData[3] = clockData[8] = (long)(this.getDayCounter() % 256);
        clockData[4] = clockData[9] = (long)(this.getDayCounter() / 256);
        clockData[10] = this.latchStart / 1000L;
        this.unlatch();
        return clockData;
    }
}

