/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory.cart.type;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.memory.cart.CartridgeType;
import eu.rekawek.coffeegb.memory.cart.battery.Battery;
import org.slf4j.Logger;

public class Mbc1
implements AddressSpace {
    private static final Logger LOG = LoggerHelper.getLogger(Mbc1.class);
    private static int[] NINTENDO_LOGO = new int[]{206, 237, 102, 102, 204, 13, 0, 11, 3, 115, 0, 131, 0, 12, 0, 13, 0, 8, 17, 31, 136, 137, 0, 14, 220, 204, 110, 230, 221, 221, 217, 153, 187, 187, 103, 99, 110, 14, 236, 204, 221, 220, 153, 159, 187, 185, 51, 62};
    private final CartridgeType type;
    private final int romBanks;
    private final int ramBanks;
    private final int[] cartridge;
    private final int[] ram;
    private final Battery battery;
    private final boolean multicart;
    private int selectedRamBank;
    private int selectedRomBank = 1;
    private int memoryModel;
    private boolean ramWriteEnabled;
    private int cachedRomBankFor0x0000 = -1;
    private int cachedRomBankFor0x4000 = -1;

    public Mbc1(int[] cartridge, CartridgeType type, Battery battery, int romBanks, int ramBanks) {
        this.multicart = romBanks == 64 && Mbc1.isMulticart(cartridge);
        this.cartridge = cartridge;
        this.ramBanks = ramBanks;
        this.romBanks = romBanks;
        this.ram = new int[8192 * this.ramBanks];
        for (int i = 0; i < this.ram.length; ++i) {
            this.ram[i] = 255;
        }
        this.type = type;
        this.battery = battery;
        battery.loadRam(this.ram);
    }

    @Override
    public boolean accepts(int address) {
        return address >= 0 && address < 32768 || address >= 40960 && address < 49152;
    }

    @Override
    public void setByte(int address, int value) {
        int ramAddress;
        if (address >= 0 && address < 8192) {
            boolean bl = this.ramWriteEnabled = (value & 0xF) == 10;
            if (!this.ramWriteEnabled) {
                this.battery.saveRam(this.ram);
            }
            LOG.trace("RAM write: {}", (Object)this.ramWriteEnabled);
        } else if (address >= 8192 && address < 16384) {
            LOG.trace("Low 5 bits of ROM bank: {}", (Object)(value & 0x1F));
            int bank = this.selectedRomBank & 0x60;
            this.selectRomBank(bank |= value & 0x1F);
            this.cachedRomBankFor0x4000 = -1;
            this.cachedRomBankFor0x0000 = -1;
        } else if (address >= 16384 && address < 24576 && this.memoryModel == 0) {
            LOG.trace("High 2 bits of ROM bank: {}", (Object)((value & 3) << 5));
            int bank = this.selectedRomBank & 0x1F;
            this.selectRomBank(bank |= (value & 3) << 5);
            this.cachedRomBankFor0x4000 = -1;
            this.cachedRomBankFor0x0000 = -1;
        } else if (address >= 16384 && address < 24576 && this.memoryModel == 1) {
            int bank;
            LOG.trace("RAM bank: {}", (Object)(value & 3));
            this.selectedRamBank = bank = value & 3;
            this.cachedRomBankFor0x4000 = -1;
            this.cachedRomBankFor0x0000 = -1;
        } else if (address >= 24576 && address < 32768) {
            LOG.trace("Memory mode: {}", (Object)(value & 1));
            this.memoryModel = value & 1;
            this.cachedRomBankFor0x4000 = -1;
            this.cachedRomBankFor0x0000 = -1;
        } else if (address >= 40960 && address < 49152 && this.ramWriteEnabled && (ramAddress = this.getRamAddress(address)) < this.ram.length) {
            this.ram[ramAddress] = value;
        }
    }

    private void selectRomBank(int bank) {
        this.selectedRomBank = bank;
        LOG.trace("Selected ROM bank: {}", (Object)this.selectedRomBank);
    }

    @Override
    public int getByte(int address) {
        if (address >= 0 && address < 16384) {
            return this.getRomByte(this.getRomBankFor0x0000(), address);
        }
        if (address >= 16384 && address < 32768) {
            return this.getRomByte(this.getRomBankFor0x4000(), address - 16384);
        }
        if (address >= 40960 && address < 49152) {
            if (this.ramWriteEnabled) {
                int ramAddress = this.getRamAddress(address);
                if (ramAddress < this.ram.length) {
                    return this.ram[ramAddress];
                }
                return 255;
            }
            return 255;
        }
        throw new IllegalArgumentException(Integer.toHexString(address));
    }

    private int getRomBankFor0x0000() {
        if (this.cachedRomBankFor0x0000 == -1) {
            if (this.memoryModel == 0) {
                this.cachedRomBankFor0x0000 = 0;
            } else {
                int bank = this.selectedRamBank << 5;
                if (this.multicart) {
                    bank >>= 1;
                }
                this.cachedRomBankFor0x0000 = bank %= this.romBanks;
            }
        }
        return this.cachedRomBankFor0x0000;
    }

    private int getRomBankFor0x4000() {
        if (this.cachedRomBankFor0x4000 == -1) {
            int bank = this.selectedRomBank;
            if (bank % 32 == 0) {
                ++bank;
            }
            if (this.memoryModel == 1) {
                bank &= 0x1F;
                bank |= this.selectedRamBank << 5;
            }
            if (this.multicart) {
                bank = bank >> 1 & 0x30 | bank & 0xF;
            }
            this.cachedRomBankFor0x4000 = bank %= this.romBanks;
        }
        return this.cachedRomBankFor0x4000;
    }

    private int getRomByte(int bank, int address) {
        int cartOffset = bank * 16384 + address;
        if (cartOffset < this.cartridge.length) {
            return this.cartridge[cartOffset];
        }
        return 255;
    }

    private int getRamAddress(int address) {
        if (this.memoryModel == 0) {
            return address - 40960;
        }
        return this.selectedRamBank % this.ramBanks * 8192 + (address - 40960);
    }

    private static boolean isMulticart(int[] rom) {
        int logoCount = 0;
        for (int i = 0; i < rom.length; i += 16384) {
            boolean logoMatches = true;
            for (int j = 0; j < NINTENDO_LOGO.length; ++j) {
                if (rom[i + 260 + j] == NINTENDO_LOGO[j]) continue;
                logoMatches = false;
                break;
            }
            if (!logoMatches) continue;
            ++logoCount;
        }
        return logoCount > 1;
    }
}

