/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.serial;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.cpu.InterruptManager;
import eu.rekawek.coffeegb.cpu.SpeedMode;
import eu.rekawek.coffeegb.serial.SerialEndpoint;
import java.io.IOException;
import org.slf4j.Logger;

public class SerialPort
implements AddressSpace {
    private static final Logger LOG = LoggerHelper.getLogger(SerialPort.class);
    private final SerialEndpoint serialEndpoint;
    private final InterruptManager interruptManager;
    private final SpeedMode speedMode;
    private int sb;
    private int sc;
    private boolean transferInProgress;
    private int divider;

    public SerialPort(InterruptManager interruptManager, SerialEndpoint serialEndpoint, SpeedMode speedMode) {
        this.interruptManager = interruptManager;
        this.serialEndpoint = serialEndpoint;
        this.speedMode = speedMode;
    }

    public void tick() {
        if (!this.transferInProgress) {
            return;
        }
        if (++this.divider >= 512 / this.speedMode.getSpeedMode()) {
            this.transferInProgress = false;
            try {
                this.sb = this.serialEndpoint.transfer(this.sb);
            }
            catch (IOException e) {
                LOG.error("Can't transfer byte", (Throwable)e);
                this.sb = 0;
            }
            this.interruptManager.requestInterrupt(InterruptManager.InterruptType.Serial);
        }
    }

    @Override
    public boolean accepts(int address) {
        return address == 65281 || address == 65282;
    }

    @Override
    public void setByte(int address, int value) {
        if (address == 65281) {
            this.sb = value;
        } else if (address == 65282) {
            this.sc = value;
            if ((this.sc & 0x80) != 0) {
                this.startTransfer();
            }
        }
    }

    @Override
    public int getByte(int address) {
        if (address == 65281) {
            return this.sb;
        }
        if (address == 65282) {
            return this.sc | 0x7E;
        }
        throw new IllegalArgumentException();
    }

    private void startTransfer() {
        this.transferInProgress = true;
        this.divider = 0;
    }
}

