/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.sound;

public class LengthCounter {
    private final int DIVIDER = 16384;
    private final int fullLength;
    private int length;
    private long i;
    private boolean enabled;

    public LengthCounter(int fullLength) {
        this.fullLength = fullLength;
    }

    public void start() {
        this.i = 8192L;
    }

    public void tick() {
        if (++this.i == 16384L) {
            this.i = 0L;
            if (this.enabled && this.length > 0) {
                --this.length;
            }
        }
    }

    public void setLength(int length) {
        this.length = length == 0 ? this.fullLength : length;
    }

    public void setNr4(int value) {
        boolean trigger;
        boolean enable = (value & 0x40) != 0;
        boolean bl = trigger = (value & 0x80) != 0;
        if (this.enabled) {
            if (this.length == 0 && trigger) {
                if (enable && this.i < 8192L) {
                    this.setLength(this.fullLength - 1);
                } else {
                    this.setLength(this.fullLength);
                }
            }
        } else if (enable) {
            if (this.length > 0 && this.i < 8192L) {
                --this.length;
            }
            if (this.length == 0 && trigger && this.i < 8192L) {
                this.setLength(this.fullLength - 1);
            }
        } else if (this.length == 0 && trigger) {
            this.setLength(this.fullLength);
        }
        this.enabled = enable;
    }

    public int getValue() {
        return this.length;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return String.format("LengthCounter[l=%d,f=%d,c=%d,%s]", this.length, this.fullLength, this.i, this.enabled ? "enabled" : "disabled");
    }

    void reset() {
        this.enabled = true;
        this.i = 0L;
        this.length = 0;
    }
}

