/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.sound;

import eu.rekawek.coffeegb.sound.AbstractSoundMode;
import eu.rekawek.coffeegb.sound.FrequencySweep;
import eu.rekawek.coffeegb.sound.VolumeEnvelope;

public class SoundMode1
extends AbstractSoundMode {
    private int freqDivider;
    private int lastOutput;
    private int i;
    private FrequencySweep frequencySweep = new FrequencySweep();
    private VolumeEnvelope volumeEnvelope = new VolumeEnvelope();

    public SoundMode1(boolean gbc) {
        super(65296, 64, gbc);
    }

    @Override
    public void start() {
        this.i = 0;
        if (this.gbc) {
            this.length.reset();
        }
        this.length.start();
        this.frequencySweep.start();
        this.volumeEnvelope.start();
    }

    @Override
    public void trigger() {
        this.i = 0;
        this.freqDivider = 1;
        this.volumeEnvelope.trigger();
    }

    @Override
    public int tick() {
        this.volumeEnvelope.tick();
        boolean e = true;
        e = this.updateLength() && e;
        e = this.updateSweep() && e;
        boolean bl = e = this.dacEnabled && e;
        if (!e) {
            return 0;
        }
        if (--this.freqDivider == 0) {
            this.resetFreqDivider();
            this.lastOutput = (this.getDuty() & 1 << this.i) >> this.i;
            this.i = (this.i + 1) % 8;
        }
        return this.lastOutput * this.volumeEnvelope.getVolume();
    }

    @Override
    protected void setNr0(int value) {
        super.setNr0(value);
        this.frequencySweep.setNr10(value);
    }

    @Override
    protected void setNr1(int value) {
        super.setNr1(value);
        this.length.setLength(64 - (value & 0x3F));
    }

    @Override
    protected void setNr2(int value) {
        super.setNr2(value);
        this.volumeEnvelope.setNr2(value);
        this.dacEnabled = (value & 0xF8) != 0;
        this.channelEnabled &= this.dacEnabled;
    }

    @Override
    protected void setNr3(int value) {
        super.setNr3(value);
        this.frequencySweep.setNr13(value);
    }

    @Override
    protected void setNr4(int value) {
        super.setNr4(value);
        this.frequencySweep.setNr14(value);
    }

    @Override
    protected int getNr3() {
        return this.frequencySweep.getNr13();
    }

    @Override
    protected int getNr4() {
        return super.getNr4() & 0xF8 | this.frequencySweep.getNr14() & 7;
    }

    private int getDuty() {
        switch (this.getNr1() >> 6) {
            case 0: {
                return 1;
            }
            case 1: {
                return 129;
            }
            case 2: {
                return 135;
            }
            case 3: {
                return 126;
            }
        }
        throw new IllegalStateException();
    }

    private void resetFreqDivider() {
        this.freqDivider = this.getFrequency() * 4;
    }

    protected boolean updateSweep() {
        this.frequencySweep.tick();
        if (this.channelEnabled && !this.frequencySweep.isEnabled()) {
            this.channelEnabled = false;
        }
        return this.channelEnabled;
    }
}

