/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.sound;

import eu.rekawek.coffeegb.sound.AbstractSoundMode;
import eu.rekawek.coffeegb.sound.Lfsr;
import eu.rekawek.coffeegb.sound.PolynomialCounter;
import eu.rekawek.coffeegb.sound.VolumeEnvelope;

public class SoundMode4
extends AbstractSoundMode {
    private VolumeEnvelope volumeEnvelope;
    private PolynomialCounter polynomialCounter;
    private int lastResult;
    private Lfsr lfsr = new Lfsr();

    public SoundMode4(boolean gbc) {
        super(65311, 64, gbc);
        this.volumeEnvelope = new VolumeEnvelope();
        this.polynomialCounter = new PolynomialCounter();
    }

    @Override
    public void start() {
        if (this.gbc) {
            this.length.reset();
        }
        this.length.start();
        this.lfsr.start();
        this.volumeEnvelope.start();
    }

    @Override
    public void trigger() {
        this.lfsr.reset();
        this.volumeEnvelope.trigger();
    }

    @Override
    public int tick() {
        this.volumeEnvelope.tick();
        if (!this.updateLength()) {
            return 0;
        }
        if (!this.dacEnabled) {
            return 0;
        }
        if (this.polynomialCounter.tick()) {
            this.lastResult = this.lfsr.nextBit((this.nr3 & 8) != 0);
        }
        return this.lastResult * this.volumeEnvelope.getVolume();
    }

    @Override
    protected void setNr1(int value) {
        super.setNr1(value);
        this.length.setLength(64 - (value & 0x3F));
    }

    @Override
    protected void setNr2(int value) {
        super.setNr2(value);
        this.volumeEnvelope.setNr2(value);
        this.dacEnabled = (value & 0xF8) != 0;
        this.channelEnabled &= this.dacEnabled;
    }

    @Override
    protected void setNr3(int value) {
        super.setNr3(value);
        this.polynomialCounter.setNr43(value);
    }
}

