/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.sound;

public class VolumeEnvelope {
    private int initialVolume;
    private int envelopeDirection;
    private int sweep;
    private int volume;
    private int i;
    private boolean finished;

    public void setNr2(int register) {
        this.initialVolume = register >> 4;
        this.envelopeDirection = (register & 8) == 0 ? -1 : 1;
        this.sweep = register & 7;
    }

    public boolean isEnabled() {
        return this.sweep > 0;
    }

    public void start() {
        this.finished = true;
        this.i = 8192;
    }

    public void trigger() {
        this.volume = this.initialVolume;
        this.i = 0;
        this.finished = false;
    }

    public void tick() {
        if (this.finished) {
            return;
        }
        if (this.volume == 0 && this.envelopeDirection == -1 || this.volume == 15 && this.envelopeDirection == 1) {
            this.finished = true;
            return;
        }
        if (++this.i == this.sweep * 0x400000 / 64) {
            this.i = 0;
            this.volume += this.envelopeDirection;
        }
    }

    public int getVolume() {
        if (this.isEnabled()) {
            return this.volume;
        }
        return this.initialVolume;
    }
}

