/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.Timer;

public class SquareTimer
extends Timer {
    protected int[] values;
    private final int periodadd;
    private int divider = 0;

    @Override
    public final void clock() {
        if (this.period + this.periodadd <= 0) {
            return;
        }
        ++this.divider;
        int periods = (this.divider + this.period + this.periodadd) / (this.period + this.periodadd);
        if (periods < 0) {
            periods = 0;
        }
        this.position = (this.position + periods) % this.values.length;
        this.divider -= (this.period + this.periodadd) * periods;
    }

    @Override
    public final void clock(int cycles) {
        if (this.period < 8) {
            return;
        }
        this.divider += cycles;
        int periods = (this.divider + this.period + this.periodadd) / (this.period + this.periodadd);
        if (periods < 0) {
            periods = 0;
        }
        this.position = (this.position + periods) % this.values.length;
        this.divider -= (this.period + this.periodadd) * periods;
    }

    public SquareTimer(int ctrlen, int periodadd) {
        this.periodadd = periodadd;
        this.values = new int[ctrlen];
        this.period = 0;
        this.position = 0;
        this.setduty(ctrlen / 2);
    }

    public SquareTimer(int ctrlen) {
        this.periodadd = 0;
        this.values = new int[ctrlen];
        this.period = 0;
        this.position = 0;
        this.setduty(ctrlen / 2);
    }

    @Override
    public final void reset() {
        this.position = 0;
    }

    @Override
    public final void setduty(int duty) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = i < duty ? 1 : 0;
        }
    }

    @Override
    public final void setduty(int[] dutyarray) {
        this.values = dutyarray;
    }

    @Override
    public final int getval() {
        return this.values[this.position];
    }

    @Override
    public final void setperiod(int newperiod) {
        this.period = newperiod;
    }
}

